/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.config.adapter;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.config.adapter.ConfigurationAdapter;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.lib.configurate.ConfigurationNode;
import me.lucko.luckperms.lib.configurate.loader.ConfigurationLoader;

public abstract class ConfigurateConfigAdapter
implements ConfigurationAdapter {
    private final LuckPermsPlugin plugin;
    private final Path path;
    private ConfigurationNode root;

    public ConfigurateConfigAdapter(LuckPermsPlugin plugin, Path path) {
        this.plugin = plugin;
        this.path = path;
        this.reload();
    }

    protected abstract ConfigurationLoader<? extends ConfigurationNode> createLoader(Path var1);

    @Override
    public void reload() {
        ConfigurationLoader<? extends ConfigurationNode> loader = this.createLoader(this.path);
        try {
            this.root = loader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ConfigurationNode resolvePath(String path) {
        if (this.root == null) {
            throw new RuntimeException("Config is not loaded.");
        }
        return this.root.getNode(Splitter.on((char)'.').splitToList((CharSequence)path).toArray());
    }

    @Override
    public String getString(String path, String def) {
        return this.resolvePath(path).getString(def);
    }

    @Override
    public int getInteger(String path, int def) {
        return this.resolvePath(path).getInt(def);
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        return this.resolvePath(path).getBoolean(def);
    }

    @Override
    public List<String> getStringList(String path, List<String> def) {
        ConfigurationNode node = this.resolvePath(path);
        if (node.isVirtual()) {
            return def;
        }
        return node.getList(Object::toString);
    }

    @Override
    public List<String> getKeys(String path, List<String> def) {
        ConfigurationNode node = this.resolvePath(path);
        if (node.isVirtual()) {
            return def;
        }
        return node.getChildrenMap().keySet().stream().map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> getStringMap(String path, Map<String, String> def) {
        ConfigurationNode node = this.resolvePath(path);
        if (node.isVirtual()) {
            return def;
        }
        Map m = (Map)node.getValue(Collections.emptyMap());
        return m.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().toString()));
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }
}

