/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.dependencies;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.lucko.luckperms.common.dependencies.Dependency;
import me.lucko.luckperms.common.dependencies.DependencyRegistry;
import me.lucko.luckperms.common.dependencies.classloader.IsolatedClassLoader;
import me.lucko.luckperms.common.dependencies.relocation.Relocation;
import me.lucko.luckperms.common.dependencies.relocation.RelocationHandler;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.StorageType;
import me.lucko.luckperms.common.utils.MoreFiles;

public class DependencyManager {
    private final LuckPermsPlugin plugin;
    private final MessageDigest digest;
    private final DependencyRegistry registry;
    private final EnumMap<Dependency, Path> loaded = new EnumMap(Dependency.class);
    private final Map<ImmutableSet<Dependency>, IsolatedClassLoader> loaders = new HashMap<ImmutableSet<Dependency>, IsolatedClassLoader>();
    private RelocationHandler relocationHandler = null;

    public DependencyManager(LuckPermsPlugin plugin) {
        this.plugin = plugin;
        try {
            this.digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.registry = new DependencyRegistry(plugin);
    }

    private synchronized RelocationHandler getRelocationHandler() {
        if (this.relocationHandler == null) {
            this.relocationHandler = new RelocationHandler(this);
        }
        return this.relocationHandler;
    }

    private Path getSaveDirectory() {
        Path saveDirectory = this.plugin.getBootstrap().getDataDirectory().resolve("lib");
        try {
            MoreFiles.createDirectoriesIfNotExists(saveDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create lib directory", e);
        }
        return saveDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IsolatedClassLoader obtainClassLoaderWith(Set<Dependency> dependencies) {
        ImmutableSet set = ImmutableSet.copyOf(dependencies);
        for (Dependency dependency : dependencies) {
            if (this.loaded.containsKey((Object)dependency)) continue;
            throw new IllegalStateException("Dependency " + (Object)((Object)dependency) + " is not loaded.");
        }
        Map<ImmutableSet<Dependency>, IsolatedClassLoader> map = this.loaders;
        synchronized (map) {
            IsolatedClassLoader classLoader = this.loaders.get(set);
            if (classLoader != null) {
                return classLoader;
            }
            URL[] urls = (URL[])set.stream().map(this.loaded::get).map(file -> {
                try {
                    return file.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new);
            classLoader = new IsolatedClassLoader(urls);
            this.loaders.put((ImmutableSet<Dependency>)set, classLoader);
            return classLoader;
        }
    }

    public void loadStorageDependencies(Set<StorageType> storageTypes) {
        this.loadDependencies(this.registry.resolveStorageDependencies(storageTypes));
    }

    public void loadDependencies(Set<Dependency> dependencies) {
        Path saveDirectory = this.getSaveDirectory();
        ArrayList<Source> sources = new ArrayList<Source>();
        for (Dependency dependency : dependencies) {
            if (this.loaded.containsKey((Object)dependency)) continue;
            try {
                Path file = this.downloadDependency(saveDirectory, dependency);
                sources.add(new Source(dependency, file));
            }
            catch (Throwable e) {
                this.plugin.getLogger().severe("Exception whilst downloading dependency " + dependency.name());
                e.printStackTrace();
            }
        }
        ArrayList<Source> remappedJars = new ArrayList<Source>(sources.size());
        for (Source source : sources) {
            try {
                ArrayList<Relocation> relocations = new ArrayList<Relocation>(source.dependency.getRelocations());
                this.registry.applyRelocationSettings(source.dependency, relocations);
                if (relocations.isEmpty()) {
                    remappedJars.add(source);
                    continue;
                }
                Path input = source.file;
                Path output = input.getParent().resolve("remapped-" + input.getFileName().toString());
                if (Files.exists(output, new LinkOption[0])) {
                    remappedJars.add(new Source(source.dependency, output));
                    continue;
                }
                RelocationHandler relocationHandler = this.getRelocationHandler();
                this.plugin.getLogger().info("Attempting to apply relocations to " + input.getFileName().toString() + "...");
                relocationHandler.remap(input, output, relocations);
                remappedJars.add(new Source(source.dependency, output));
            }
            catch (Throwable e) {
                this.plugin.getLogger().severe("Unable to remap the source file '" + source.dependency.name() + "'.");
                e.printStackTrace();
            }
        }
        for (Source source : remappedJars) {
            if (!DependencyRegistry.shouldAutoLoad(source.dependency)) {
                this.loaded.put(source.dependency, source.file);
                continue;
            }
            try {
                this.plugin.getBootstrap().getPluginClassLoader().loadJar(source.file);
                this.loaded.put(source.dependency, source.file);
            }
            catch (Throwable e) {
                this.plugin.getLogger().severe("Failed to load dependency jar '" + source.file.getFileName().toString() + "'.");
                e.printStackTrace();
            }
        }
    }

    private Path downloadDependency(Path saveDirectory, Dependency dependency) throws Exception {
        String fileName = dependency.name().toLowerCase() + "-" + dependency.getVersion() + ".jar";
        Path file = saveDirectory.resolve(fileName);
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        URL url = new URL(dependency.getUrl());
        try (InputStream in = url.openStream();){
            byte[] bytes = ByteStreams.toByteArray((InputStream)in);
            if (bytes.length == 0) {
                throw new RuntimeException("Empty stream");
            }
            byte[] hash = this.digest.digest(bytes);
            if (!Arrays.equals(hash, dependency.getChecksum())) {
                throw new RuntimeException("Downloaded file had an invalid hash. Expected: " + Base64.getEncoder().encodeToString(dependency.getChecksum()) + " Actual: " + Base64.getEncoder().encodeToString(hash));
            }
            this.plugin.getLogger().info("Successfully downloaded '" + fileName + "' with matching checksum: " + Base64.getEncoder().encodeToString(hash));
            Files.write(file, bytes, new OpenOption[0]);
        }
        if (!Files.exists(file, new LinkOption[0])) {
            throw new IllegalStateException("File not present. - " + file.toString());
        }
        return file;
    }

    private static final class Source {
        private final Dependency dependency;
        private final Path file;

        private Source(Dependency dependency, Path file) {
            this.dependency = dependency;
            this.file = file;
        }
    }
}

