/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.dependencies.classloader;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import me.lucko.luckperms.common.dependencies.classloader.PluginClassLoader;

public class ReflectionClassLoader
implements PluginClassLoader {
    private static final Method ADD_URL_METHOD;
    private final URLClassLoader classLoader;

    public ReflectionClassLoader(Object plugin) throws IllegalStateException {
        ClassLoader classLoader = plugin.getClass().getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            throw new IllegalStateException("ClassLoader is not instance of URLClassLoader");
        }
        this.classLoader = (URLClassLoader)classLoader;
    }

    @Override
    public void loadJar(Path file) {
        try {
            ADD_URL_METHOD.invoke((Object)this.classLoader, file.toUri().toURL());
        }
        catch (IllegalAccessException | InvocationTargetException | MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            ADD_URL_METHOD = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            ADD_URL_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

