/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.inheritance;

import java.util.Comparator;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.User;

public class InheritanceComparator
implements Comparator<Group> {
    private static final Comparator<Group> NULL_ORIGIN = new InheritanceComparator(null);
    private final User origin;

    public static Comparator<Group> getFor(PermissionHolder origin) {
        if (origin.getType().isUser()) {
            return new InheritanceComparator((User)origin);
        }
        return NULL_ORIGIN;
    }

    private InheritanceComparator(User origin) {
        this.origin = origin;
    }

    @Override
    public int compare(Group o1, Group o2) {
        int result = Integer.compare(o1.getWeight().orElse(0), o2.getWeight().orElse(0));
        if (result != 0) {
            return -result;
        }
        if (this.origin != null && (result = -Boolean.compare(o1.getName().equalsIgnoreCase(this.origin.getPrimaryGroup().getStoredValue().orElse("default")), o2.getName().equalsIgnoreCase(this.origin.getPrimaryGroup().getStoredValue().orElse("default")))) != 0) {
            return result;
        }
        return o1.getName().compareTo(o2.getName());
    }
}

