/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.locale;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.command.CommandSpecData;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import org.yaml.snakeyaml.Yaml;

public class LocaleManager {
    private Map<Message, String> messages = ImmutableMap.of();
    private Map<CommandSpec, CommandSpecData> commands = ImmutableMap.of();

    public void tryLoad(LuckPermsPlugin plugin, Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            plugin.getLogger().info("Found lang.yml - loading messages...");
            try {
                this.loadFromFile(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void loadFromFile(Path file) throws Exception {
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            EnumMap<Message, String> messages = new EnumMap<Message, String>(Message.class);
            EnumMap<CommandSpec, CommandSpecData> commands = new EnumMap<CommandSpec, CommandSpecData>(CommandSpec.class);
            Map data = (Map)new Yaml().load((Reader)reader);
            for (Map.Entry entry : data.entrySet()) {
                if (entry.getKey() == null || ((String)entry.getKey()).isEmpty() || entry.getValue() == null) continue;
                if (entry.getValue() instanceof String) {
                    String key = ((String)entry.getKey()).toUpperCase().replace('-', '_');
                    String value = (String)entry.getValue();
                    try {
                        messages.put(Message.valueOf(key), value);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (!((String)entry.getKey()).equals("command-specs") || !(entry.getValue() instanceof Map)) continue;
                Map commandKeys = (Map)entry.getValue();
                for (Map.Entry commandKey : commandKeys.entrySet()) {
                    try {
                        String id = (String)commandKey.getKey();
                        Map attributes = (Map)commandKey.getValue();
                        CommandSpec spec = CommandSpec.valueOf(id.toUpperCase().replace('-', '_'));
                        String description = (String)attributes.get("description");
                        String usage = (String)attributes.get("usage");
                        Map args = (Map)attributes.get("args");
                        if (args != null && args.isEmpty()) {
                            args = null;
                        }
                        CommandSpecData specData = new CommandSpecData(description, usage, (Map<String, String>)(args == null ? null : ImmutableMap.copyOf((Map)args)));
                        commands.put(spec, specData);
                    }
                    catch (IllegalArgumentException id) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.messages = ImmutableMap.copyOf(messages);
            this.commands = ImmutableMap.copyOf(commands);
        }
    }

    public String getTranslation(Message key) {
        return this.messages.get((Object)key);
    }

    public CommandSpecData getTranslation(CommandSpec key) {
        return this.commands.get((Object)key);
    }
}

