/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.locale.command;

import com.google.common.collect.ImmutableList;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.message.Message;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Argument {
    private final String name;
    private final boolean required;
    private final String description;

    public static Argument create(String name, boolean required, String description) {
        return new Argument(name, required, description);
    }

    public static ImmutableList<Argument> list(Argument ... args) {
        return ImmutableList.copyOf((Object[])args);
    }

    private Argument(String name, boolean required, String description) {
        this.name = name;
        this.required = required;
        this.description = description;
    }

    public String asPrettyString(@Nullable LocaleManager localeManager) {
        return (this.required ? Message.REQUIRED_ARGUMENT : Message.OPTIONAL_ARGUMENT).asString(localeManager, this.name);
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDescription() {
        return this.description;
    }
}

