/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.locale.command;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.Argument;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.command.CommandSpecData;

public class LocalizedCommandSpec {
    private final LocaleManager localeManager;
    private final CommandSpec spec;

    public LocalizedCommandSpec(CommandSpec spec, LocaleManager localeManager) {
        this.localeManager = localeManager;
        this.spec = spec;
    }

    public String description() {
        CommandSpecData translation = this.localeManager.getTranslation(this.spec);
        if (translation != null && translation.getDescription() != null) {
            return translation.getDescription();
        }
        return this.spec.getDescription();
    }

    public String usage() {
        CommandSpecData translation = this.localeManager.getTranslation(this.spec);
        if (translation != null && translation.getUsage() != null) {
            return translation.getUsage();
        }
        return this.spec.getUsage();
    }

    public List<Argument> args() {
        CommandSpecData translation = this.localeManager.getTranslation(this.spec);
        if (translation == null || translation.getArgs() == null) {
            return this.spec.getArgs();
        }
        ArrayList<Argument> args = new ArrayList<Argument>(this.spec.getArgs());
        ListIterator<Argument> it = args.listIterator();
        while (it.hasNext()) {
            Argument next = (Argument)it.next();
            String s = translation.getArgs().get(next.getName());
            if (s == null) continue;
            it.set(Argument.create(next.getName(), next.isRequired(), s));
        }
        return ImmutableList.copyOf(args);
    }

    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }
}

