/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.messaging;

import com.google.common.base.Preconditions;
import me.lucko.luckperms.api.messenger.IncomingMessageConsumer;
import me.lucko.luckperms.api.messenger.Messenger;
import me.lucko.luckperms.api.messenger.MessengerProvider;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.messaging.InternalMessagingService;
import me.lucko.luckperms.common.messaging.LuckPermsMessagingService;
import me.lucko.luckperms.common.messaging.redis.RedisMessenger;
import me.lucko.luckperms.common.messaging.sql.SqlMessenger;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.sql.SqlStorage;
import me.lucko.luckperms.common.storage.implementation.sql.connection.hikari.MariaDbConnectionFactory;
import me.lucko.luckperms.common.storage.implementation.sql.connection.hikari.MySqlConnectionFactory;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MessagingFactory<P extends LuckPermsPlugin> {
    private final P plugin;

    public MessagingFactory(P plugin) {
        this.plugin = plugin;
    }

    protected P getPlugin() {
        return this.plugin;
    }

    public final InternalMessagingService getInstance() {
        SqlStorage dao;
        String messagingType = this.plugin.getConfiguration().get(ConfigKeys.MESSAGING_SERVICE).toLowerCase();
        if (messagingType.equals("none") && this.plugin.getConfiguration().get(ConfigKeys.REDIS_ENABLED).booleanValue()) {
            messagingType = "redis";
        }
        if (messagingType.equals("none") && this.plugin.getStorage().getImplementation() instanceof SqlStorage && ((dao = (SqlStorage)this.plugin.getStorage().getImplementation()).getConnectionFactory() instanceof MySqlConnectionFactory || dao.getConnectionFactory() instanceof MariaDbConnectionFactory)) {
            messagingType = "sql";
        }
        if (messagingType.equals("none") || messagingType.equals("notsql")) {
            return null;
        }
        this.plugin.getLogger().info("Loading messaging service... [" + messagingType.toUpperCase() + "]");
        InternalMessagingService service = this.getServiceFor(messagingType);
        if (service != null) {
            return service;
        }
        this.plugin.getLogger().warn("Messaging service '" + messagingType + "' not recognised.");
        return null;
    }

    protected InternalMessagingService getServiceFor(String messagingType) {
        if (messagingType.equals("redis")) {
            if (this.plugin.getConfiguration().get(ConfigKeys.REDIS_ENABLED).booleanValue()) {
                try {
                    return new LuckPermsMessagingService((LuckPermsPlugin)this.plugin, new RedisMessengerProvider());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.plugin.getLogger().warn("Messaging Service was set to redis, but redis is not enabled!");
            }
        } else if (messagingType.equals("sql")) {
            try {
                return new LuckPermsMessagingService((LuckPermsPlugin)this.plugin, new SqlMessengerProvider());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private class SqlMessengerProvider
    implements MessengerProvider {
        private SqlMessengerProvider() {
        }

        @Override
        public @NonNull String getName() {
            return "Sql";
        }

        @Override
        public @NonNull Messenger obtain(@NonNull IncomingMessageConsumer incomingMessageConsumer) {
            SqlStorage dao = (SqlStorage)MessagingFactory.this.getPlugin().getStorage().getImplementation();
            Preconditions.checkState((dao.getConnectionFactory() instanceof MySqlConnectionFactory || dao.getConnectionFactory() instanceof MariaDbConnectionFactory ? 1 : 0) != 0, (Object)"not a supported sql type");
            SqlMessenger sql = new SqlMessenger((LuckPermsPlugin)MessagingFactory.this.getPlugin(), dao, incomingMessageConsumer);
            sql.init();
            return sql;
        }
    }

    private class RedisMessengerProvider
    implements MessengerProvider {
        private RedisMessengerProvider() {
        }

        @Override
        public @NonNull String getName() {
            return "Redis";
        }

        @Override
        public @NonNull Messenger obtain(@NonNull IncomingMessageConsumer incomingMessageConsumer) {
            RedisMessenger redis = new RedisMessenger((LuckPermsPlugin)MessagingFactory.this.getPlugin(), incomingMessageConsumer);
            redis.init(MessagingFactory.this.getPlugin().getConfiguration().get(ConfigKeys.REDIS_ADDRESS), MessagingFactory.this.getPlugin().getConfiguration().get(ConfigKeys.REDIS_PASSWORD));
            return redis;
        }
    }
}

