/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.messaging.message;

import com.google.gson.JsonElement;
import java.util.UUID;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.api.messenger.message.type.LogMessage;
import me.lucko.luckperms.common.actionlog.LogEntryJsonSerializer;
import me.lucko.luckperms.common.messaging.LuckPermsMessagingService;
import me.lucko.luckperms.common.messaging.message.AbstractMessage;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LogMessageImpl
extends AbstractMessage
implements LogMessage {
    public static final String TYPE = "log";
    private final LogEntry logEntry;

    public static LogMessageImpl decode(@Nullable JsonElement content, UUID id) {
        if (content == null) {
            throw new IllegalStateException("Missing content");
        }
        return new LogMessageImpl(id, LogEntryJsonSerializer.deserialize(content));
    }

    public LogMessageImpl(UUID id, LogEntry logEntry) {
        super(id);
        this.logEntry = logEntry;
    }

    @Override
    public @NonNull LogEntry getLogEntry() {
        return this.logEntry;
    }

    @Override
    public @NonNull String asEncodedString() {
        return LuckPermsMessagingService.encodeMessageAsString(TYPE, this.getId(), (JsonElement)LogEntryJsonSerializer.serialize(this.logEntry));
    }
}

