/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.metastacking;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import me.lucko.luckperms.api.metastacking.MetaStackDefinition;
import me.lucko.luckperms.api.metastacking.MetaStackElement;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class SimpleMetaStackDefinition
implements MetaStackDefinition {
    private final List<MetaStackElement> elements;
    private final String startSpacer;
    private final String middleSpacer;
    private final String endSpacer;
    private final int hashCode;

    public SimpleMetaStackDefinition(List<MetaStackElement> elements, String startSpacer, String middleSpacer, String endSpacer) {
        this.elements = ImmutableList.copyOf((Collection)Objects.requireNonNull(elements, "elements"));
        this.startSpacer = Objects.requireNonNull(startSpacer, "startSpacer");
        this.middleSpacer = Objects.requireNonNull(middleSpacer, "middleSpacer");
        this.endSpacer = Objects.requireNonNull(endSpacer, "endSpacer");
        this.hashCode = this.calculateHashCode();
    }

    @Override
    public @NonNull List<MetaStackElement> getElements() {
        return this.elements;
    }

    @Override
    public @NonNull String getStartSpacer() {
        return this.startSpacer;
    }

    @Override
    public @NonNull String getMiddleSpacer() {
        return this.middleSpacer;
    }

    @Override
    public @NonNull String getEndSpacer() {
        return this.endSpacer;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleMetaStackDefinition)) {
            return false;
        }
        SimpleMetaStackDefinition that = (SimpleMetaStackDefinition)o;
        return this.getElements().equals(that.getElements()) && this.getStartSpacer().equals(that.getStartSpacer()) && this.getMiddleSpacer().equals(that.getMiddleSpacer()) && this.getEndSpacer().equals(that.getEndSpacer());
    }

    private int calculateHashCode() {
        return Objects.hash(this.getElements(), this.getStartSpacer(), this.getMiddleSpacer(), this.getEndSpacer());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "SimpleMetaStackDefinition(elements=" + this.getElements() + ", startSpacer=" + this.getStartSpacer() + ", middleSpacer=" + this.getMiddleSpacer() + ", endSpacer=" + this.getEndSpacer() + ", hashCode=" + this.getHashCode() + ")";
    }
}

