/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import java.util.Optional;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.nodetype.types.DisplayNameType;
import me.lucko.luckperms.common.buffers.Cache;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.model.Group;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DisplayNameCache
extends Cache<Optional<String>> {
    private final Group group;

    public DisplayNameCache(Group group) {
        this.group = group;
    }

    @Override
    protected @NonNull Optional<String> supply() {
        for (Node node : this.group.getOwnNodes(this.group.getPlugin().getContextManager().getStaticContext())) {
            Optional<DisplayNameType> displayName = node.getTypeData(DisplayNameType.KEY);
            if (!displayName.isPresent()) continue;
            return Optional.of(displayName.get().getDisplayName());
        }
        String name = this.group.getPlugin().getConfiguration().get(ConfigKeys.GROUP_NAME_REWRITES).get(this.group.getObjectName());
        return name == null || name.equals(this.group.getObjectName()) ? Optional.empty() : Optional.of(name);
    }
}

