/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SortedSetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Predicate;
import me.lucko.luckperms.api.LocalizedNode;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.StandardNodeEquality;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.buffers.Cache;
import me.lucko.luckperms.common.contexts.ContextSetComparator;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.node.comparator.NodeComparator;
import me.lucko.luckperms.common.node.comparator.NodeWithContextComparator;
import me.lucko.luckperms.common.node.model.ImmutableLocalizedNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NodeMap {
    private static final Supplier<SortedSet<LocalizedNode>> VALUE_SET_SUPPLIER = () -> new ConcurrentSkipListSet<Node>(NodeComparator.reverse());
    private final PermissionHolder holder;
    private final SortedSetMultimap<ImmutableContextSet, LocalizedNode> map = Multimaps.synchronizedSortedSetMultimap((SortedSetMultimap)Multimaps.newSortedSetMultimap(new ConcurrentSkipListMap(ContextSetComparator.reverse()), VALUE_SET_SUPPLIER));
    private final SortedSetMultimap<ImmutableContextSet, LocalizedNode> inheritanceMap = Multimaps.synchronizedSortedSetMultimap((SortedSetMultimap)Multimaps.newSortedSetMultimap(new ConcurrentSkipListMap(ContextSetComparator.reverse()), VALUE_SET_SUPPLIER));
    private final NodeMapCache cache = new NodeMapCache(this);

    NodeMap(PermissionHolder holder) {
        this.holder = holder;
    }

    public List<LocalizedNode> asList() {
        return new ArrayList<LocalizedNode>(this.map.values());
    }

    public LinkedHashSet<LocalizedNode> asSet() {
        return new LinkedHashSet<LocalizedNode>(this.map.values());
    }

    public SortedSet<LocalizedNode> asSortedSet() {
        TreeSet<? super Node> ret = new TreeSet<Node>(NodeWithContextComparator.reverse());
        this.copyTo(ret);
        return ret;
    }

    public void copyTo(Collection<? super LocalizedNode> collection) {
        collection.addAll(this.map.values());
    }

    public void copyTo(Collection<? super LocalizedNode> collection, ContextSet filter) {
        for (Map.Entry e : this.map.asMap().entrySet()) {
            if (!((ImmutableContextSet)e.getKey()).isSatisfiedBy(filter)) continue;
            collection.addAll((Collection)e.getValue());
        }
    }

    public void copyGroupNodesTo(Collection<? super LocalizedNode> collection) {
        collection.addAll(this.inheritanceMap.values());
    }

    public void copyGroupNodesTo(Collection<? super LocalizedNode> collection, ContextSet filter) {
        for (Map.Entry e : this.inheritanceMap.asMap().entrySet()) {
            if (!((ImmutableContextSet)e.getKey()).isSatisfiedBy(filter)) continue;
            collection.addAll((Collection)e.getValue());
        }
    }

    public ImmutableSetMultimap<ImmutableContextSet, LocalizedNode> immutable() {
        return (ImmutableSetMultimap)this.cache.get();
    }

    void invalidate() {
        this.cache.invalidate();
    }

    private LocalizedNode localise(Node node) {
        if (node instanceof LocalizedNode) {
            LocalizedNode localizedNode = (LocalizedNode)node;
            if (this.holder.getObjectName().equals(localizedNode.getLocation())) {
                return localizedNode;
            }
        }
        return ImmutableLocalizedNode.of(node, this.holder.getObjectName());
    }

    void add(Node node) {
        ImmutableContextSet context = node.getFullContexts().makeImmutable();
        LocalizedNode n = this.localise(node);
        SortedSet nodesInContext = this.map.get((Object)context);
        nodesInContext.removeIf((? super E e) -> e.equals(node, StandardNodeEquality.IGNORE_EXPIRY_TIME_AND_VALUE));
        nodesInContext.add(n);
        if (node.isGroupNode()) {
            SortedSet groupNodesInContext = this.inheritanceMap.get((Object)context);
            groupNodesInContext.removeIf((? super E e) -> e.equals(node, StandardNodeEquality.IGNORE_EXPIRY_TIME_AND_VALUE));
            if (node.getValue()) {
                groupNodesInContext.add(n);
            }
        }
    }

    void remove(Node node) {
        ImmutableContextSet context = node.getFullContexts().makeImmutable();
        this.map.get((Object)context).removeIf((? super E e) -> e.equals(node, StandardNodeEquality.IGNORE_EXPIRY_TIME_AND_VALUE));
        if (node.isGroupNode()) {
            this.inheritanceMap.get((Object)context).removeIf((? super E e) -> e.equals(node, StandardNodeEquality.IGNORE_EXPIRY_TIME_AND_VALUE));
        }
    }

    private void removeExact(Node node) {
        ImmutableContextSet context = node.getFullContexts().makeImmutable();
        this.map.remove((Object)context, (Object)node);
        if (node.isGroupNode() && node.getValue()) {
            this.inheritanceMap.remove((Object)context, (Object)node);
        }
    }

    void replace(Node node, Node previous) {
        this.removeExact(previous);
        this.add(node);
    }

    void clear() {
        this.map.clear();
        this.inheritanceMap.clear();
    }

    void clear(ContextSet contextSet) {
        ImmutableContextSet context = contextSet.makeImmutable();
        this.map.removeAll((Object)context);
        this.inheritanceMap.removeAll((Object)context);
    }

    void setContent(Collection<? extends Node> set) {
        this.map.clear();
        this.inheritanceMap.clear();
        for (Node node : set) {
            this.add(node);
        }
    }

    void setContent(Multimap<ImmutableContextSet, ? extends Node> multimap) {
        this.setContent(multimap.values());
    }

    boolean removeIf(Predicate<? super LocalizedNode> predicate) {
        boolean ret = this.map.values().removeIf(predicate);
        this.inheritanceMap.values().removeIf(predicate);
        return ret;
    }

    boolean removeIf(ContextSet contextSet, Predicate<? super LocalizedNode> predicate) {
        ImmutableContextSet context = contextSet.makeImmutable();
        SortedSet nodes = this.map.get((Object)context);
        boolean ret = nodes.removeIf(predicate);
        this.inheritanceMap.get((Object)context).removeIf(predicate);
        return ret;
    }

    boolean auditTemporaryNodes(@Nullable Set<? super LocalizedNode> removed) {
        boolean work = false;
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            LocalizedNode entry = (LocalizedNode)it.next();
            if (!entry.hasExpired()) continue;
            if (removed != null) {
                removed.add(entry);
            }
            if (entry.isGroupNode() && entry.getValue()) {
                this.inheritanceMap.remove((Object)entry.getFullContexts().makeImmutable(), (Object)entry);
            }
            work = true;
            it.remove();
        }
        return work;
    }

    private static final class NodeMapCache
    extends Cache<ImmutableSetMultimap<ImmutableContextSet, LocalizedNode>> {
        private final NodeMap handle;

        private NodeMapCache(NodeMap handle) {
            this.handle = handle;
        }

        @Override
        protected @NonNull ImmutableSetMultimap<ImmutableContextSet, LocalizedNode> supply() {
            return ImmutableSetMultimap.copyOf((Multimap)this.handle.map);
        }
    }
}

