/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.DataMutateResult;
import me.lucko.luckperms.api.DemotionResult;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.PromotionResult;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.common.api.DemotionResults;
import me.lucko.luckperms.common.api.PromotionResults;
import me.lucko.luckperms.common.api.delegates.model.ApiTrack;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.Identifiable;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.factory.NodeFactory;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Track
implements Identifiable<String> {
    private final String name;
    private final LuckPermsPlugin plugin;
    private final Lock ioLock = new ReentrantLock();
    private final List<String> groups = Collections.synchronizedList(new ArrayList());
    private final ApiTrack apiDelegate = new ApiTrack(this);

    public Track(String name, LuckPermsPlugin plugin) {
        this.name = name;
        this.plugin = plugin;
    }

    public String getName() {
        return this.name;
    }

    public Lock getIoLock() {
        return this.ioLock;
    }

    public ApiTrack getApiDelegate() {
        return this.apiDelegate;
    }

    @Override
    public String getId() {
        return this.name.toLowerCase();
    }

    public List<String> getGroups() {
        return ImmutableList.copyOf(this.groups);
    }

    public void setGroups(List<String> groups) {
        this.groups.clear();
        this.groups.addAll(groups);
    }

    public int getSize() {
        return this.groups.size();
    }

    public String getNext(Group current) throws IllegalArgumentException {
        return this.getNext(current.getName());
    }

    public String getPrevious(Group current) throws IllegalArgumentException {
        return this.getPrevious(current.getName());
    }

    public String getNext(String current) throws IllegalArgumentException {
        if (!this.containsGroup(current)) {
            throw new IllegalArgumentException();
        }
        if (this.groups.indexOf(current) == this.groups.size() - 1) {
            return null;
        }
        return this.groups.get(this.groups.indexOf(current) + 1);
    }

    public String getPrevious(String current) throws IllegalArgumentException {
        if (!this.containsGroup(current)) {
            throw new IllegalArgumentException();
        }
        if (this.groups.indexOf(current) == 0) {
            return null;
        }
        return this.groups.get(this.groups.indexOf(current) - 1);
    }

    public DataMutateResult appendGroup(Group group) {
        if (this.containsGroup(group)) {
            return DataMutateResult.ALREADY_HAS;
        }
        ImmutableList before = ImmutableList.copyOf(this.groups);
        this.groups.add(group.getName());
        ImmutableList after = ImmutableList.copyOf(this.groups);
        this.plugin.getEventFactory().handleTrackAddGroup(this, group.getName(), (List<String>)before, (List<String>)after);
        return DataMutateResult.SUCCESS;
    }

    public DataMutateResult insertGroup(Group group, int position) throws IndexOutOfBoundsException {
        if (this.containsGroup(group)) {
            return DataMutateResult.ALREADY_HAS;
        }
        ImmutableList before = ImmutableList.copyOf(this.groups);
        this.groups.add(position, group.getName());
        ImmutableList after = ImmutableList.copyOf(this.groups);
        this.plugin.getEventFactory().handleTrackAddGroup(this, group.getName(), (List<String>)before, (List<String>)after);
        return DataMutateResult.SUCCESS;
    }

    public DataMutateResult removeGroup(Group group) {
        return this.removeGroup(group.getName());
    }

    public DataMutateResult removeGroup(String group) {
        if (!this.containsGroup(group)) {
            return DataMutateResult.LACKS;
        }
        ImmutableList before = ImmutableList.copyOf(this.groups);
        this.groups.remove(group);
        ImmutableList after = ImmutableList.copyOf(this.groups);
        this.plugin.getEventFactory().handleTrackRemoveGroup(this, group, (List<String>)before, (List<String>)after);
        return DataMutateResult.SUCCESS;
    }

    public boolean containsGroup(Group group) {
        return this.containsGroup(group.getName());
    }

    public boolean containsGroup(String group) {
        return this.groups.contains(group);
    }

    public void clearGroups() {
        ImmutableList before = ImmutableList.copyOf(this.groups);
        this.groups.clear();
        this.plugin.getEventFactory().handleTrackClear(this, (List<String>)before);
    }

    public PromotionResult promote(User user, ContextSet context, Predicate<String> nextGroupPermissionChecker, @Nullable Sender sender, boolean addToFirst) {
        if (this.getSize() <= 1) {
            throw new IllegalStateException("Track contains one or fewer groups, unable to promote");
        }
        List nodes = user.enduringData().immutable().get((Object)context.makeImmutable()).stream().filter(Node::isGroupNode).filter(Node::getValue).filter(node -> this.containsGroup(node.getGroupName())).distinct().collect(Collectors.toList());
        if (nodes.isEmpty()) {
            if (!addToFirst) {
                return PromotionResults.addedToFirst(null);
            }
            String first = this.getGroups().get(0);
            Group nextGroup = (Group)this.plugin.getGroupManager().getIfLoaded(first);
            if (nextGroup == null) {
                return PromotionResults.malformedTrack(first);
            }
            if (!nextGroupPermissionChecker.test(nextGroup.getName())) {
                return PromotionResults.undefinedFailure();
            }
            user.setPermission(NodeFactory.buildGroupNode(nextGroup.getId()).withExtraContext(context).build());
            this.plugin.getEventFactory().handleUserPromote(user, this, null, first, sender);
            return PromotionResults.addedToFirst(first);
        }
        if (nodes.size() != 1) {
            return PromotionResults.ambiguousCall();
        }
        Node oldNode = (Node)nodes.get(0);
        String old = oldNode.getGroupName();
        String next = this.getNext(old);
        if (next == null) {
            return PromotionResults.endOfTrack();
        }
        Group nextGroup = (Group)this.plugin.getGroupManager().getIfLoaded(next);
        if (nextGroup == null) {
            return PromotionResults.malformedTrack(next);
        }
        if (!nextGroupPermissionChecker.test(nextGroup.getName())) {
            return PromotionResults.undefinedFailure();
        }
        user.unsetPermission(oldNode);
        user.setPermission(NodeFactory.buildGroupNode(nextGroup.getName()).withExtraContext(context).build());
        if (context.isEmpty() && user.getPrimaryGroup().getStoredValue().orElse("default").equalsIgnoreCase(old)) {
            user.getPrimaryGroup().setStoredValue(nextGroup.getName());
        }
        this.plugin.getEventFactory().handleUserPromote(user, this, old, nextGroup.getName(), sender);
        return PromotionResults.success(old, nextGroup.getName());
    }

    public DemotionResult demote(User user, ContextSet context, Predicate<String> previousGroupPermissionChecker, @Nullable Sender sender, boolean removeFromFirst) {
        if (this.getSize() <= 1) {
            throw new IllegalStateException("Track contains one or fewer groups, unable to demote");
        }
        List nodes = user.enduringData().immutable().get((Object)context.makeImmutable()).stream().filter(Node::isGroupNode).filter(Node::getValue).filter(node -> this.containsGroup(node.getGroupName())).distinct().collect(Collectors.toList());
        if (nodes.isEmpty()) {
            return DemotionResults.notOnTrack();
        }
        if (nodes.size() != 1) {
            return DemotionResults.ambiguousCall();
        }
        Node oldNode = (Node)nodes.get(0);
        String old = oldNode.getGroupName();
        String previous = this.getPrevious(old);
        if (!previousGroupPermissionChecker.test(oldNode.getGroupName())) {
            return DemotionResults.undefinedFailure();
        }
        if (previous == null) {
            if (!removeFromFirst) {
                return DemotionResults.removedFromFirst(null);
            }
            user.unsetPermission(oldNode);
            this.plugin.getEventFactory().handleUserDemote(user, this, old, null, sender);
            return DemotionResults.removedFromFirst(old);
        }
        Group previousGroup = (Group)this.plugin.getGroupManager().getIfLoaded(previous);
        if (previousGroup == null) {
            return DemotionResults.malformedTrack(previous);
        }
        user.unsetPermission(oldNode);
        user.setPermission(NodeFactory.buildGroupNode(previousGroup.getName()).withExtraContext(context).build());
        if (context.isEmpty() && user.getPrimaryGroup().getStoredValue().orElse("default").equalsIgnoreCase(old)) {
            user.getPrimaryGroup().setStoredValue(previousGroup.getName());
        }
        this.plugin.getEventFactory().handleUserDemote(user, this, old, previousGroup.getName(), sender);
        return DemotionResults.success(old, previousGroup.getName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Track)) {
            return false;
        }
        Track other = (Track)o;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Track(name=" + this.name + ", groups=" + this.getGroups() + ")";
    }
}

