/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import me.lucko.luckperms.common.model.Identifiable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class UserIdentifier
implements Identifiable<UUID> {
    private final UUID uuid;
    private final String username;

    public static UserIdentifier of(@NonNull UUID uuid, @Nullable String username) {
        Objects.requireNonNull(uuid, "uuid");
        if (username == null || username.equalsIgnoreCase("null") || username.isEmpty()) {
            username = null;
        }
        return new UserIdentifier(uuid, username);
    }

    private UserIdentifier(UUID uuid, String username) {
        this.uuid = uuid;
        this.username = username;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public UUID getId() {
        return this.getUuid();
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserIdentifier)) {
            return false;
        }
        UserIdentifier other = (UserIdentifier)o;
        return this.uuid.equals(other.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String toString() {
        return "UserIdentifier(uuid=" + this.uuid + ", username=" + this.username + ")";
    }
}

