/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.api.nodetype.types.WeightType;
import me.lucko.luckperms.common.buffers.Cache;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.model.Group;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WeightCache
extends Cache<OptionalInt> {
    private final Group group;

    public WeightCache(Group group) {
        this.group = group;
    }

    @Override
    protected @NonNull OptionalInt supply() {
        Map<String, Integer> map;
        Integer w;
        OptionalInt weight;
        boolean seen = false;
        int best = 0;
        for (Node node : this.group.getOwnNodes(ImmutableContextSet.empty())) {
            Optional<WeightType> weight2 = node.getTypeData(WeightType.KEY);
            if (!weight2.isPresent()) continue;
            int value = weight2.get().getWeight();
            if (seen && value <= best) continue;
            seen = true;
            best = value;
        }
        OptionalInt optionalInt = weight = seen ? OptionalInt.of(best) : OptionalInt.empty();
        if (!weight.isPresent() && (w = (map = this.group.getPlugin().getConfiguration().get(ConfigKeys.GROUP_WEIGHTS)).get(this.group.getObjectName().toLowerCase())) != null) {
            weight = OptionalInt.of(w);
        }
        return weight;
    }
}

