/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class ShorthandParser {
    private static final List<Function<String, Iterable<String>>> PARSERS = ImmutableList.builder().add((Object)new ListParser()).add((Object)new CharacterRangeParser()).add((Object)new NumericRangeParser()).build();

    public static Set<String> parseShorthand(String s) {
        HashSet<String> results = new HashSet<String>(1);
        results.add(s);
        while (true) {
            HashSet<String> working = new HashSet<String>(results.size());
            int beforeSize = results.size();
            for (String str : results) {
                Set<String> ret = ShorthandParser.captureResults(str);
                if (ret != null) {
                    working.addAll(ret);
                    continue;
                }
                working.add(str);
            }
            if (working.size() == beforeSize) break;
            results = working;
        }
        results.remove(s);
        return results;
    }

    private static Set<String> captureResults(String s) {
        int openingIndex = (s = s.replace('(', '{').replace(')', '}')).indexOf(123);
        if (openingIndex == -1) {
            return null;
        }
        int closingIndex = s.indexOf(125);
        if (closingIndex < openingIndex) {
            return null;
        }
        String before = s.substring(0, openingIndex);
        String after = s.substring(closingIndex + 1);
        String between = s.substring(openingIndex + 1, closingIndex);
        HashSet<String> results = new HashSet<String>(10);
        for (Function<String, Iterable<String>> parser : PARSERS) {
            Iterable<String> res = parser.apply(between);
            if (res == null) continue;
            for (String r : res) {
                results.add(before + r + after);
            }
        }
        return results;
    }

    private ShorthandParser() {
    }

    private static class CharacterRangeParser
    implements Function<String, Iterable<String>> {
        private CharacterRangeParser() {
        }

        private static List<String> getCharRange(char a, char b) {
            ArrayList<String> s = new ArrayList<String>();
            for (char c = a; c <= b; c = (char)(c + '\u0001')) {
                s.add(Character.toString(c));
            }
            return s;
        }

        @Override
        public Iterable<String> apply(String s) {
            int index = s.indexOf("-");
            if (index == -1) {
                return null;
            }
            String before = s.substring(0, index);
            if (before.length() != 1) {
                return null;
            }
            String after = s.substring(index + 1);
            if (after.length() != 1) {
                return null;
            }
            return CharacterRangeParser.getCharRange(before.charAt(0), after.charAt(0));
        }
    }

    private static class NumericRangeParser
    implements Function<String, Iterable<String>> {
        private NumericRangeParser() {
        }

        private static Integer parseInt(String a) {
            try {
                return Integer.parseInt(a);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public Iterable<String> apply(String s) {
            int index = s.indexOf("-");
            if (index == -1) {
                return null;
            }
            Integer before = NumericRangeParser.parseInt(s.substring(0, index));
            if (before == null) {
                return null;
            }
            Integer after = NumericRangeParser.parseInt(s.substring(index + 1));
            if (after == null) {
                return null;
            }
            return IntStream.rangeClosed(before, after).mapToObj(Integer::toString).collect(Collectors.toList());
        }
    }

    private static class ListParser
    implements Function<String, Iterable<String>> {
        private static final Splitter SPLITTER = Splitter.on((char)',');

        private ListParser() {
        }

        @Override
        public Iterable<String> apply(String s) {
            if (!(s = s.replace('|', ',')).contains(",")) {
                return Collections.singleton(s);
            }
            return SPLITTER.split((CharSequence)s);
        }
    }
}

