/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.plugin.scheduler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerAdapter;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerTask;

public abstract class AbstractJavaScheduler
implements SchedulerAdapter {
    private final ScheduledExecutorService asyncExecutor = new AsyncExecutor();

    @Override
    public Executor async() {
        return this.asyncExecutor;
    }

    @Override
    public SchedulerTask asyncLater(Runnable task, long delay, TimeUnit unit) {
        ScheduledFuture<?> future = this.asyncExecutor.schedule(new WrappedRunnable(task), delay, unit);
        return () -> future.cancel(false);
    }

    @Override
    public SchedulerTask asyncRepeating(Runnable task, long interval, TimeUnit unit) {
        ScheduledFuture<?> future = this.asyncExecutor.scheduleAtFixedRate(new WrappedRunnable(task), interval, interval, unit);
        return () -> future.cancel(false);
    }

    @Override
    public void shutdown() {
        this.asyncExecutor.shutdown();
        try {
            this.asyncExecutor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static final class AsyncExecutor
    extends ScheduledThreadPoolExecutor {
        AsyncExecutor() {
            super(4, new ThreadFactoryBuilder().setNameFormat("luckperms-%d").build());
        }

        @Override
        public void execute(Runnable command) {
            super.execute(new WrappedRunnable(command));
        }
    }

    private static final class WrappedRunnable
    implements Runnable {
        private final Runnable delegate;

        WrappedRunnable(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            try {
                this.delegate.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

