/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.plugin.util;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.lucko.luckperms.api.PlayerSaveResult;
import me.lucko.luckperms.api.platform.PlatformType;
import me.lucko.luckperms.common.assignments.AssignmentRule;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;

public abstract class AbstractConnectionListener {
    private final LuckPermsPlugin plugin;
    private final Set<UUID> uniqueConnections = ConcurrentHashMap.newKeySet();

    protected AbstractConnectionListener(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    public Set<UUID> getUniqueConnections() {
        return this.uniqueConnections;
    }

    protected void recordConnection(UUID uuid) {
        this.uniqueConnections.add(uuid);
    }

    public User loadUser(UUID uuid, String username) {
        long time;
        User user;
        long startTime = System.currentTimeMillis();
        this.plugin.getUserManager().getHouseKeeper().registerUsage(uuid);
        PlayerSaveResult saveResult = this.plugin.getStorage().savePlayerData(uuid, username).join();
        if (saveResult.includes(PlayerSaveResult.Status.CLEAN_INSERT)) {
            this.plugin.getEventFactory().handleUserFirstLogin(uuid, username);
        }
        if (saveResult.includes(PlayerSaveResult.Status.OTHER_UUIDS_PRESENT_FOR_USERNAME)) {
            Set<UUID> otherUuids = saveResult.getOtherUuids();
            this.plugin.getLogger().warn("LuckPerms already has data for player '" + username + "' - but this data is stored under a different UUID.");
            this.plugin.getLogger().warn("'" + username + "' has previously used the unique ids " + otherUuids + " but is now connecting with '" + uuid + "'");
            if (uuid.version() == 4) {
                if (this.plugin.getBootstrap().getType() == PlatformType.BUNGEE) {
                    this.plugin.getLogger().warn("The UUID the player is connecting with now is Mojang-assigned (type 4). This implies that BungeeCord's IP-Forwarding has not been setup correctly on one (or more) of the backend servers.");
                } else {
                    this.plugin.getLogger().warn("The UUID the player is connecting with now is Mojang-assigned (type 4). This implies that one of the other servers in your network is not authenticating correctly.");
                    this.plugin.getLogger().warn("If you're using BungeeCord, please ensure that IP-Forwarding is setup correctly on all of your backend servers!");
                }
            } else {
                this.plugin.getLogger().warn("The UUID the player is connecting with now is NOT Mojang-assigned (type " + uuid.version() + "). This implies that THIS server is not authenticating correctly, but one (or more) of the other servers/proxies in the network are.");
                this.plugin.getLogger().warn("If you're using BungeeCord, please ensure that IP-Forwarding is setup correctly on all of your backend servers!");
            }
            this.plugin.getLogger().warn("See here for more info: https://github.com/lucko/LuckPerms/wiki/Network-Installation#pre-setup");
        }
        if ((user = this.plugin.getStorage().loadUser(uuid, username).join()) == null) {
            throw new NullPointerException("User is null");
        }
        boolean save = false;
        for (AssignmentRule rule : this.plugin.getConfiguration().get(ConfigKeys.DEFAULT_ASSIGNMENTS)) {
            if (!rule.apply(user)) continue;
            save = true;
        }
        if (save) {
            this.plugin.getStorage().saveUser(user).join();
        }
        if ((time = System.currentTimeMillis() - startTime) >= 1000L) {
            this.plugin.getLogger().warn("Processing login for " + username + " took " + time + "ms.");
        }
        return user;
    }

    public void handleDisconnect(UUID uuid) {
        this.plugin.getUserManager().getHouseKeeper().registerUsage(uuid);
        this.plugin.getBootstrap().getScheduler().executeAsync(() -> {
            User user = this.plugin.getUserManager().getIfLoaded(uuid);
            if (user != null) {
                user.clearTransientNodes();
            }
        });
    }
}

