/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.primarygroup;

import java.util.LinkedHashSet;
import java.util.Optional;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.primarygroup.ContextualHolder;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ParentsByWeightHolder
extends ContextualHolder {
    public ParentsByWeightHolder(User user) {
        super(user);
    }

    @Override
    protected @NonNull Optional<String> calculateValue(Contexts contexts) {
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        for (Node node : this.user.getOwnGroupNodes(contexts.getContexts())) {
            Group group = (Group)this.user.getPlugin().getGroupManager().getIfLoaded(node.getGroupName());
            if (group == null) continue;
            groups.add(group);
        }
        Group bestGroup = null;
        if (!groups.isEmpty()) {
            boolean bl = false;
            for (Group g : groups) {
                int n;
                int weight = g.getWeight().orElse(0);
                if (bestGroup != null && g.getWeight().orElse(0) <= n) continue;
                bestGroup = g;
                n = weight;
            }
        }
        return bestGroup == null ? Optional.empty() : Optional.of(bestGroup.getName());
    }
}

