/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.sender;

import com.google.common.base.Splitter;
import java.lang.ref.WeakReference;
import java.util.UUID;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.sender.SenderFactory;
import me.lucko.luckperms.common.utils.TextUtils;
import me.lucko.luckperms.lib.text.Component;

public final class AbstractSender<T>
implements Sender {
    private static final Splitter NEW_LINE_SPLITTER = Splitter.on((String)"\n");
    private final LuckPermsPlugin platform;
    private final SenderFactory<T> factory;
    private final WeakReference<T> reference;
    private final UUID uuid;
    private final String name;

    AbstractSender(LuckPermsPlugin platform, SenderFactory<T> factory, T t) {
        this.platform = platform;
        this.factory = factory;
        this.reference = new WeakReference<T>(t);
        this.uuid = factory.getUuid(t);
        this.name = factory.getName(t);
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.platform;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void sendMessage(String message) {
        Object t = this.reference.get();
        if (t != null) {
            if (!this.isConsole()) {
                this.factory.sendMessage(t, message);
                return;
            }
            for (String line : NEW_LINE_SPLITTER.split((CharSequence)message)) {
                this.factory.sendMessage(t, line);
            }
        }
    }

    @Override
    public void sendMessage(Component message) {
        if (this.isConsole()) {
            this.sendMessage(TextUtils.toLegacy(message));
            return;
        }
        Object t = this.reference.get();
        if (t != null) {
            this.factory.sendMessage(t, message);
        }
    }

    @Override
    public Tristate getPermissionValue(String permission) {
        Object t = this.reference.get();
        if (t != null) {
            return this.factory.getPermissionValue(t, permission);
        }
        return this.isConsole() ? Tristate.TRUE : Tristate.UNDEFINED;
    }

    @Override
    public boolean hasPermission(String permission) {
        Object t = this.reference.get();
        if (t != null && this.factory.hasPermission(t, permission)) {
            return true;
        }
        return this.isConsole();
    }

    @Override
    public boolean isValid() {
        return this.reference.get() != null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractSender)) {
            return false;
        }
        AbstractSender that = (AbstractSender)o;
        return this.getUuid().equals(that.getUuid());
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }
}

