/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.file;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.utils.Iterators;

public class FileWatcher {
    private static final WatchEvent.Kind[] KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    private final Path basePath;
    private final Map<Path, WatchedLocation> watchedLocations = Collections.synchronizedMap(new HashMap());
    private final WatchService watchService;
    private boolean initialised = false;

    public FileWatcher(LuckPermsPlugin plugin, Path basePath) throws IOException {
        this.basePath = basePath;
        this.watchService = basePath.getFileSystem().newWatchService();
        plugin.getBootstrap().getScheduler().asyncLater(this::initLocations, 5L, TimeUnit.SECONDS);
        plugin.getBootstrap().getScheduler().asyncRepeating(this::tick, 1L, TimeUnit.SECONDS);
    }

    public WatchedLocation getWatcher(Path path) {
        Path relativePath = this.basePath.relativize(path);
        return this.watchedLocations.computeIfAbsent(relativePath, p -> new WatchedLocation(this, (Path)p));
    }

    public void close() {
        if (this.watchService == null) {
            return;
        }
        try {
            this.watchService.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initLocations() {
        for (WatchedLocation loc : this.watchedLocations.values()) {
            try {
                loc.setup();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.initialised = true;
    }

    private void tick() {
        ArrayList<Path> expired = new ArrayList<Path>();
        for (Map.Entry<Path, WatchedLocation> ent : this.watchedLocations.entrySet()) {
            boolean valid = ent.getValue().tick();
            if (valid) continue;
            new RuntimeException("WatchKey no longer valid: " + ent.getKey().toString()).printStackTrace();
            expired.add(ent.getKey());
        }
        expired.forEach(this.watchedLocations::remove);
    }

    private static boolean isFileTemporary(String fileName) {
        return fileName.endsWith(".tmp") || fileName.endsWith(".swp") || fileName.endsWith(".swx") || fileName.endsWith(".swpz");
    }

    public final class WatchedLocation {
        private final FileWatcher watcher;
        private final Path relativePath;
        private final Path absolutePath;
        private final Map<String, Long> lastChange = Collections.synchronizedMap(new HashMap());
        private boolean ready = false;
        private WatchKey key = null;
        private final List<Consumer<Path>> callbacks = new CopyOnWriteArrayList<Consumer<Path>>();

        private WatchedLocation(FileWatcher watcher, Path relativePath) {
            this.watcher = watcher;
            this.relativePath = relativePath;
            this.absolutePath = this.watcher.basePath.resolve(this.relativePath);
        }

        private synchronized void setup() throws IOException {
            if (this.ready) {
                return;
            }
            this.key = this.absolutePath.register(this.watcher.watchService, KINDS);
            this.ready = true;
        }

        private boolean tick() {
            if (!this.ready) {
                if (!FileWatcher.this.initialised) {
                    return true;
                }
                try {
                    this.setup();
                    return true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            long expireTime = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(4L);
            this.lastChange.values().removeIf(lastChange -> lastChange < expireTime);
            List<WatchEvent<?>> watchEvents = this.key.pollEvents();
            for (WatchEvent<?> event : watchEvents) {
                String fileName;
                Path context = (Path)event.context();
                if (context == null || FileWatcher.isFileTemporary(fileName = context.toString()) || this.lastChange.containsKey(fileName)) continue;
                this.lastChange.put(fileName, System.currentTimeMillis());
                Iterators.iterate(this.callbacks, cb -> cb.accept(context));
            }
            return this.key.reset();
        }

        public void recordChange(String fileName) {
            this.lastChange.put(fileName, System.currentTimeMillis());
        }

        public void addListener(Consumer<Path> updateConsumer) {
            this.callbacks.add(updateConsumer);
        }
    }
}

