/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.mongodb;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.HeldPermission;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.api.PlayerSaveResult;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.bulkupdate.comparisons.Constraint;
import me.lucko.luckperms.common.managers.group.GroupManager;
import me.lucko.luckperms.common.managers.track.TrackManager;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.NodeMapType;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.model.UserIdentifier;
import me.lucko.luckperms.common.node.factory.LegacyNodeFactory;
import me.lucko.luckperms.common.node.model.NodeDataContainer;
import me.lucko.luckperms.common.node.model.NodeHeldPermission;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.StorageImplementation;
import me.lucko.luckperms.common.storage.misc.PlayerSaveResultImpl;
import me.lucko.luckperms.common.storage.misc.StorageCredentials;
import me.lucko.luckperms.lib.bson.Document;
import me.lucko.luckperms.lib.bson.conversions.Bson;
import me.lucko.luckperms.lib.mongodb.MongoClient;
import me.lucko.luckperms.lib.mongodb.MongoClientOptions;
import me.lucko.luckperms.lib.mongodb.MongoClientURI;
import me.lucko.luckperms.lib.mongodb.MongoCredential;
import me.lucko.luckperms.lib.mongodb.ServerAddress;
import me.lucko.luckperms.lib.mongodb.client.MongoCollection;
import me.lucko.luckperms.lib.mongodb.client.MongoCursor;
import me.lucko.luckperms.lib.mongodb.client.MongoDatabase;
import me.lucko.luckperms.lib.mongodb.client.model.Filters;
import me.lucko.luckperms.lib.mongodb.client.model.UpdateOptions;

public class MongoStorage
implements StorageImplementation {
    private final LuckPermsPlugin plugin;
    private final StorageCredentials configuration;
    private MongoClient mongoClient;
    private MongoDatabase database;
    private final String prefix;
    private final String connectionUri;

    public MongoStorage(LuckPermsPlugin plugin, StorageCredentials configuration, String prefix, String connectionUri) {
        this.plugin = plugin;
        this.configuration = configuration;
        this.prefix = prefix;
        this.connectionUri = connectionUri;
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getImplementationName() {
        return "MongoDB";
    }

    @Override
    public void init() {
        if (!Strings.isNullOrEmpty((String)this.connectionUri)) {
            this.mongoClient = new MongoClient(new MongoClientURI(this.connectionUri));
        } else {
            MongoCredential credential = null;
            if (!Strings.isNullOrEmpty((String)this.configuration.getUsername())) {
                credential = MongoCredential.createCredential((String)this.configuration.getUsername(), (String)this.configuration.getDatabase(), Strings.isNullOrEmpty((String)this.configuration.getPassword()) ? null : this.configuration.getPassword().toCharArray());
            }
            String[] addressSplit = this.configuration.getAddress().split(":");
            String host = addressSplit[0];
            int port = addressSplit.length > 1 ? Integer.parseInt(addressSplit[1]) : 27017;
            ServerAddress address = new ServerAddress(host, port);
            this.mongoClient = credential == null ? new MongoClient(address) : new MongoClient(address, credential, MongoClientOptions.builder().build());
        }
        this.database = this.mongoClient.getDatabase(this.configuration.getDatabase());
    }

    @Override
    public void shutdown() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    @Override
    public Map<String, String> getMeta() {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        boolean success = true;
        long start = System.currentTimeMillis();
        try {
            this.database.runCommand((Bson)new Document("ping", (Object)1));
        }
        catch (Exception e) {
            success = false;
        }
        long duration = System.currentTimeMillis() - start;
        if (success) {
            ret.put("Ping", "&a" + duration + "ms");
            ret.put("Connected", "true");
        } else {
            ret.put("Connected", "false");
        }
        return ret;
    }

    @Override
    public void logAction(LogEntry entry) {
        MongoCollection c = this.database.getCollection(this.prefix + "action");
        Document doc = new Document().append("timestamp", (Object)entry.getTimestamp()).append("actor", (Object)entry.getActor()).append("actorName", (Object)entry.getActorName()).append("type", (Object)Character.toString(entry.getType().getCode())).append("actedName", (Object)entry.getActedName()).append("action", (Object)entry.getAction());
        if (entry.getActed().isPresent()) {
            doc.append("acted", (Object)entry.getActed().get());
        }
        c.insertOne((Object)doc);
    }

    @Override
    public Log getLog() {
        Log.Builder log = Log.builder();
        MongoCollection c = this.database.getCollection(this.prefix + "action");
        try (MongoCursor cursor = c.find().iterator();){
            while (cursor.hasNext()) {
                Document d = (Document)cursor.next();
                UUID actedUuid = null;
                if (d.containsKey((Object)"acted")) {
                    actedUuid = (UUID)d.get((Object)"acted", UUID.class);
                }
                ExtendedLogEntry e = ExtendedLogEntry.build().timestamp(d.getLong((Object)"timestamp")).actor((UUID)d.get((Object)"actor", UUID.class)).actorName(d.getString((Object)"actorName")).type(LogEntry.Type.valueOf(d.getString((Object)"type").charAt(0))).acted(actedUuid).actedName(d.getString((Object)"actedName")).action(d.getString((Object)"action")).build();
                log.add(e);
            }
        }
        return log.build();
    }

    @Override
    public void applyBulkUpdate(BulkUpdate bulkUpdate) {
        List newNodes;
        Set results;
        HashSet<NodeDataContainer> nodes;
        Document d2;
        Throwable throwable;
        MongoCursor cursor;
        MongoCollection c;
        if (bulkUpdate.getDataType().isIncludingUsers()) {
            c = this.database.getCollection(this.prefix + "users");
            cursor = c.find().iterator();
            throwable = null;
            try {
                while (cursor.hasNext()) {
                    d2 = (Document)cursor.next();
                    UUID uuid = (UUID)d2.get((Object)"_id", UUID.class);
                    nodes = new HashSet<NodeDataContainer>(MongoStorage.nodesFromDoc(d2));
                    results = nodes.stream().map(bulkUpdate::apply).filter(Objects::nonNull).collect(Collectors.toSet());
                    if (nodes.equals(results)) continue;
                    newNodes = results.stream().map(MongoStorage::nodeToDoc).collect(Collectors.toList());
                    d2.append("permissions", newNodes).remove((Object)"perms");
                    c.replaceOne((Bson)new Document("_id", (Object)uuid), (Object)d2);
                }
            }
            catch (Throwable d2) {
                throwable = d2;
                throw d2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable d2) {
                            throwable.addSuppressed(d2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
        if (bulkUpdate.getDataType().isIncludingGroups()) {
            c = this.database.getCollection(this.prefix + "groups");
            cursor = c.find().iterator();
            throwable = null;
            try {
                while (cursor.hasNext()) {
                    d2 = (Document)cursor.next();
                    String holder = d2.getString((Object)"_id");
                    nodes = new HashSet<NodeDataContainer>(MongoStorage.nodesFromDoc(d2));
                    results = nodes.stream().map(bulkUpdate::apply).filter(Objects::nonNull).collect(Collectors.toSet());
                    if (nodes.equals(results)) continue;
                    newNodes = results.stream().map(MongoStorage::nodeToDoc).collect(Collectors.toList());
                    d2.append("permissions", newNodes).remove((Object)"perms");
                    c.replaceOne((Bson)new Document("_id", (Object)holder), (Object)d2);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cursor != null) {
                    if (throwable != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User loadUser(UUID uuid, String username) {
        User user = (User)this.plugin.getUserManager().getOrMake(UserIdentifier.of(uuid, username));
        user.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "users");
            try (MongoCursor cursor = c.find((Bson)new Document("_id", (Object)user.getUuid())).iterator();){
                if (cursor.hasNext()) {
                    Document d = (Document)cursor.next();
                    String name = d.getString((Object)"name");
                    user.getPrimaryGroup().setStoredValue(d.getString((Object)"primaryGroup"));
                    Set nodes = MongoStorage.nodesFromDoc(d).stream().map(NodeDataContainer::toNode).collect(Collectors.toSet());
                    user.setNodes(NodeMapType.ENDURING, nodes);
                    user.setName(name, true);
                    boolean save = this.plugin.getUserManager().giveDefaultIfNeeded(user, false);
                    if (user.getName().isPresent() && (name == null || !user.getName().get().equalsIgnoreCase(name))) {
                        save = true;
                    }
                    if (save | user.auditTemporaryPermissions()) {
                        c.replaceOne((Bson)new Document("_id", (Object)user.getUuid()), (Object)MongoStorage.userToDoc(user));
                    }
                } else if (this.plugin.getUserManager().shouldSave(user)) {
                    user.clearNodes();
                    user.getPrimaryGroup().setStoredValue(null);
                    this.plugin.getUserManager().giveDefaultIfNeeded(user, false);
                }
            }
        }
        finally {
            user.invalidateCachedData();
            user.getIoLock().unlock();
        }
        return user;
    }

    @Override
    public void saveUser(User user) {
        user.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "users");
            if (!this.plugin.getUserManager().shouldSave(user)) {
                c.deleteOne((Bson)new Document("_id", (Object)user.getUuid()));
            } else {
                c.replaceOne((Bson)new Document("_id", (Object)user.getUuid()), (Object)MongoStorage.userToDoc(user), new UpdateOptions().upsert(true));
            }
        }
        finally {
            user.getIoLock().unlock();
        }
    }

    @Override
    public Set<UUID> getUniqueUsers() {
        HashSet<UUID> uuids = new HashSet<UUID>();
        MongoCollection c = this.database.getCollection(this.prefix + "users");
        try (MongoCursor cursor = c.find().iterator();){
            while (cursor.hasNext()) {
                Document d = (Document)cursor.next();
                uuids.add((UUID)d.get((Object)"_id", UUID.class));
            }
        }
        return uuids;
    }

    @Override
    public List<HeldPermission<UUID>> getUsersWithPermission(Constraint constraint) {
        ArrayList<HeldPermission<UUID>> held = new ArrayList<HeldPermission<UUID>>();
        MongoCollection c = this.database.getCollection(this.prefix + "users");
        try (MongoCursor cursor = c.find().iterator();){
            while (cursor.hasNext()) {
                Document d = (Document)cursor.next();
                UUID holder = (UUID)d.get((Object)"_id", UUID.class);
                HashSet<NodeDataContainer> nodes = new HashSet<NodeDataContainer>(MongoStorage.nodesFromDoc(d));
                for (NodeDataContainer e : nodes) {
                    if (!constraint.eval(e.getPermission())) continue;
                    held.add(NodeHeldPermission.of(holder, e));
                }
            }
        }
        return held;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group createAndLoadGroup(String name) {
        Group group = (Group)this.plugin.getGroupManager().getOrMake(name);
        group.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "groups");
            try (MongoCursor cursor = c.find((Bson)new Document("_id", (Object)group.getName())).iterator();){
                if (cursor.hasNext()) {
                    Document d = (Document)cursor.next();
                    Set nodes = MongoStorage.nodesFromDoc(d).stream().map(NodeDataContainer::toNode).collect(Collectors.toSet());
                    group.setNodes(NodeMapType.ENDURING, nodes);
                } else {
                    c.insertOne((Object)MongoStorage.groupToDoc(group));
                }
            }
        }
        finally {
            group.invalidateCachedData();
            group.getIoLock().unlock();
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Group> loadGroup(String name) {
        Group group = (Group)this.plugin.getGroupManager().getIfLoaded(name);
        if (group != null) {
            group.getIoLock().lock();
        }
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "groups");
            try (MongoCursor cursor = c.find((Bson)new Document("_id", (Object)name)).iterator();){
                if (!cursor.hasNext()) {
                    Optional<Group> optional = Optional.empty();
                    return optional;
                }
                if (group == null) {
                    group = (Group)this.plugin.getGroupManager().getOrMake(name);
                    group.getIoLock().lock();
                }
                Document d = (Document)cursor.next();
                Set nodes = MongoStorage.nodesFromDoc(d).stream().map(NodeDataContainer::toNode).collect(Collectors.toSet());
                group.setNodes(NodeMapType.ENDURING, nodes);
            }
        }
        finally {
            if (group != null) {
                group.invalidateCachedData();
                group.getIoLock().unlock();
            }
        }
        return Optional.of(group);
    }

    @Override
    public void loadAllGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        MongoCollection c = this.database.getCollection(this.prefix + "groups");
        MongoCursor cursor = c.find().iterator();
        Object object = null;
        try {
            while (cursor.hasNext()) {
                String name = ((Document)cursor.next()).getString((Object)"_id");
                groups.add(name);
            }
        }
        catch (Throwable name) {
            object = name;
            throw name;
        }
        finally {
            if (cursor != null) {
                if (object != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable name) {
                        ((Throwable)object).addSuppressed(name);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        boolean success = true;
        for (String g2 : groups) {
            try {
                this.loadGroup(g2);
            }
            catch (Exception e) {
                e.printStackTrace();
                success = false;
            }
        }
        if (!success) {
            throw new RuntimeException("Exception occurred whilst loading a group");
        }
        GroupManager<? extends Group> gm = this.plugin.getGroupManager();
        gm.getAll().values().stream().filter(g -> !groups.contains(g.getName())).forEach(gm::unload);
    }

    @Override
    public void saveGroup(Group group) {
        group.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "groups");
            c.replaceOne((Bson)new Document("_id", (Object)group.getName()), (Object)MongoStorage.groupToDoc(group), new UpdateOptions().upsert(true));
        }
        finally {
            group.getIoLock().unlock();
        }
    }

    @Override
    public void deleteGroup(Group group) {
        group.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "groups");
            c.deleteOne((Bson)new Document("_id", (Object)group.getName()));
        }
        finally {
            group.getIoLock().unlock();
        }
    }

    @Override
    public List<HeldPermission<String>> getGroupsWithPermission(Constraint constraint) {
        ArrayList<HeldPermission<String>> held = new ArrayList<HeldPermission<String>>();
        MongoCollection c = this.database.getCollection(this.prefix + "groups");
        try (MongoCursor cursor = c.find().iterator();){
            while (cursor.hasNext()) {
                Document d = (Document)cursor.next();
                String holder = d.getString((Object)"_id");
                HashSet<NodeDataContainer> nodes = new HashSet<NodeDataContainer>(MongoStorage.nodesFromDoc(d));
                for (NodeDataContainer e : nodes) {
                    if (!constraint.eval(e.getPermission())) continue;
                    held.add(NodeHeldPermission.of(holder, e));
                }
            }
        }
        return held;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Track createAndLoadTrack(String name) {
        Track track = (Track)this.plugin.getTrackManager().getOrMake(name);
        track.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "tracks");
            try (MongoCursor cursor = c.find((Bson)new Document("_id", (Object)track.getName())).iterator();){
                if (!cursor.hasNext()) {
                    c.insertOne((Object)MongoStorage.trackToDoc(track));
                } else {
                    Document d = (Document)cursor.next();
                    track.setGroups((List)d.get((Object)"groups"));
                }
            }
        }
        finally {
            track.getIoLock().unlock();
        }
        return track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Track> loadTrack(String name) {
        Track track = (Track)this.plugin.getTrackManager().getIfLoaded(name);
        if (track != null) {
            track.getIoLock().lock();
        }
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "tracks");
            try (MongoCursor cursor = c.find((Bson)new Document("_id", (Object)name)).iterator();){
                if (!cursor.hasNext()) {
                    Optional<Track> optional = Optional.empty();
                    return optional;
                }
                if (track == null) {
                    track = (Track)this.plugin.getTrackManager().getOrMake(name);
                    track.getIoLock().lock();
                }
                Document d = (Document)cursor.next();
                track.setGroups((List)d.get((Object)"groups"));
            }
        }
        finally {
            if (track != null) {
                track.getIoLock().unlock();
            }
        }
        return Optional.of(track);
    }

    @Override
    public void loadAllTracks() {
        ArrayList<String> tracks = new ArrayList<String>();
        MongoCollection c = this.database.getCollection(this.prefix + "tracks");
        MongoCursor cursor = c.find().iterator();
        Object object = null;
        try {
            while (cursor.hasNext()) {
                String name = ((Document)cursor.next()).getString((Object)"_id");
                tracks.add(name);
            }
        }
        catch (Throwable name) {
            object = name;
            throw name;
        }
        finally {
            if (cursor != null) {
                if (object != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable name) {
                        ((Throwable)object).addSuppressed(name);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        boolean success = true;
        for (String t2 : tracks) {
            try {
                this.loadTrack(t2);
            }
            catch (Exception e) {
                e.printStackTrace();
                success = false;
            }
        }
        if (!success) {
            throw new RuntimeException("Exception occurred whilst loading a track");
        }
        TrackManager<? extends Track> tm = this.plugin.getTrackManager();
        tm.getAll().values().stream().filter(t -> !tracks.contains(t.getName())).forEach(tm::unload);
    }

    @Override
    public void saveTrack(Track track) {
        track.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "tracks");
            c.replaceOne((Bson)new Document("_id", (Object)track.getName()), (Object)MongoStorage.trackToDoc(track));
        }
        finally {
            track.getIoLock().unlock();
        }
    }

    @Override
    public void deleteTrack(Track track) {
        track.getIoLock().lock();
        try {
            MongoCollection c = this.database.getCollection(this.prefix + "tracks");
            c.deleteOne((Bson)new Document("_id", (Object)track.getName()));
        }
        finally {
            track.getIoLock().unlock();
        }
    }

    @Override
    public PlayerSaveResult savePlayerData(UUID uuid, String username) {
        username = username.toLowerCase();
        MongoCollection c = this.database.getCollection(this.prefix + "uuid");
        String oldUsername = this.getPlayerName(uuid);
        if (!username.equalsIgnoreCase(oldUsername)) {
            c.replaceOne((Bson)new Document("_id", (Object)uuid), (Object)new Document("_id", (Object)uuid).append("name", (Object)username), new UpdateOptions().upsert(true));
        }
        PlayerSaveResultImpl result = PlayerSaveResultImpl.determineBaseResult(username, oldUsername);
        HashSet<UUID> conflicting = new HashSet<UUID>();
        try (MongoCursor cursor = c.find((Bson)new Document("name", (Object)username)).iterator();){
            if (cursor.hasNext()) {
                conflicting.add((UUID)((Document)cursor.next()).get((Object)"_id", UUID.class));
            }
        }
        conflicting.remove(uuid);
        if (!conflicting.isEmpty()) {
            c.deleteMany(Filters.and((Iterable)conflicting.stream().map(u -> Filters.eq((String)"_id", (Object)u)).collect(Collectors.toList())));
            result = result.withOtherUuidsPresent(conflicting);
        }
        return result;
    }

    @Override
    public UUID getPlayerUuid(String username) {
        MongoCollection c = this.database.getCollection(this.prefix + "uuid");
        Document doc = (Document)c.find((Bson)new Document("name", (Object)username.toLowerCase())).first();
        if (doc != null) {
            return (UUID)doc.get((Object)"_id", UUID.class);
        }
        return null;
    }

    @Override
    public String getPlayerName(UUID uuid) {
        MongoCollection c = this.database.getCollection(this.prefix + "uuid");
        Document doc = (Document)c.find((Bson)new Document("_id", (Object)uuid)).first();
        if (doc != null) {
            return (String)doc.get((Object)"name", String.class);
        }
        return null;
    }

    private static Document userToDoc(User user) {
        List nodes = user.enduringData().immutable().values().stream().map(NodeDataContainer::fromNode).map(MongoStorage::nodeToDoc).collect(Collectors.toList());
        return new Document("_id", (Object)user.getUuid()).append("name", (Object)user.getName().orElse("null")).append("primaryGroup", (Object)user.getPrimaryGroup().getStoredValue().orElse("default")).append("permissions", nodes);
    }

    private static List<NodeDataContainer> nodesFromDoc(Document document) {
        ArrayList<NodeDataContainer> nodes = new ArrayList<NodeDataContainer>();
        if (document.containsKey((Object)"perms") && document.get((Object)"perms") instanceof Map) {
            Map permsMap = (Map)document.get((Object)"perms");
            for (Map.Entry e : permsMap.entrySet()) {
                String permission = ((String)e.getKey()).replace("[**DOT**]", ".").replace("[**DOLLAR**]", "$");
                nodes.add(NodeDataContainer.fromNode(LegacyNodeFactory.fromLegacyString(permission, (Boolean)e.getValue())));
            }
        }
        if (document.containsKey((Object)"permissions") && document.get((Object)"permissions") instanceof List) {
            List permsList = (List)document.get((Object)"permissions");
            for (Document d : permsList) {
                nodes.add(MongoStorage.nodeFromDoc(d));
            }
        }
        return nodes;
    }

    private static Document groupToDoc(Group group) {
        List nodes = group.enduringData().immutable().values().stream().map(NodeDataContainer::fromNode).map(MongoStorage::nodeToDoc).collect(Collectors.toList());
        return new Document("_id", (Object)group.getName()).append("permissions", nodes);
    }

    private static Document trackToDoc(Track track) {
        return new Document("_id", (Object)track.getName()).append("groups", track.getGroups());
    }

    private static Document nodeToDoc(NodeDataContainer node) {
        Document document = new Document();
        document.append("permission", (Object)node.getPermission());
        document.append("value", (Object)node.getValue());
        if (!node.getServer().equals("global")) {
            document.append("server", (Object)node.getServer());
        }
        if (!node.getWorld().equals("global")) {
            document.append("world", (Object)node.getWorld());
        }
        if (node.getExpiry() != 0L) {
            document.append("expiry", (Object)node.getExpiry());
        }
        if (!node.getContexts().isEmpty()) {
            document.append("context", MongoStorage.contextSetToDocs(node.getContexts()));
        }
        return document;
    }

    private static NodeDataContainer nodeFromDoc(Document document) {
        String permission = document.getString((Object)"permission");
        boolean value = true;
        String server = "global";
        String world = "global";
        long expiry = 0L;
        ImmutableContextSet context = ImmutableContextSet.empty();
        if (document.containsKey((Object)"value")) {
            value = document.getBoolean((Object)"value");
        }
        if (document.containsKey((Object)"server")) {
            server = document.getString((Object)"server");
        }
        if (document.containsKey((Object)"world")) {
            world = document.getString((Object)"world");
        }
        if (document.containsKey((Object)"expiry")) {
            expiry = document.getLong((Object)"expiry");
        }
        if (document.containsKey((Object)"context") && document.get((Object)"context") instanceof List) {
            List contexts = (List)document.get((Object)"context");
            context = MongoStorage.docsToContextSet(contexts).makeImmutable();
        }
        return NodeDataContainer.of(permission, value, server, world, expiry, context);
    }

    private static List<Document> contextSetToDocs(ContextSet contextSet) {
        ArrayList<Document> contexts = new ArrayList<Document>();
        for (Map.Entry<String, String> e : contextSet.toSet()) {
            contexts.add(new Document().append("key", (Object)e.getKey()).append("value", (Object)e.getValue()));
        }
        return contexts;
    }

    private static MutableContextSet docsToContextSet(List<Document> documents) {
        MutableContextSet map = MutableContextSet.create();
        for (Document doc : documents) {
            map.add(doc.getString((Object)"key"), doc.getString((Object)"value"));
        }
        return map;
    }
}

