/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.tasks;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.api.event.cause.CreationCause;
import me.lucko.luckperms.common.buffers.BufferedRequest;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;

public class SyncTask
implements Runnable {
    private final LuckPermsPlugin plugin;
    private final boolean initialUpdate;

    public SyncTask(LuckPermsPlugin plugin, boolean initialUpdate) {
        this.plugin = plugin;
        this.initialUpdate = initialUpdate;
    }

    @Override
    public void run() {
        if (this.plugin.getEventFactory().handlePreSync(false)) {
            return;
        }
        this.plugin.getStorage().loadAllGroups().join();
        if (!this.plugin.getGroupManager().isLoaded("default")) {
            this.plugin.getStorage().createAndLoadGroup("default", CreationCause.INTERNAL).join();
        }
        this.plugin.getStorage().loadAllTracks().join();
        this.plugin.getUserManager().invalidateAllUserCaches();
        CompletableFuture<Void> userUpdateFut = this.plugin.getUserManager().updateAllUsers();
        if (!this.initialUpdate) {
            userUpdateFut.join();
        }
        this.plugin.performPlatformDataSync();
        this.plugin.getEventFactory().handlePostSync();
    }

    public static class Buffer
    extends BufferedRequest<Void> {
        private final LuckPermsPlugin plugin;

        public Buffer(LuckPermsPlugin plugin) {
            super(500L, TimeUnit.MILLISECONDS, plugin.getBootstrap().getScheduler());
            this.plugin = plugin;
        }

        @Override
        protected Void perform() {
            new SyncTask(this.plugin, false).run();
            return null;
        }
    }
}

