/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.treeview;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ImmutableTreeNode
implements Comparable<ImmutableTreeNode> {
    private Map<String, ImmutableTreeNode> children = null;

    public ImmutableTreeNode(Stream<Map.Entry<String, ImmutableTreeNode>> children) {
        if (children != null) {
            LinkedHashMap sortedMap = children.sorted((o1, o2) -> {
                int childStatus = ((ImmutableTreeNode)o1.getValue()).compareTo((ImmutableTreeNode)o2.getValue());
                if (childStatus != 0) {
                    return childStatus;
                }
                return String.CASE_INSENSITIVE_ORDER.compare(o1.getKey(), o2.getKey());
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            this.children = ImmutableMap.copyOf((Map)sortedMap);
        }
    }

    public Optional<Map<String, ImmutableTreeNode>> getChildren() {
        return Optional.ofNullable(this.children);
    }

    public List<Map.Entry<Integer, String>> getNodeEndings() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<Integer, String>> results = new ArrayList<Map.Entry<Integer, String>>();
        for (Map.Entry<String, ImmutableTreeNode> node : this.children.entrySet()) {
            String value = node.getKey();
            results.add(Maps.immutableEntry((Object)0, (Object)value));
            results.addAll(node.getValue().getNodeEndings().stream().map(e -> Maps.immutableEntry((Object)((Integer)e.getKey() + 1), (Object)(value + "." + (String)e.getValue()))).collect(Collectors.toList()));
        }
        return results;
    }

    public JsonObject toJson(String prefix) {
        if (this.children == null) {
            return new JsonObject();
        }
        JsonObject object = new JsonObject();
        for (Map.Entry<String, ImmutableTreeNode> entry : this.children.entrySet()) {
            String name = prefix + entry.getKey();
            object.add(name, (JsonElement)entry.getValue().toJson(name + "."));
        }
        return object;
    }

    @Override
    public int compareTo(@NonNull ImmutableTreeNode o) {
        return this.children != null == o.getChildren().isPresent() ? 0 : (this.children != null ? 1 : -1);
    }
}

