/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.utils;

import com.google.common.collect.ForwardingSet;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.lib.caffeine.cache.Cache;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpiringSet<E>
extends ForwardingSet<E> {
    private final Cache<E, Boolean> cache;
    private final Set<E> setView;

    public ExpiringSet(long duration, TimeUnit unit) {
        this.cache = Caffeine.newBuilder().expireAfterAccess(duration, unit).build();
        this.setView = this.cache.asMap().keySet();
    }

    public boolean add(@NonNull E element) {
        this.cache.put(element, (Object)Boolean.TRUE);
        return true;
    }

    public boolean addAll(@NonNull Collection<? extends E> collection) {
        for (E element : collection) {
            this.add(element);
        }
        return true;
    }

    public boolean remove(@NonNull Object key) {
        this.cache.invalidate(key);
        return true;
    }

    public boolean removeAll(@NonNull Collection<?> keys) {
        this.cache.invalidateAll(keys);
        return true;
    }

    protected Set<E> delegate() {
        return this.setView;
    }
}

