/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.commands;

import java.util.List;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;
import me.lucko.luckperms.sponge.commands.SpongeCommandUtils;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;

public class ParentClear
extends SubCommand<LPSubjectData> {
    public ParentClear(LocaleManager locale) {
        super(CommandSpec.SPONGE_PARENT_CLEAR.localize(locale), "clear", CommandPermission.SPONGE_PARENT_CLEAR, Predicates.alwaysFalse());
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, LPSubjectData subjectData, List<String> args, String label) {
        ImmutableContextSet contextSet = ArgumentParser.parseContextSponge(0, args);
        if (contextSet.isEmpty()) {
            subjectData.clearParents();
            MessageUtils.sendPluginMessage(sender, "&aCleared parents matching contexts &bANY&a.");
        } else {
            subjectData.clearParents(contextSet);
            MessageUtils.sendPluginMessage(sender, "&aCleared parents matching contexts &b" + SpongeCommandUtils.contextToString(contextSet, plugin.getLocaleManager()));
        }
        return CommandResult.SUCCESS;
    }
}

