/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.commands;

import java.util.List;
import java.util.Map;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;

public final class SpongeCommandUtils {
    public static Tristate parseTristate(int index, List<String> args) throws ArgumentParser.ArgumentException {
        String s = args.get(index).toLowerCase();
        if (s.equals("1") || s.equals("true") || s.equals("t")) {
            return Tristate.TRUE;
        }
        if (s.equals("0") || s.equals("null") || s.equals("none") || s.equals("undefined") || s.equals("undef")) {
            return Tristate.UNDEFINED;
        }
        if (s.equals("-1") || s.equals("false") || s.equals("f")) {
            return Tristate.FALSE;
        }
        throw new ArgumentParser.DetailedUsageException();
    }

    public static String nodesToString(Map<String, Boolean> nodes) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Boolean> e : nodes.entrySet()) {
            sb.append("&3> ").append(e.getValue() != false ? "&a" : "&c").append(e.getKey()).append("\n");
        }
        return sb.toString();
    }

    public static String optionsToString(Map<String, String> options) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : options.entrySet()) {
            sb.append("&3> &a").append(e.getKey()).append(" &f= \"").append(e.getKey()).append("&f\"\n");
        }
        return sb.toString();
    }

    public static String parentsToString(Iterable<LPSubjectReference> parents) {
        StringBuilder sb = new StringBuilder();
        for (LPSubjectReference s : parents) {
            sb.append("&3> &a").append(s.getSubjectIdentifier()).append(" &bfrom collection &a").append(s.getCollectionIdentifier()).append("&b.\n");
        }
        return sb.toString();
    }

    public static String contextToString(ContextSet set, LocaleManager localeManager) {
        return MessageUtils.contextSetToString(localeManager, set);
    }

    private SpongeCommandUtils() {
    }
}

