/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.messaging;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.api.messenger.IncomingMessageConsumer;
import me.lucko.luckperms.api.messenger.Messenger;
import me.lucko.luckperms.api.messenger.message.OutgoingMessage;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Platform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.network.ChannelBuf;
import org.spongepowered.api.network.RawDataListener;
import org.spongepowered.api.network.RemoteConnection;

public class PluginMessageMessenger
implements Messenger,
RawDataListener {
    private static final String CHANNEL = "luckperms:update";
    private final LPSpongePlugin plugin;
    private final IncomingMessageConsumer consumer;
    private ChannelBinding.RawDataChannel channel = null;

    public PluginMessageMessenger(LPSpongePlugin plugin, IncomingMessageConsumer consumer) {
        this.plugin = plugin;
        this.consumer = consumer;
    }

    public void init() {
        this.channel = this.plugin.getBootstrap().getGame().getChannelRegistrar().createRawChannel((Object)this.plugin.getBootstrap(), CHANNEL);
        this.channel.addListener(Platform.Type.SERVER, (RawDataListener)this);
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.plugin.getBootstrap().getGame().getChannelRegistrar().unbindChannel((ChannelBinding)this.channel);
        }
    }

    @Override
    public void sendOutgoingMessage(@NonNull OutgoingMessage outgoingMessage) {
        this.plugin.getBootstrap().getSpongeScheduler().createTaskBuilder().interval(10L, TimeUnit.SECONDS).execute(task -> {
            if (!this.plugin.getBootstrap().getGame().isServerAvailable()) {
                return;
            }
            Collection players = this.plugin.getBootstrap().getGame().getServer().getOnlinePlayers();
            Player p = (Player)Iterables.getFirst((Iterable)players, null);
            if (p == null) {
                return;
            }
            this.channel.sendTo(p, buf -> buf.writeUTF(outgoingMessage.asEncodedString()));
            task.cancel();
        }).submit((Object)this.plugin.getBootstrap());
    }

    public void handlePayload(@NonNull ChannelBuf buf, @NonNull RemoteConnection connection, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Platform.Type type) {
        String msg = buf.readUTF();
        this.consumer.consumeIncomingMessageAsString(msg);
    }
}

