/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.context;

import java.util.Iterator;
import java.util.Map;
import me.lucko.luckperms.api.context.MutableContextSet;
import me.lucko.luckperms.sponge.service.context.AbstractDelegatingContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.service.context.Context;

public class DelegatingMutableContextSet
extends AbstractDelegatingContextSet {
    private final MutableContextSet delegate;

    public DelegatingMutableContextSet(MutableContextSet delegate) {
        this.delegate = delegate;
    }

    @Override
    public MutableContextSet getDelegate() {
        return this.delegate;
    }

    @Override
    public @NonNull Iterator<Context> iterator() {
        return new ContextSetIterator();
    }

    @Override
    public boolean add(Context context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (context.getKey().isEmpty() || context.getValue().isEmpty()) {
            return false;
        }
        boolean has = this.delegate.has((Map.Entry<String, String>)context);
        this.delegate.add((Map.Entry<String, String>)context);
        return !has;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Context) {
            Context context = (Context)o;
            if (context.getKey().isEmpty() || context.getValue().isEmpty()) {
                return false;
            }
            boolean had = this.delegate.has((Map.Entry<String, String>)context);
            this.delegate.remove(context.getKey(), context.getValue());
            return had;
        }
        return false;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public String toString() {
        return "DelegatingMutableContextSet(delegate=" + this.getDelegate() + ")";
    }

    private final class ContextSetIterator
    implements Iterator<Context> {
        private final Iterator<Map.Entry<String, String>> it;
        private Context current;

        private ContextSetIterator() {
            this.it = DelegatingMutableContextSet.this.delegate.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Context next() {
            Map.Entry<String, String> next = this.it.next();
            this.current = new Context(next.getKey(), next.getValue());
            return this.current;
        }

        @Override
        public void remove() {
            Context c = this.current;
            if (c == null) {
                throw new IllegalStateException();
            }
            this.current = null;
            DelegatingMutableContextSet.this.delegate.remove(c.getKey(), c.getValue());
        }
    }
}

