/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.inheritance;

import java.util.stream.Collectors;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.sponge.service.calculated.CalculatedSubject;
import me.lucko.luckperms.sponge.service.inheritance.SubjectInheritanceGraph;

public final class SubjectInheritanceGraphs {
    private static final SubjectInheritanceGraph NON_CONTEXTUAL = new NonContextual();

    public static SubjectInheritanceGraph getGraph() {
        return NON_CONTEXTUAL;
    }

    public static SubjectInheritanceGraph getGraph(ImmutableContextSet contextSet) {
        return new Contextual(contextSet);
    }

    private SubjectInheritanceGraphs() {
    }

    private static final class Contextual
    implements SubjectInheritanceGraph {
        private final ImmutableContextSet contextSet;

        private Contextual(ImmutableContextSet contextSet) {
            this.contextSet = contextSet;
        }

        @Override
        public Iterable<? extends CalculatedSubject> successors(CalculatedSubject subject) {
            return subject.getCombinedParents(this.contextSet).stream().map(ref -> ref.resolveLp().join()).filter(p -> p instanceof CalculatedSubject).map(p -> (CalculatedSubject)p).collect(Collectors.toList());
        }
    }

    private static final class NonContextual
    implements SubjectInheritanceGraph {
        private NonContextual() {
        }

        @Override
        public Iterable<? extends CalculatedSubject> successors(CalculatedSubject subject) {
            return subject.getCombinedParents().stream().map(ref -> ref.resolveLp().join()).filter(p -> p instanceof CalculatedSubject).map(p -> (CalculatedSubject)p).collect(Collectors.toList());
        }
    }
}

