/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.luckperms.api.ChatMetaType;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.DataMutateResult;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.caching.type.MetaAccumulator;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.NodeMapType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.factory.NodeFactory;
import me.lucko.luckperms.sponge.service.LuckPermsService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import me.lucko.luckperms.sponge.service.proxy.ProxyFactory;
import org.spongepowered.api.service.permission.SubjectData;

public class HolderSubjectData
implements LPSubjectData {
    private final LuckPermsService service;
    private final NodeMapType type;
    private final PermissionHolder holder;
    private final LPSubject parentSubject;

    public HolderSubjectData(LuckPermsService service, NodeMapType type, PermissionHolder holder, LPSubject parentSubject) {
        this.type = type;
        this.service = service;
        this.holder = holder;
        this.parentSubject = parentSubject;
    }

    private Stream<? extends Node> streamNodes() {
        return this.holder.getData(this.type).immutable().values().stream();
    }

    @Override
    public SubjectData sponge() {
        return ProxyFactory.toSponge(this);
    }

    @Override
    public LPSubject getParentSubject() {
        return this.parentSubject;
    }

    @Override
    public NodeMapType getType() {
        return this.type;
    }

    @Override
    public ImmutableMap<ImmutableContextSet, ImmutableMap<String, Boolean>> getAllPermissions() {
        ImmutableMap.Builder ret = ImmutableMap.builder();
        for (Map.Entry entry : this.holder.getData(this.type).immutable().asMap().entrySet()) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Node n : (Collection)entry.getValue()) {
                builder.put((Object)n.getPermission(), (Object)n.getValue());
            }
            ret.put(entry.getKey(), (Object)builder.build());
        }
        return ret.build();
    }

    @Override
    public CompletableFuture<Boolean> setPermission(ImmutableContextSet contexts, String permission, Tristate tristate) {
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(permission, "permission");
        Objects.requireNonNull(tristate, "tristate");
        if (tristate == Tristate.UNDEFINED) {
            Node node = NodeFactory.builder(permission).withExtraContext(contexts).build();
            this.type.run(() -> this.holder.unsetPermission(node), () -> this.holder.unsetTransientPermission(node));
            return this.objectSave(this.holder).thenApply(v -> true);
        }
        Node node = NodeFactory.builder(permission).setValue(tristate.asBoolean()).withExtraContext(contexts).build();
        this.type.run(() -> {
            this.holder.unsetPermission(node);
            this.holder.setPermission(node);
        }, () -> {
            this.holder.unsetTransientPermission(node);
            this.holder.setTransientPermission(node);
        });
        return this.objectSave(this.holder).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> clearPermissions() {
        boolean ret = this.type.supply(this.holder::clearNodes, this.holder::clearTransientNodes);
        if (!ret) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.holder.getType().isUser()) {
            this.service.getPlugin().getUserManager().giveDefaultIfNeeded((User)this.holder, false);
        }
        return this.objectSave(this.holder).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> clearPermissions(ImmutableContextSet contexts) {
        Objects.requireNonNull(contexts, "contexts");
        boolean ret = this.type.supply(() -> this.holder.clearNodes(contexts), () -> {
            List<Node> toRemove = this.streamNodes().filter(n -> n.getFullContexts().equals(contexts)).collect(Collectors.toList());
            toRemove.forEach(this.holder::unsetTransientPermission);
            return !toRemove.isEmpty();
        });
        if (!ret) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.holder.getType().isUser()) {
            this.service.getPlugin().getUserManager().giveDefaultIfNeeded((User)this.holder, false);
        }
        return this.objectSave(this.holder).thenApply(v -> true);
    }

    @Override
    public ImmutableMap<ImmutableContextSet, ImmutableList<LPSubjectReference>> getAllParents() {
        ImmutableMap.Builder ret = ImmutableMap.builder();
        for (Map.Entry entry : this.holder.getData(this.type).immutable().asMap().entrySet()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Node n : (Collection)entry.getValue()) {
                if (!n.isGroupNode()) continue;
                builder.add((Object)this.service.getGroupSubjects().loadSubject(n.getGroupName()).join().toReference());
            }
            ret.put(entry.getKey(), (Object)builder.build());
        }
        return ret.build();
    }

    @Override
    public CompletableFuture<Boolean> addParent(ImmutableContextSet contexts, LPSubjectReference subject) {
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(subject, "subject");
        if (!subject.getCollectionIdentifier().equals("group")) {
            return CompletableFuture.completedFuture(false);
        }
        Node node = NodeFactory.buildGroupNode(subject.getSubjectIdentifier()).withExtraContext(contexts).build();
        DataMutateResult result = this.type.supply(() -> this.holder.setPermission(node), () -> this.holder.setTransientPermission(node));
        if (!result.asBoolean()) {
            return CompletableFuture.completedFuture(false);
        }
        return this.objectSave(this.holder).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> removeParent(ImmutableContextSet contexts, LPSubjectReference subject) {
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(subject, "subject");
        if (!subject.getCollectionIdentifier().equals("group")) {
            return CompletableFuture.completedFuture(false);
        }
        Node node = NodeFactory.buildGroupNode(subject.getSubjectIdentifier()).withExtraContext(contexts).build();
        DataMutateResult result = this.type.supply(() -> this.holder.unsetPermission(node), () -> this.holder.unsetTransientPermission(node));
        if (!result.asBoolean()) {
            return CompletableFuture.completedFuture(false);
        }
        return this.objectSave(this.holder).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> clearParents() {
        boolean ret = this.type.supply(() -> this.holder.clearParents(true), () -> {
            List<Node> toRemove = this.streamNodes().filter(Node::isGroupNode).collect(Collectors.toList());
            toRemove.forEach(this.holder::unsetTransientPermission);
            return !toRemove.isEmpty();
        });
        if (!ret) {
            return CompletableFuture.completedFuture(false);
        }
        return this.objectSave(this.holder).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> clearParents(ImmutableContextSet contexts) {
        Objects.requireNonNull(contexts, "contexts");
        boolean ret = this.type.supply(() -> this.holder.clearParents(contexts, true), () -> {
            List<Node> toRemove = this.streamNodes().filter(Node::isGroupNode).filter(n -> n.getFullContexts().equals(contexts)).collect(Collectors.toList());
            toRemove.forEach(this.holder::unsetTransientPermission);
            return !toRemove.isEmpty();
        });
        if (!ret) {
            return CompletableFuture.completedFuture(false);
        }
        return this.objectSave(this.holder).thenApply(v -> true);
    }

    @Override
    public ImmutableMap<ImmutableContextSet, ImmutableMap<String, String>> getAllOptions() {
        HashMap options = new HashMap();
        HashMap<ImmutableContextSet, Integer> minPrefixPriority = new HashMap<ImmutableContextSet, Integer>();
        HashMap<ImmutableContextSet, Integer> minSuffixPriority = new HashMap<ImmutableContextSet, Integer>();
        for (Node n : this.holder.getData(this.type).immutable().values()) {
            Map.Entry<Integer, String> value;
            if (!n.getValue() || !n.isMeta() && !n.isPrefix() && !n.isSuffix()) continue;
            ImmutableContextSet immutableContexts = n.getFullContexts().makeImmutable();
            if (!options.containsKey(immutableContexts)) {
                options.put(immutableContexts, new HashMap());
                minPrefixPriority.put(immutableContexts, Integer.MIN_VALUE);
                minSuffixPriority.put(immutableContexts, Integer.MIN_VALUE);
            }
            if (n.isPrefix()) {
                value = n.getPrefix();
                if (value.getKey() <= (Integer)minPrefixPriority.get(immutableContexts)) continue;
                ((Map)options.get(immutableContexts)).put("prefix", value.getValue());
                minPrefixPriority.put(immutableContexts, value.getKey());
                continue;
            }
            if (n.isSuffix()) {
                value = n.getSuffix();
                if (value.getKey() <= (Integer)minSuffixPriority.get(immutableContexts)) continue;
                ((Map)options.get(immutableContexts)).put("suffix", value.getValue());
                minSuffixPriority.put(immutableContexts, value.getKey());
                continue;
            }
            if (!n.isMeta()) continue;
            Map.Entry<String, String> meta = n.getMeta();
            ((Map)options.get(immutableContexts)).put(meta.getKey(), meta.getValue());
        }
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry e : options.entrySet()) {
            map.put(e.getKey(), (Object)ImmutableMap.copyOf((Map)((Map)e.getValue())));
        }
        return map.build();
    }

    @Override
    public CompletableFuture<Boolean> setOption(ImmutableContextSet contexts, String key, String value) {
        Node node;
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        if (key.equalsIgnoreCase("prefix") || key.equalsIgnoreCase("suffix")) {
            ChatMetaType type = ChatMetaType.valueOf(key.toUpperCase());
            List<Node> toRemove = this.streamNodes().filter(type::matches).filter(n -> n.getFullContexts().equals(contexts)).collect(Collectors.toList());
            toRemove.forEach(n -> this.type.run(() -> this.holder.unsetPermission((Node)n), () -> this.holder.unsetTransientPermission((Node)n)));
            MetaAccumulator metaAccumulator = this.holder.accumulateMeta(null, Contexts.of(contexts, Contexts.global().getSettings()));
            metaAccumulator.complete();
            int priority = metaAccumulator.getChatMeta(type).keySet().stream().mapToInt(e -> e).max().orElse(0);
            node = NodeFactory.buildChatMetaNode(type, priority += 10, value).withExtraContext(contexts).build();
        } else {
            List<Node> toRemove = this.streamNodes().filter(n -> n.isMeta() && n.getMeta().getKey().equals(key)).filter(n -> n.getFullContexts().equals(contexts)).collect(Collectors.toList());
            toRemove.forEach(n -> this.type.run(() -> this.holder.unsetPermission((Node)n), () -> this.holder.unsetTransientPermission((Node)n)));
            node = NodeFactory.buildMetaNode(key, value).withExtraContext(contexts).build();
        }
        this.type.run(() -> this.holder.setPermission(node), () -> this.holder.setTransientPermission(node));
        return this.objectSave(this.holder).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> unsetOption(ImmutableContextSet contexts, String key) {
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(key, "key");
        List<Node> toRemove = this.streamNodes().filter(n -> {
            if (key.equalsIgnoreCase("prefix")) {
                return n.isPrefix();
            }
            if (key.equalsIgnoreCase("suffix")) {
                return n.isSuffix();
            }
            return n.isMeta() && n.getMeta().getKey().equals(key);
        }).filter(n -> n.getFullContexts().equals(contexts)).collect(Collectors.toList());
        toRemove.forEach(node -> this.type.run(() -> this.holder.unsetPermission((Node)node), () -> this.holder.unsetTransientPermission((Node)node)));
        return this.objectSave(this.holder).thenApply(v -> true);
    }

    @Override
    public CompletableFuture<Boolean> clearOptions(ImmutableContextSet contexts) {
        Objects.requireNonNull(contexts, "contexts");
        List<Node> toRemove = this.streamNodes().filter(n -> n.isMeta() || n.isPrefix() || n.isSuffix()).filter(n -> n.getFullContexts().equals(contexts)).collect(Collectors.toList());
        toRemove.forEach(node -> this.type.run(() -> this.holder.unsetPermission((Node)node), () -> this.holder.unsetTransientPermission((Node)node)));
        return this.objectSave(this.holder).thenApply(v -> !toRemove.isEmpty());
    }

    @Override
    public CompletableFuture<Boolean> clearOptions() {
        List<Node> toRemove = this.streamNodes().filter(n -> n.isMeta() || n.isPrefix() || n.isSuffix()).collect(Collectors.toList());
        toRemove.forEach(node -> this.type.run(() -> this.holder.unsetPermission((Node)node), () -> this.holder.unsetTransientPermission((Node)node)));
        return this.objectSave(this.holder).thenApply(v -> !toRemove.isEmpty());
    }

    private CompletableFuture<Void> objectSave(PermissionHolder t) {
        if (this.type == NodeMapType.TRANSIENT && t.getType().isGroup()) {
            this.service.getPlugin().getGroupManager().invalidateAllGroupCaches();
            this.service.getPlugin().getUserManager().invalidateAllUserCaches();
            return CompletableFuture.completedFuture(null);
        }
        if (t.getType().isUser()) {
            User user = (User)t;
            return this.service.getPlugin().getStorage().saveUser(user);
        }
        Group group = (Group)t;
        this.service.getPlugin().getGroupManager().invalidateAllGroupCaches();
        this.service.getPlugin().getUserManager().invalidateAllUserCaches();
        return this.service.getPlugin().getStorage().saveGroup(group);
    }
}

