/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.proxy;

import me.lucko.luckperms.common.model.NodeMapType;
import me.lucko.luckperms.sponge.service.model.LPPermissionDescription;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectCollection;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import me.lucko.luckperms.sponge.service.proxy.api6.SubjectDataProxy;
import me.lucko.luckperms.sponge.service.proxy.api6.SubjectProxy;
import me.lucko.luckperms.sponge.service.proxy.api7.PermissionDescriptionProxy;
import me.lucko.luckperms.sponge.service.proxy.api7.PermissionServiceProxy;
import me.lucko.luckperms.sponge.service.proxy.api7.SubjectCollectionProxy;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectData;

public final class ProxyFactory {
    private static final boolean IS_API_7 = ProxyFactory.isApi7();

    private static boolean isApi7() {
        try {
            Subject.class.getDeclaredMethod("asSubjectReference", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static PermissionService toSponge(LPPermissionService luckPerms) {
        return IS_API_7 ? new PermissionServiceProxy(luckPerms) : new me.lucko.luckperms.sponge.service.proxy.api6.PermissionServiceProxy(luckPerms);
    }

    public static SubjectCollection toSponge(LPSubjectCollection luckPerms) {
        return IS_API_7 ? new SubjectCollectionProxy(luckPerms) : new me.lucko.luckperms.sponge.service.proxy.api6.SubjectCollectionProxy(luckPerms.getService(), luckPerms);
    }

    public static Subject toSponge(LPSubject luckPerms) {
        return IS_API_7 ? new me.lucko.luckperms.sponge.service.proxy.api7.SubjectProxy(luckPerms.getService(), luckPerms.toReference()) : new SubjectProxy(luckPerms.getService(), luckPerms.toReference());
    }

    public static SubjectData toSponge(LPSubjectData luckPerms) {
        LPSubject parentSubject = luckPerms.getParentSubject();
        return IS_API_7 ? new me.lucko.luckperms.sponge.service.proxy.api7.SubjectDataProxy(parentSubject.getService(), parentSubject.toReference(), luckPerms.getType() == NodeMapType.ENDURING) : new SubjectDataProxy(parentSubject.getService(), parentSubject.toReference(), luckPerms.getType() == NodeMapType.ENDURING);
    }

    public static PermissionDescription toSponge(LPPermissionDescription luckPerms) {
        return IS_API_7 ? new PermissionDescriptionProxy(luckPerms.getService(), luckPerms) : new me.lucko.luckperms.sponge.service.proxy.api6.PermissionDescriptionProxy(luckPerms.getService(), luckPerms);
    }

    private ProxyFactory() {
    }
}

