/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.proxy.api6;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.common.utils.ImmutableCollectors;
import me.lucko.luckperms.sponge.service.CompatibilityUtil;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectData;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import me.lucko.luckperms.sponge.service.proxy.api6.SubjectProxy;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.util.Tristate;

public final class SubjectDataProxy
implements SubjectData {
    private final LPPermissionService service;
    private final LPSubjectReference ref;
    private final boolean enduring;

    public SubjectDataProxy(LPPermissionService service, LPSubjectReference ref, boolean enduring) {
        this.service = service;
        this.ref = ref;
        this.enduring = enduring;
    }

    private CompletableFuture<LPSubjectData> handle() {
        return this.enduring ? this.ref.resolveLp().thenApply(LPSubject::getSubjectData) : this.ref.resolveLp().thenApply(LPSubject::getTransientSubjectData);
    }

    public @NonNull Map<Set<Context>, Map<String, Boolean>> getAllPermissions() {
        return (Map)((CompletableFuture)this.handle().thenApply(handle -> handle.getAllPermissions().entrySet().stream().collect(ImmutableCollectors.toMap(e -> CompatibilityUtil.convertContexts((ContextSet)e.getKey()), Map.Entry::getValue)))).join();
    }

    public @NonNull Map<String, Boolean> getPermissions(@NonNull Set<Context> contexts) {
        return (Map)((CompletableFuture)this.handle().thenApply(handle -> handle.getPermissions(CompatibilityUtil.convertContexts(contexts)))).join();
    }

    public boolean setPermission(@NonNull Set<Context> contexts, @NonNull String permission, @NonNull Tristate value) {
        this.handle().thenCompose(handle -> handle.setPermission(CompatibilityUtil.convertContexts(contexts), permission, CompatibilityUtil.convertTristate(value)));
        return true;
    }

    public boolean clearPermissions() {
        this.handle().thenCompose(LPSubjectData::clearPermissions);
        return true;
    }

    public boolean clearPermissions(@NonNull Set<Context> contexts) {
        this.handle().thenCompose(handle -> handle.clearPermissions(CompatibilityUtil.convertContexts(contexts)));
        return true;
    }

    public @NonNull Map<Set<Context>, List<Subject>> getAllParents() {
        return (Map)((CompletableFuture)this.handle().thenApply(handle -> handle.getAllParents().entrySet().stream().collect(ImmutableCollectors.toMap(e -> CompatibilityUtil.convertContexts((ContextSet)e.getKey()), e -> ((ImmutableList)e.getValue()).stream().map(s -> new SubjectProxy(this.service, (LPSubjectReference)s)).collect(ImmutableCollectors.toList()))))).join();
    }

    public @NonNull List<Subject> getParents(@NonNull Set<Context> contexts) {
        return (List)((CompletableFuture)this.handle().thenApply(handle -> handle.getParents(CompatibilityUtil.convertContexts(contexts)).stream().map(s -> new SubjectProxy(this.service, (LPSubjectReference)s)).collect(ImmutableCollectors.toList()))).join();
    }

    public boolean addParent(@NonNull Set<Context> contexts, @NonNull Subject parent) {
        this.handle().thenCompose(handle -> handle.addParent(CompatibilityUtil.convertContexts(contexts), this.service.getReferenceFactory().obtain(parent)));
        return true;
    }

    public boolean removeParent(@NonNull Set<Context> contexts, @NonNull Subject parent) {
        this.handle().thenCompose(handle -> handle.removeParent(CompatibilityUtil.convertContexts(contexts), this.service.getReferenceFactory().obtain(parent)));
        return true;
    }

    public boolean clearParents() {
        this.handle().thenCompose(LPSubjectData::clearParents);
        return true;
    }

    public boolean clearParents(@NonNull Set<Context> contexts) {
        this.handle().thenCompose(handle -> handle.clearParents(CompatibilityUtil.convertContexts(contexts)));
        return true;
    }

    public @NonNull Map<Set<Context>, Map<String, String>> getAllOptions() {
        return (Map)((CompletableFuture)this.handle().thenApply(handle -> handle.getAllOptions().entrySet().stream().collect(ImmutableCollectors.toMap(e -> CompatibilityUtil.convertContexts((ContextSet)e.getKey()), Map.Entry::getValue)))).join();
    }

    public @NonNull Map<String, String> getOptions(@NonNull Set<Context> contexts) {
        return (Map)((CompletableFuture)this.handle().thenApply(handle -> handle.getOptions(CompatibilityUtil.convertContexts(contexts)))).join();
    }

    public boolean setOption(@NonNull Set<Context> contexts, @NonNull String key, String value) {
        if (value == null) {
            this.handle().thenCompose(handle -> handle.unsetOption(CompatibilityUtil.convertContexts(contexts), key));
            return true;
        }
        this.handle().thenCompose(handle -> handle.setOption(CompatibilityUtil.convertContexts(contexts), key, value));
        return true;
    }

    public boolean clearOptions(@NonNull Set<Context> contexts) {
        this.handle().thenCompose(handle -> handle.clearOptions(CompatibilityUtil.convertContexts(contexts)));
        return true;
    }

    public boolean clearOptions() {
        this.handle().thenCompose(LPSubjectData::clearOptions);
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubjectDataProxy)) {
            return false;
        }
        SubjectDataProxy other = (SubjectDataProxy)o;
        return this.ref.equals(other.ref) && this.enduring == other.enduring;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.ref.hashCode();
        result = result * 59 + (this.enduring ? 79 : 97);
        return result;
    }

    public String toString() {
        return "luckperms.api6.SubjectDataProxy(ref=" + this.ref + ", enduring=" + this.enduring + ")";
    }
}

