/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop.shop;

import com.carrot.carrotshop.CarrotShop;
import com.carrot.carrotshop.Lang;
import com.carrot.carrotshop.ShopsData;
import com.carrot.carrotshop.ShopsLogs;
import com.carrot.carrotshop.shop.Shop;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.block.tileentity.carrier.TileEntityCarrier;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.type.InventoryRow;
import org.spongepowered.api.item.inventory.type.TileEntityInventory;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@ConfigSerializable
public class aTrade
extends Shop {
    @Setting
    private Inventory toGive;
    @Setting
    private Inventory toTake;
    @Setting
    private Location<World> toGiveChest;
    @Setting
    private Location<World> toTakeChest;
    private static String type = "aTrade";

    public aTrade() {
    }

    public aTrade(Player player, Location<World> sign) throws ExceptionInInitializerError {
        super(sign);
        if (!player.hasPermission("carrotshop.admin.atrade")) {
            throw new ExceptionInInitializerError(Lang.SHOP_PERM.replace("%type%", type));
        }
        Stack<Location<World>> locations = ShopsData.getItemLocations(player);
        if (locations.size() < 2) {
            throw new ExceptionInInitializerError(Lang.SHOP_CHEST2.replace("%type%", type));
        }
        Optional chestTakeOpt = ((Location)locations.get(0)).getTileEntity();
        Optional chestGiveOpt = ((Location)locations.get(1)).getTileEntity();
        if (!(chestTakeOpt.isPresent() && chestGiveOpt.isPresent() && chestTakeOpt.get() instanceof TileEntityCarrier && chestGiveOpt.get() instanceof TileEntityCarrier)) {
            throw new ExceptionInInitializerError(Lang.SHOP_CHEST2.replace("%type%", type));
        }
        TileEntityInventory chestTake = ((TileEntityCarrier)chestTakeOpt.get()).getInventory();
        TileEntityInventory chestGive = ((TileEntityCarrier)chestGiveOpt.get()).getInventory();
        if (chestTake.totalItems() == 0 || chestGive.totalItems() == 0) {
            throw new ExceptionInInitializerError(Lang.SHOP_CHEST_EMPTY);
        }
        this.toTakeChest = (Location)locations.get(0);
        this.toGiveChest = (Location)locations.get(1);
        this.toTake = ((Inventory.Builder)Inventory.builder().from((Object)chestTake)).build((Object)CarrotShop.getInstance());
        this.toGive = ((Inventory.Builder)Inventory.builder().from((Object)chestGive)).build((Object)CarrotShop.getInstance());
        for (Inventory item : chestGive.slots()) {
            if (!item.peek().isPresent()) continue;
            this.toGive.offer((ItemStack)item.peek().get());
        }
        for (Inventory item : chestTake.slots()) {
            if (!item.peek().isPresent()) continue;
            this.toTake.offer((ItemStack)item.peek().get());
        }
        ShopsData.clearItemLocations(player);
        player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, Lang.SHOP_DONE.replace("%type%", type)}));
        this.done(player);
        this.info(player);
    }

    @Override
    public List<Location<World>> getLocations() {
        List<Location<World>> locations = super.getLocations();
        locations.add(this.toGiveChest);
        locations.add(this.toTakeChest);
        return locations;
    }

    @Override
    public boolean update() {
        Optional chest = this.toGiveChest.getTileEntity();
        if (chest.isPresent() && chest.get() instanceof TileEntityCarrier) {
            if (!aTrade.hasEnough((Inventory)((TileEntityCarrier)chest.get()).getInventory(), this.toGive)) {
                this.setFail();
                return false;
            }
        } else {
            this.setFail();
            return false;
        }
        chest = this.toTakeChest.getTileEntity();
        if (chest.isPresent() && chest.get() instanceof TileEntityCarrier) {
            TileEntityInventory chestInv = ((TileEntityCarrier)chest.get()).getInventory();
            if (chestInv.capacity() - chestInv.size() < this.toTake.size()) {
                this.setFail();
                return false;
            }
        } else {
            this.setFail();
            return false;
        }
        this.setOK();
        return true;
    }

    @Override
    public void info(Player player) {
        Text.Builder builder = Text.builder();
        builder.append(new Text[]{Text.of((String)Lang.split(Lang.SHOP_FORMAT_TRADE, "%items%", 0))});
        builder.append(new Text[]{aTrade.formatInventoryNames(this.toTake)});
        builder.append(new Text[]{Text.of((String)Lang.split(Lang.SHOP_FORMAT_TRADE, "%items%", 1))});
        builder.append(new Text[]{aTrade.formatInventoryNames(this.toGive)});
        builder.append(new Text[]{Text.of((String)Lang.split(Lang.SHOP_FORMAT_TRADE, "%items%", 2))});
        player.sendMessage(builder.build());
        if (!this.update()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GOLD, Lang.SHOP_SCHRODINGER}));
        }
    }

    @Override
    public boolean trigger(Player player) {
        Optional items;
        Optional<ItemStack> template;
        TileEntityInventory chestInv;
        Optional chestToGive = this.toGiveChest.getTileEntity();
        if (chestToGive.isPresent() && chestToGive.get() instanceof TileEntityCarrier) {
            if (!aTrade.hasEnough((Inventory)((TileEntityCarrier)chestToGive.get()).getInventory(), this.toGive)) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.GOLD, Lang.SHOP_EMPTY}));
                this.update();
                return false;
            }
        } else {
            return false;
        }
        Optional chestToTake = this.toTakeChest.getTileEntity();
        if (!chestToTake.isPresent() || !(chestToTake.get() instanceof TileEntityCarrier)) {
            return false;
        }
        Optional chest = this.toTakeChest.getTileEntity();
        if (chest.isPresent() && chest.get() instanceof TileEntityCarrier && (chestInv = ((TileEntityCarrier)chest.get()).getInventory()).capacity() - chestInv.size() < this.toTake.size()) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GOLD, Lang.SHOP_FULL}));
            this.update();
            return false;
        }
        Inventory inv = player.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(InventoryRow.class)});
        if (!aTrade.hasEnough(inv, this.toTake)) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, Lang.SHOP_ITEMS}));
            return false;
        }
        TileEntityInventory invToTake = ((TileEntityCarrier)chestToTake.get()).getInventory();
        TileEntityInventory invToGive = ((TileEntityCarrier)chestToGive.get()).getInventory();
        for (Inventory item : this.toTake.slots()) {
            if (!item.peek().isPresent() || !(template = aTrade.getTemplate(inv, (ItemStack)item.peek().get())).isPresent()) continue;
            items = inv.query(new QueryOperation[]{QueryOperationTypes.ITEM_STACK_IGNORE_QUANTITY.of((Object)template.get())}).poll(((ItemStack)item.peek().get()).getQuantity());
            if (items.isPresent()) {
                invToTake.offer((ItemStack)items.get());
                continue;
            }
            return false;
        }
        for (Inventory item : this.toGive.slots()) {
            if (!item.peek().isPresent() || !(template = aTrade.getTemplate((Inventory)invToGive, (ItemStack)item.peek().get())).isPresent()) continue;
            items = invToGive.query(new QueryOperation[]{QueryOperationTypes.ITEM_STACK_IGNORE_QUANTITY.of((Object)template.get())}).poll(((ItemStack)item.peek().get()).getQuantity());
            if (items.isPresent()) {
                inv.offer((ItemStack)items.get()).getRejectedItems().forEach(action -> aTrade.putItemInWorld(action, (Location<World>)player.getLocation()));
                continue;
            }
            return false;
        }
        ShopsLogs.log(this.getOwner(), player, "trade", super.getLocation(), Optional.empty(), Optional.empty(), Optional.of(this.toGive), Optional.of(this.toTake));
        player.sendMessage(Text.of((Object[])new Object[]{Lang.split(Lang.SHOP_RECAP_TRADE, "%items%", 0), aTrade.formatInventoryNames(this.toTake), Lang.split(Lang.SHOP_RECAP_TRADE, "%items%", 1), aTrade.formatInventoryNames(this.toGive), Lang.split(Lang.SHOP_RECAP_TRADE, "%items%", 2)}));
        this.update();
        return true;
    }

    @Override
    public boolean canLoopCurrency(Player src) {
        return false;
    }
}

