/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.entity;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.text.translation.Translatable;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.util.RelativePositions;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public interface Entity
extends Identifiable,
Locatable,
DataHolder,
Translatable {
    public EntityType getType();

    public EntitySnapshot createSnapshot();

    public Random getRandom();

    public boolean setLocation(Location<World> var1);

    default public boolean setLocationSafely(Location<World> location) {
        return Sponge.getGame().getTeleportHelper().getSafeLocation(location).map(this::setLocation).orElse(false);
    }

    public Vector3d getRotation();

    public void setRotation(Vector3d var1);

    public boolean setLocationAndRotation(Location<World> var1, Vector3d var2);

    public boolean setLocationAndRotation(Location<World> var1, Vector3d var2, EnumSet<RelativePositions> var3);

    default public boolean setLocationAndRotationSafely(Location<World> location, Vector3d rotation) {
        return Sponge.getGame().getTeleportHelper().getSafeLocation(location).map(safe -> this.setLocationAndRotation((Location<World>)safe, rotation)).orElse(false);
    }

    default public boolean setLocationAndRotationSafely(Location<World> location, Vector3d rotation, EnumSet<RelativePositions> relativePositions) {
        return Sponge.getGame().getTeleportHelper().getSafeLocation(location).map(safe -> this.setLocationAndRotation((Location<World>)safe, rotation, relativePositions)).orElse(false);
    }

    public Vector3d getScale();

    public void setScale(Vector3d var1);

    public Transform<World> getTransform();

    public boolean setTransform(Transform<World> var1);

    default public boolean setTransformSafely(Transform<World> transform) {
        Preconditions.checkNotNull(transform, (Object)"The transform cannot be null!");
        return this.setLocationAndRotationSafely(transform.getLocation(), transform.getRotation());
    }

    default public boolean transferToWorld(World world) {
        return this.transferToWorld(world, world.getSpawnLocation().getPosition());
    }

    public boolean transferToWorld(World var1, Vector3d var2);

    default public boolean transferToWorld(String worldName, Vector3d position) {
        return Sponge.getServer().getWorld(worldName).map(world -> this.transferToWorld((World)world, position)).orElse(false);
    }

    default public boolean transferToWorld(UUID uuid, Vector3d position) {
        return Sponge.getServer().getWorld(uuid).map(world -> this.transferToWorld((World)world, position)).orElse(false);
    }

    public Optional<AABB> getBoundingBox();

    public List<Entity> getPassengers();

    public boolean hasPassenger(Entity var1);

    public boolean addPassenger(Entity var1);

    public void removePassenger(Entity var1);

    public void clearPassengers();

    public Optional<Entity> getVehicle();

    public boolean setVehicle(@Nullable Entity var1);

    public Entity getBaseVehicle();

    default public Vector3d getVelocity() {
        return this.get(Keys.VELOCITY).get();
    }

    default public DataTransactionResult setVelocity(Vector3d vector3d) {
        return this.offer(Keys.VELOCITY, vector3d);
    }

    public boolean isOnGround();

    public boolean isRemoved();

    public boolean isLoaded();

    public void remove();

    public boolean damage(double var1, DamageSource var3);

    default public Collection<Entity> getNearbyEntities(double distance) {
        return this.getWorld().getNearbyEntities(this.getLocation().getPosition(), distance);
    }

    default public Collection<Entity> getNearbyEntities(Predicate<Entity> predicate) {
        Preconditions.checkNotNull(predicate, (Object)"Null predicate!");
        return this.getWorld().getEntities(predicate::test);
    }

    public Optional<UUID> getCreator();

    public Optional<UUID> getNotifier();

    public void setCreator(@Nullable UUID var1);

    public void setNotifier(@Nullable UUID var1);

    default public boolean canSee(Entity entity) {
        Optional<Boolean> optional = entity.get(Keys.VANISH);
        return !optional.isPresent() || optional.get() == false;
    }

    public EntityArchetype createArchetype();

    default public Value<Boolean> gravity() {
        return this.getValue(Keys.HAS_GRAVITY).get();
    }
}

