/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.weighted;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.spongepowered.api.util.weighted.NestedTableEntry;
import org.spongepowered.api.util.weighted.RandomObjectTable;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.WeightedObject;

public class ChanceTable<T>
extends RandomObjectTable<T> {
    public ChanceTable() {
        super(1);
    }

    public ChanceTable(int rolls) {
        super(rolls);
    }

    @Override
    public List<T> get(Random rand) {
        ArrayList results = Lists.newArrayList();
        if (this.entries.isEmpty()) {
            return results;
        }
        int rolls = this.getRolls().getFlooredAmount(rand);
        for (int i = 0; i < rolls; ++i) {
            for (TableEntry next : this.entries) {
                if (!(rand.nextDouble() < next.getWeight())) continue;
                if (next instanceof NestedTableEntry) {
                    results.addAll(((NestedTableEntry)next).get(rand));
                    continue;
                }
                if (!(next instanceof WeightedObject)) continue;
                results.add(((WeightedObject)next).get());
            }
        }
        return results;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChanceTable)) {
            return false;
        }
        ChanceTable c = (ChanceTable)o;
        if (this.getRolls() != c.getRolls()) {
            return false;
        }
        if (this.entries.size() != c.entries.size()) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            if (((TableEntry)this.entries.get(i)).equals(c.entries.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int r = 1;
        r = r * 37 + this.getRolls().hashCode();
        for (TableEntry entry : this.entries) {
            r = r * 37 + entry.hashCode();
        }
        return r;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("ChanceTable (rolls=").append(this.getRolls());
        r.append(",entries=").append(this.entries.size()).append(") {\n");
        for (TableEntry entry : this.entries) {
            r.append("\t").append(entry.toString()).append("\n");
        }
        r.append("}");
        return r.toString();
    }
}

