/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.gen.populator;

import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.Populator;
import org.spongepowered.api.world.gen.PopulatorObject;

public interface RandomObject
extends Populator {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public VariableAmount getAttemptsPerChunk();

    public void setAttemptsPerChunk(VariableAmount var1);

    default public void setAttemptsPerChunk(int count) {
        this.setAttemptsPerChunk(VariableAmount.fixed(count));
    }

    public VariableAmount getHeightRange();

    public void setHeightRange(VariableAmount var1);

    public PopulatorObject getObject();

    public void setObject(PopulatorObject var1);

    public double getSpawnChance();

    public void setSpawnChance(double var1);

    public static interface Builder
    extends ResettableBuilder<RandomObject, Builder> {
        public Builder perChunk(VariableAmount var1);

        default public Builder perChunk(int count) {
            return this.perChunk(VariableAmount.fixed(count));
        }

        public Builder height(VariableAmount var1);

        public Builder object(PopulatorObject var1);

        public Builder spawnChance(double var1);

        public RandomObject build() throws IllegalStateException;
    }
}

