/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableAreaEffectCloudData;
import org.spongepowered.api.data.manipulator.mutable.entity.AreaEffectCloudData;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.api.effect.particle.ParticleTypes;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeAreaEffectData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.effect.particle.SpongeParticleType;
import org.spongepowered.common.mixin.core.entity.EntityAreaEffectCloudAccessor;

public class AreaEffectCloudDataProcessor
extends AbstractEntityDataProcessor<EntityAreaEffectCloud, AreaEffectCloudData, ImmutableAreaEffectCloudData> {
    public AreaEffectCloudDataProcessor() {
        super(EntityAreaEffectCloud.class);
    }

    @Override
    protected AreaEffectCloudData createManipulator() {
        return new SpongeAreaEffectData();
    }

    @Override
    protected boolean doesDataExist(EntityAreaEffectCloud dataHolder) {
        return true;
    }

    @Override
    protected boolean set(EntityAreaEffectCloud dataHolder, Map<Key<?>, Object> keyValues) {
        int age = (Integer)keyValues.get(Keys.AREA_EFFECT_CLOUD_AGE);
        Color color = (Color)keyValues.get(Keys.AREA_EFFECT_CLOUD_COLOR);
        double radius = (Double)keyValues.get(Keys.AREA_EFFECT_CLOUD_RADIUS);
        double radiusOnUse = (Double)keyValues.get(Keys.AREA_EFFECT_CLOUD_RADIUS_ON_USE);
        int duration = (Integer)keyValues.get(Keys.AREA_EFFECT_CLOUD_DURATION);
        int durationOnUse = (Integer)keyValues.get(Keys.AREA_EFFECT_CLOUD_DURATION_ON_USE);
        int waitTime = (Integer)keyValues.get(Keys.AREA_EFFECT_CLOUD_WAIT_TIME);
        int reapplicationDelay = (Integer)keyValues.get(Keys.AREA_EFFECT_CLOUD_REAPPLICATION_DELAY);
        List potionEffects = (List)keyValues.get(Keys.POTION_EFFECTS);
        ParticleType particleType = (ParticleType)keyValues.get(Keys.AREA_EFFECT_CLOUD_PARTICLE_TYPE);
        dataHolder.field_70173_aa = age;
        dataHolder.func_184482_a(color.getRgb());
        dataHolder.func_184483_a((float)radius);
        dataHolder.func_184495_b((float)radiusOnUse);
        dataHolder.func_184486_b(duration);
        ((EntityAreaEffectCloudAccessor)dataHolder).setDurationOnUse(durationOnUse);
        dataHolder.func_184485_d(waitTime);
        EnumParticleTypes internalType = ((SpongeParticleType)particleType).getInternalType();
        dataHolder.func_184491_a(internalType == null ? EnumParticleTypes.SPELL_MOB : internalType);
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (org.spongepowered.api.effect.potion.PotionEffect effect : potionEffects) {
            effects.add((PotionEffect)effect);
        }
        ((EntityAreaEffectCloudAccessor)dataHolder).setPotionEffects(effects);
        ((EntityAreaEffectCloudAccessor)dataHolder).setReapplicationDelay(reapplicationDelay);
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityAreaEffectCloud dataHolder) {
        HashMap<Key<Value<Object>>, Object> map = new HashMap<Key<Value<Object>>, Object>();
        map.put(Keys.AREA_EFFECT_CLOUD_AGE, dataHolder.field_70173_aa);
        map.put(Keys.AREA_EFFECT_CLOUD_COLOR, Color.ofRgb(dataHolder.func_184492_k()));
        map.put(Keys.AREA_EFFECT_CLOUD_RADIUS, Float.valueOf(dataHolder.func_184490_j()));
        EntityAreaEffectCloudAccessor mixinAreaEffect = (EntityAreaEffectCloudAccessor)dataHolder;
        List<PotionEffect> potionEffects = mixinAreaEffect.getPotionEffects();
        ArrayList<org.spongepowered.api.effect.potion.PotionEffect> effects = new ArrayList<org.spongepowered.api.effect.potion.PotionEffect>(potionEffects.size());
        for (PotionEffect potionEffect : potionEffects) {
            effects.add((org.spongepowered.api.effect.potion.PotionEffect)potionEffect);
        }
        map.put(Keys.POTION_EFFECTS, effects);
        map.put(Keys.AREA_EFFECT_CLOUD_RADIUS_ON_USE, Float.valueOf(mixinAreaEffect.getRadiusOnUse()));
        map.put(Keys.AREA_EFFECT_CLOUD_RADIUS_PER_TICK, Float.valueOf(mixinAreaEffect.getRadiusPerTick()));
        map.put(Keys.AREA_EFFECT_CLOUD_DURATION, dataHolder.func_184489_o());
        map.put(Keys.AREA_EFFECT_CLOUD_DURATION_ON_USE, mixinAreaEffect.getDurationOnUse());
        map.put(Keys.AREA_EFFECT_CLOUD_REAPPLICATION_DELAY, mixinAreaEffect.getReapplicationDelay());
        map.put(Keys.AREA_EFFECT_CLOUD_WAIT_TIME, mixinAreaEffect.getWaitTime());
        map.put(Keys.AREA_EFFECT_CLOUD_PARTICLE_TYPE, ParticleTypes.MOB_SPELL);
        return map;
    }

    @Override
    public Optional<AreaEffectCloudData> fill(DataContainer container, AreaEffectCloudData areaEffectCloudData) {
        return null;
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return null;
    }
}

