/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.item;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutableHideData;
import org.spongepowered.api.data.manipulator.mutable.item.HideData;
import org.spongepowered.common.data.manipulator.mutable.item.SpongeHideData;
import org.spongepowered.common.data.processor.common.AbstractMultiDataSingleTargetProcessor;

public class HideDataProcessor
extends AbstractMultiDataSingleTargetProcessor<ItemStack, HideData, ImmutableHideData> {
    public HideDataProcessor() {
        super(ItemStack.class);
    }

    @Override
    protected boolean doesDataExist(ItemStack dataHolder) {
        return dataHolder.func_77942_o();
    }

    @Override
    protected boolean set(ItemStack dataHolder, Map<Key<?>, Object> keyValues) {
        if (!dataHolder.func_77942_o()) {
            dataHolder.func_77982_d(new NBTTagCompound());
        }
        int flag = 0;
        if (((Boolean)keyValues.get(Keys.HIDE_ENCHANTMENTS)).booleanValue()) {
            flag |= 1;
        }
        if (((Boolean)keyValues.get(Keys.HIDE_ATTRIBUTES)).booleanValue()) {
            flag |= 2;
        }
        if (((Boolean)keyValues.get(Keys.HIDE_UNBREAKABLE)).booleanValue()) {
            flag |= 4;
        }
        if (((Boolean)keyValues.get(Keys.HIDE_CAN_DESTROY)).booleanValue()) {
            flag |= 8;
        }
        if (((Boolean)keyValues.get(Keys.HIDE_CAN_PLACE)).booleanValue()) {
            flag |= 0x10;
        }
        if (((Boolean)keyValues.get(Keys.HIDE_MISCELLANEOUS)).booleanValue()) {
            flag |= 0x20;
        }
        dataHolder.func_77978_p().func_74768_a("HideFlags", flag);
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(ItemStack dataHolder) {
        if (!dataHolder.func_77942_o()) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        int flag = dataHolder.func_77978_p().func_74762_e("HideFlags");
        map.put(Keys.HIDE_MISCELLANEOUS, (flag & 0x20) != 0);
        map.put(Keys.HIDE_CAN_PLACE, (flag & 0x10) != 0);
        map.put(Keys.HIDE_CAN_DESTROY, (flag & 8) != 0);
        map.put(Keys.HIDE_UNBREAKABLE, (flag & 4) != 0);
        map.put(Keys.HIDE_ATTRIBUTES, (flag & 2) != 0);
        map.put(Keys.HIDE_ENCHANTMENTS, (flag & 1) != 0);
        return map;
    }

    @Override
    protected HideData createManipulator() {
        return new SpongeHideData();
    }

    @Override
    public Optional<HideData> fill(DataContainer container, HideData hideData) {
        Optional<Boolean> enchantments = container.getBoolean(Keys.HIDE_ENCHANTMENTS.getQuery());
        Optional<Boolean> attributes = container.getBoolean(Keys.HIDE_ATTRIBUTES.getQuery());
        Optional<Boolean> unbreakable = container.getBoolean(Keys.HIDE_UNBREAKABLE.getQuery());
        Optional<Boolean> canDestroy = container.getBoolean(Keys.HIDE_CAN_DESTROY.getQuery());
        Optional<Boolean> canPlace = container.getBoolean(Keys.HIDE_CAN_PLACE.getQuery());
        Optional<Boolean> miscellaneous = container.getBoolean(Keys.HIDE_MISCELLANEOUS.getQuery());
        if (enchantments.isPresent() && attributes.isPresent() && unbreakable.isPresent() && canDestroy.isPresent() && canPlace.isPresent() && miscellaneous.isPresent()) {
            return Optional.of(new SpongeHideData(enchantments.get(), attributes.get(), unbreakable.get(), canDestroy.get(), canPlace.get(), miscellaneous.get()));
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        if (this.supports(dataHolder)) {
            ItemStack data = (ItemStack)dataHolder;
            if (data.func_77942_o() && data.func_77978_p().func_150297_b("HideFlags", 3)) {
                data.func_77978_p().func_82580_o("HideFlags");
            }
            return DataTransactionResult.successNoData();
        }
        return DataTransactionResult.failNoData();
    }
}

