/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.util;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.TypeTokens;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.data.DataProcessor;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.SpongeManipulatorRegistry;
import org.spongepowered.common.data.ValueProcessor;
import org.spongepowered.common.data.fixer.entity.EntityTrackedUser;
import org.spongepowered.common.data.fixer.entity.player.PlayerRespawnData;
import org.spongepowered.common.data.fixer.world.SpongeLevelFixer;
import org.spongepowered.common.data.nbt.NbtDataType;
import org.spongepowered.common.data.nbt.data.NbtDataProcessor;
import org.spongepowered.common.data.nbt.validation.DelegateDataValidator;
import org.spongepowered.common.data.nbt.validation.RawDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.nbt.value.NbtValueProcessor;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.persistence.SerializedDataTransaction;
import org.spongepowered.common.data.processor.common.AbstractSingleDataSingleTargetProcessor;
import org.spongepowered.common.data.util.DataProcessorDelegate;
import org.spongepowered.common.data.util.ValueProcessorDelegate;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.TypeTokenHelper;

public final class DataUtil {
    public static final DataFixer spongeDataFixer = new DataFixer(1);
    private static final Supplier<InvalidDataException> INVALID_DATA_EXCEPTION_SUPPLIER = InvalidDataException::new;

    public static DataView checkDataExists(DataView dataView, DataQuery query) throws InvalidDataException {
        if (!((DataView)Preconditions.checkNotNull((Object)dataView)).contains((DataQuery)Preconditions.checkNotNull((Object)query))) {
            throw new InvalidDataException("Missing data for query: " + query.asString('.'));
        }
        return dataView;
    }

    public static <T> T getData(DataView dataView, Key<? extends BaseValue<T>> key) throws InvalidDataException {
        Object object;
        DataUtil.checkDataExists(dataView, ((Key)Preconditions.checkNotNull(key)).getQuery());
        TypeToken<?> elementToken = key.getElementToken();
        if (elementToken.isSubtypeOf(TypeToken.of(DataSerializable.class))) {
            object = dataView.getSerializable(key.getQuery(), elementToken.getRawType()).orElseThrow(() -> new InvalidDataException("Missing value for key: " + key.getId()));
        } else if (elementToken.isSubtypeOf(TypeToken.of(CatalogType.class))) {
            object = dataView.getCatalogType(key.getQuery(), elementToken.getRawType()).orElseThrow(() -> new InvalidDataException("Missing value for key: " + key.getId()));
        } else if (elementToken.isSubtypeOf(TypeToken.of(Text.class))) {
            String input = dataView.getString(key.getQuery()).orElseThrow(() -> new InvalidDataException("Missing value for key: " + key.getId()));
            object = TextSerializers.PLAIN.deserialize(input);
        } else if (elementToken.isSubtypeOf(TypeToken.of(List.class))) {
            Optional<List<?>> opt;
            if (elementToken.isSubtypeOf(TypeTokens.LIST_DATA_SERIALIZEABLE_TOKEN)) {
                Class<?> listElement = TypeTokenHelper.getGenericParam(elementToken, 0);
                opt = dataView.getSerializableList(key.getQuery(), listElement);
            } else {
                opt = dataView.getList(key.getQuery());
            }
            object = opt.orElseThrow(() -> new InvalidDataException("Missing value for key: " + key.getId()));
        } else if (elementToken.isSubtypeOf(TypeToken.of(Set.class))) {
            List objects = dataView.getList(key.getQuery()).orElse(Collections.emptyList());
            object = new HashSet(objects);
        } else {
            Optional<DataTranslator<DataTranslator>> translator;
            object = elementToken.isSubtypeOf(TypeToken.of(Map.class)) ? dataView.getMap(key.getQuery()).orElseThrow(() -> new InvalidDataException("Missing value for key: " + key.getId())) : (elementToken.isSubtypeOf(TypeToken.of(Enum.class)) ? Enum.valueOf(elementToken.getRawType(), dataView.getString(key.getQuery()).orElseThrow(() -> new InvalidDataException("Missing value for key: " + key.getId()))) : ((translator = SpongeDataManager.getInstance().getTranslator(elementToken.getRawType())).isPresent() ? translator.map(trans -> trans.translate(dataView.getView(key.getQuery()).orElseThrow(() -> new InvalidDataException("Missing value for key: " + key.getId())))).orElseThrow(() -> new InvalidDataException("Could not translate translateable: " + key.getId())) : dataView.get(key.getQuery()).orElseThrow(() -> new InvalidDataException("Could not translate translateable: " + key.getId()))));
        }
        return object;
    }

    public static <T> T getData(DataView dataView, Key<?> key, Class<T> clazz) throws InvalidDataException {
        DataUtil.checkDataExists(dataView, ((Key)Preconditions.checkNotNull(key)).getQuery());
        Object object = dataView.get(key.getQuery()).orElseThrow(DataUtil.dataNotFound());
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        throw new InvalidDataException("Could not cast to the correct class type!");
    }

    public static <T> T getData(DataView dataView, DataQuery query, Class<T> data) throws InvalidDataException {
        DataUtil.checkDataExists(dataView, query);
        Object object = dataView.get(query).orElseThrow(DataUtil.dataNotFound());
        if (data.isInstance(object)) {
            return (T)object;
        }
        throw new InvalidDataException("Data does not match!");
    }

    public static List<DataView> getSerializedManipulatorList(Iterable<? extends DataManipulator<?, ?>> manipulators) {
        return DataUtil.getSerializedManipulatorList(manipulators, DataUtil::getRegistrationFor);
    }

    public static List<DataView> getSerializedImmutableManipulatorList(Iterable<? extends ImmutableDataManipulator<?, ?>> manipulators) {
        return DataUtil.getSerializedManipulatorList(manipulators, DataUtil::getRegistrationFor);
    }

    private static <T extends DataSerializable> List<DataView> getSerializedManipulatorList(Iterable<? extends T> manipulators, Function<T, ? extends DataRegistration<?, ?>> func) {
        Preconditions.checkNotNull(manipulators);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DataSerializable manipulator : manipulators) {
            DataContainer container = DataContainer.createNew();
            container.set(Queries.CONTENT_VERSION, (Object)2);
            container.set(Constants.Sponge.DATA_ID, (Object)func.apply(manipulator).getId()).set(Constants.Sponge.INTERNAL_DATA, (Object)manipulator.toContainer());
            builder.add((Object)container);
        }
        return builder.build();
    }

    public static SerializedDataTransaction deserializeManipulatorList(List<? extends DataView> containers) {
        Preconditions.checkNotNull(containers);
        SerializedDataTransaction.Builder builder = SerializedDataTransaction.builder();
        for (DataView dataView : containers) {
            DataView updated = DataUtil.updateDataViewForDataManipulator(dataView);
            DataUtil.findDataId(builder, updated).ifPresent(dataId -> DataUtil.tryDeserializeManipulator(builder, updated, dataId));
        }
        return builder.build();
    }

    private static Optional<String> findDataId(SerializedDataTransaction.Builder builder, DataView view) {
        Optional<String> dataId = view.getString(Constants.Sponge.DATA_ID);
        if (!dataId.isPresent()) {
            String dataClass = view.getString(Constants.Sponge.DATA_CLASS).orElseThrow(DataUtil.dataNotFound());
            DataUtil.addFailedDeserialization(builder, view, dataClass, null);
        }
        return dataId;
    }

    private static void tryDeserializeManipulator(SerializedDataTransaction.Builder builder, DataView view, String dataId) {
        DataView manipulatorView = view.getView(Constants.Sponge.INTERNAL_DATA).orElseThrow(DataUtil.dataNotFound());
        try {
            Optional build = DataUtil.deserializeManipulator(dataId, manipulatorView);
            if (build.isPresent()) {
                builder.successfulData((DataManipulator)build.get());
            } else {
                DataUtil.addFailedDeserialization(builder, view, dataId, null);
            }
        }
        catch (Exception e) {
            DataUtil.addFailedDeserialization(builder, view, dataId, e);
        }
    }

    private static <T extends DataManipulator<?, ?>> Optional<T> deserializeManipulator(String dataId, DataView data) {
        return DataUtil.getRegistrationFor(dataId).map(DataRegistration::getDataManipulatorBuilder).flatMap(b -> b.build(data));
    }

    private static void addFailedDeserialization(SerializedDataTransaction.Builder builder, DataView view, String dataId, @Nullable Throwable cause) {
        SpongeImpl.getCustomDataConfigAdapter().getConfig().getDataRegistrationConfig().addFailedData(dataId, cause);
        SpongeImpl.getCustomDataConfigAdapter().getConfig().getDataRegistrationConfig().purgeOrAllow(builder, dataId, view);
        try {
            SpongeImpl.getCustomDataConfigAdapter().save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static DataView updateDataViewForDataManipulator(DataView dataView) {
        int version = dataView.getInt(Queries.CONTENT_VERSION).orElse(1);
        if (version != 2) {
            DataContentUpdater contentUpdater = SpongeDataManager.getInstance().getWrappedContentUpdater(DataManipulator.class, version, 2).orElseThrow(() -> new IllegalArgumentException("Could not find a content updater for DataManipulator information with version: " + version));
            return contentUpdater.update(dataView);
        }
        return dataView;
    }

    public static ImmutableList<ImmutableDataManipulator<?, ?>> deserializeImmutableManipulatorList(List<? extends DataView> containers) {
        Preconditions.checkNotNull(containers);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DataView dataView : containers) {
            DataView dataView2 = DataUtil.updateDataViewForDataManipulator(dataView);
            String dataId = dataView2.getString(Constants.Sponge.DATA_ID).orElseThrow(DataUtil.dataNotFound());
            DataView manipulatorView = dataView2.getView(Constants.Sponge.INTERNAL_DATA).orElseThrow(DataUtil.dataNotFound());
            try {
                DataUtil.deserializeManipulator(dataId, manipulatorView).map(DataManipulator::asImmutable).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            }
            catch (Exception e) {
                new InvalidDataException("Could not translate " + dataId + "!", e).printStackTrace();
            }
        }
        return builder.build();
    }

    public static Location<World> getLocation(DataView view, boolean castToInt) {
        UUID worldUuid = UUID.fromString(view.getString(Queries.WORLD_ID).orElseThrow(DataUtil.dataNotFound()));
        double x = view.getDouble(Queries.POSITION_X).orElseThrow(DataUtil.dataNotFound());
        double y = view.getDouble(Queries.POSITION_Y).orElseThrow(DataUtil.dataNotFound());
        double z = view.getDouble(Queries.POSITION_Z).orElseThrow(DataUtil.dataNotFound());
        if (castToInt) {
            return new Location<Extent>((Extent)SpongeImpl.getGame().getServer().getWorld(worldUuid).orElseThrow(DataUtil.dataNotFound()), (int)x, (int)y, (int)z);
        }
        return new Location<Extent>((Extent)SpongeImpl.getGame().getServer().getWorld(worldUuid).orElseThrow(DataUtil.dataNotFound()), x, y, z);
    }

    public static Vector3i getPosition3i(DataView view) {
        DataUtil.checkDataExists(view, Constants.Sponge.SNAPSHOT_WORLD_POSITION);
        DataView internal = view.getView(Constants.Sponge.SNAPSHOT_WORLD_POSITION).orElseThrow(DataUtil.dataNotFound());
        int x = internal.getInt(Queries.POSITION_X).orElseThrow(DataUtil.dataNotFound());
        int y = internal.getInt(Queries.POSITION_Y).orElseThrow(DataUtil.dataNotFound());
        int z = internal.getInt(Queries.POSITION_Z).orElseThrow(DataUtil.dataNotFound());
        return new Vector3i(x, y, z);
    }

    public static Vector3d getPosition3d(DataView view, DataQuery query) {
        DataUtil.checkDataExists(view, query);
        DataView internal = view.getView(query).orElseThrow(DataUtil.dataNotFound());
        double x = internal.getDouble(Queries.POSITION_X).orElseThrow(DataUtil.dataNotFound());
        double y = internal.getDouble(Queries.POSITION_Y).orElseThrow(DataUtil.dataNotFound());
        double z = internal.getDouble(Queries.POSITION_Z).orElseThrow(DataUtil.dataNotFound());
        return new Vector3d(x, y, z);
    }

    private static Supplier<InvalidDataException> dataNotFound() {
        return INVALID_DATA_EXCEPTION_SUPPLIER;
    }

    public static <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> void registerDataProcessorAndImpl(Class<T> manipulatorClass, Class<? extends T> implClass, Class<I> immutableDataManipulator, Class<? extends I> implImClass, DataProcessor<T, I> processor) {
        Preconditions.checkState((!SpongeDataManager.areRegistrationsComplete() ? 1 : 0) != 0, (Object)"Registrations are no longer allowed!");
        Preconditions.checkArgument((!Modifier.isAbstract(implClass.getModifiers()) ? 1 : 0) != 0, (Object)"The Implemented DataManipulator class cannot be abstract!");
        Preconditions.checkArgument((!Modifier.isInterface(implClass.getModifiers()) ? 1 : 0) != 0, (Object)"The Implemented DataManipulator class cannot be an interface!");
        Preconditions.checkArgument((!Modifier.isAbstract(implImClass.getModifiers()) ? 1 : 0) != 0, (Object)"The implemented ImmutableDataManipulator class cannot be an interface!");
        Preconditions.checkArgument((!Modifier.isInterface(implImClass.getModifiers()) ? 1 : 0) != 0, (Object)"The implemented ImmutableDataManipulator class cannot be an interface!");
        Preconditions.checkArgument((!(processor instanceof DataProcessorDelegate) ? 1 : 0) != 0, (Object)"Cannot register DataProcessorDelegates!");
        SpongeManipulatorRegistry.getInstance().register(manipulatorClass, implClass, immutableDataManipulator, implImClass, processor);
    }

    public static <E, V extends BaseValue<E>, T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> void registerDualProcessor(Class<T> manipulatorClass, Class<? extends T> implClass, Class<I> immutableDataManipulator, Class<? extends I> implImClass, AbstractSingleDataSingleTargetProcessor<?, E, V, T, I> processor) {
        DataUtil.registerDataProcessorAndImpl(manipulatorClass, implClass, immutableDataManipulator, implImClass, processor);
        DataUtil.registerValueProcessor(processor.getKey(), processor);
    }

    public static <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> Optional<DataProcessor<T, I>> getProcessor(Class<T> mutableClass) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(mutableClass));
    }

    public static Optional<DataProcessor<?, ?>> getWildProcessor(Class<? extends DataManipulator<?, ?>> mutableClass) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(mutableClass));
    }

    public static Optional<DataProcessor> getWildDataProcessor(Class<? extends DataManipulator> mutableClass) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(mutableClass));
    }

    public static <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> Optional<DataProcessor<T, I>> getImmutableProcessor(Class<I> immutableClass) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(immutableClass));
    }

    public static Optional<DataProcessor> getWildImmutableProcessor(Class<? extends ImmutableDataManipulator<?, ?>> immutableClass) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(immutableClass));
    }

    public static <E, V extends BaseValue<E>> void registerValueProcessor(Key<V> key, ValueProcessor<E, V> valueProcessor) {
        Preconditions.checkState((!SpongeDataManager.areRegistrationsComplete() ? 1 : 0) != 0, (Object)"Registrations are no longer allowed!");
        Preconditions.checkNotNull(valueProcessor);
        Preconditions.checkArgument((!(valueProcessor instanceof ValueProcessorDelegate) ? 1 : 0) != 0, (Object)"Cannot register ValueProcessorDelegates! READ THE DOCS!");
        Preconditions.checkNotNull(key);
        SpongeManipulatorRegistry.getInstance().registerValueProcessor(key, valueProcessor);
    }

    public static <E, V extends BaseValue<E>> Optional<ValueProcessor<E, V>> getValueProcessor(Key<V> key) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(key));
    }

    public static Optional<ValueProcessor<?, ?>> getWildValueProcessor(Key<?> key) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(key));
    }

    public static <E> Optional<ValueProcessor<E, ? extends BaseValue<E>>> getBaseValueProcessor(Key<? extends BaseValue<E>> key) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getDelegate(key));
    }

    public static RawDataValidator getValidators(ValidationType validationType) {
        return new DelegateDataValidator((ImmutableList<RawDataValidator>)ImmutableList.of(), validationType);
    }

    public static <E, V extends BaseValue<E>> Optional<NbtValueProcessor<E, V>> getNbtProcessor(NbtDataType dataType, Key<V> key) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getNbtProcessor(dataType, key));
    }

    public static Optional<NbtDataProcessor> getRawNbtProcessor(NbtDataType dataType, Class<? extends DataManipulator> aClass) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getNbtDelegate(dataType, aClass));
    }

    public static Optional<NbtValueProcessor> getRawNbtProcessor(NbtDataType dataType, Key<?> key) {
        return Optional.ofNullable(SpongeManipulatorRegistry.getInstance().getNbtProcessor(dataType, key));
    }

    public static Collection<NbtDataProcessor<?, ?>> getNbtProcessors(NbtDataType type) {
        return SpongeManipulatorRegistry.getInstance().getNbtProcessors(type);
    }

    public static Collection<NbtValueProcessor<?, ?>> getNbtValueProcessors(NbtDataType type) {
        return SpongeManipulatorRegistry.getInstance().getNbtValueProcessors(type);
    }

    public static DataRegistration<?, ?> getRegistrationFor(DataManipulator<?, ?> manipulator) {
        return SpongeManipulatorRegistry.getInstance().getRegistrationFor(manipulator);
    }

    private static DataRegistration<?, ?> getRegistrationFor(ImmutableDataManipulator<?, ?> immutableDataManipulator) {
        return SpongeManipulatorRegistry.getInstance().getRegistrationFor(immutableDataManipulator);
    }

    private static Optional<DataRegistration<?, ?>> getRegistrationFor(String id) {
        return SpongeManipulatorRegistry.getInstance().getRegistrationFor(id);
    }

    public static DataTransactionResult apply(NBTTagCompound compound, DataManipulator<?, ?> manipulator) {
        NBTTagCompound forgeCompound;
        if (!compound.func_150297_b("ForgeData", 10)) {
            compound.func_74782_a("ForgeData", (NBTBase)new NBTTagCompound());
        }
        if (!(forgeCompound = compound.func_74775_l("ForgeData")).func_150297_b("SpongeData", 10)) {
            forgeCompound.func_74782_a("SpongeData", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound spongeTag = forgeCompound.func_74775_l("SpongeData");
        DataRegistration<?, ?> registration = DataUtil.getRegistrationFor(manipulator);
        if (spongeTag.func_150297_b("CustomManipulators", 9)) {
            NBTTagList list = spongeTag.func_150295_c("CustomManipulators", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound dataCompound = list.func_150305_b(i);
                String dataId = dataCompound.func_74779_i("ManipulatorId");
                if (!dataId.equalsIgnoreCase(registration.getId())) continue;
                NBTTagCompound current = dataCompound.func_74775_l("ManipulatorData");
                DataContainer currentView = NbtTranslator.getInstance().translate(current);
                Optional<DataManipulator> existingManipulator = DataUtil.deserializeManipulator(dataId, currentView);
                DataContainer replacement = manipulator.toContainer();
                NBTTagCompound replacementCompound = NbtTranslator.getInstance().translateData(replacement);
                dataCompound.func_74782_a("ManipulatorData", (NBTBase)replacementCompound);
                return DataTransactionResult.successReplaceResult(manipulator.getValues(), existingManipulator.map(ValueContainer::getValues).orElseGet(ImmutableSet::of));
            }
        } else {
            NBTTagList list = new NBTTagList();
            NBTTagCompound newCompound = new NBTTagCompound();
            newCompound.func_74778_a("ManipulatorId", registration.getId());
            DataContainer dataContainer = manipulator.toContainer();
            NBTTagCompound dataCompound = NbtTranslator.getInstance().translateData(dataContainer);
            newCompound.func_74782_a("ManipulatorData", (NBTBase)dataCompound);
            list.func_74742_a((NBTBase)newCompound);
            spongeTag.func_74782_a("CustomManipulators", (NBTBase)list);
        }
        return DataTransactionResult.builder().result(DataTransactionResult.Type.SUCCESS).success(manipulator.getValues()).build();
    }

    public static DataTransactionResult remove(NBTTagCompound data, Class<? extends DataManipulator<?, ?>> containerClass) {
        if (!data.func_150297_b("ForgeData", 10)) {
            return DataTransactionResult.successNoData();
        }
        NBTTagCompound forgeTag = data.func_74775_l("ForgeData");
        if (!forgeTag.func_150297_b("SpongeData", 10)) {
            return DataTransactionResult.successNoData();
        }
        NBTTagCompound spongeData = forgeTag.func_74775_l("SpongeData");
        if (!spongeData.func_150297_b("CustomManipulators", 9)) {
            return DataTransactionResult.successNoData();
        }
        NBTTagList dataList = spongeData.func_150295_c("CustomManipulators", 10);
        if (dataList.func_74745_c() == 0) {
            return DataTransactionResult.successNoData();
        }
        DataRegistration registration = SpongeManipulatorRegistry.getInstance().getRegistrationFor(containerClass);
        for (int i = 0; i < dataList.func_74745_c(); ++i) {
            NBTTagCompound dataCompound = dataList.func_150305_b(i);
            String dataId = dataCompound.func_74779_i("ManipulatorId");
            if (!registration.getId().equalsIgnoreCase(dataId)) continue;
            NBTTagCompound current = dataCompound.func_74775_l("ManipulatorData");
            DataContainer currentView = NbtTranslator.getInstance().translate(current);
            Optional<DataManipulator> existing = DataUtil.deserializeManipulator(dataId, currentView);
            dataList.func_74744_a(i);
            return existing.map(ValueContainer::getValues).map(DataTransactionResult::successRemove).orElseGet(DataTransactionResult::successNoData);
        }
        return DataTransactionResult.successNoData();
    }

    public static void readCustomData(NBTTagCompound compound, DataHolder dataHolder) {
        if (dataHolder instanceof CustomDataHolderBridge) {
            ImmutableList<DataManipulator<?, ?>> manipulators;
            SerializedDataTransaction transaction;
            ImmutableList.Builder builder;
            NBTTagList list;
            if (compound.func_150297_b("CustomManipulators", 9)) {
                list = compound.func_150295_c("CustomManipulators", 10);
                builder = ImmutableList.builder();
                DataUtil.translateTagListToView((ImmutableList.Builder<? super DataView>)builder, list);
                try {
                    transaction = DataUtil.deserializeManipulatorList((List<? extends DataView>)builder.build());
                    manipulators = transaction.deserializedManipulators;
                    for (DataManipulator manipulator : manipulators) {
                        dataHolder.offer(manipulator);
                    }
                    if (!transaction.failedData.isEmpty()) {
                        ((CustomDataHolderBridge)((Object)dataHolder)).bridge$addFailedData(transaction.failedData);
                    }
                }
                catch (InvalidDataException e) {
                    SpongeImpl.getLogger().error("Could not translate custom plugin data! ", (Throwable)e);
                }
            }
            if (compound.func_150297_b("FailedData", 9)) {
                list = compound.func_150295_c("FailedData", 10);
                builder = ImmutableList.builder();
                DataUtil.translateTagListToView((ImmutableList.Builder<? super DataView>)builder, list);
                compound.func_82580_o("FailedData");
                transaction = DataUtil.deserializeManipulatorList((List<? extends DataView>)builder.build());
                manipulators = transaction.deserializedManipulators;
                ArrayList classesLoaded = new ArrayList();
                for (DataManipulator manipulator : manipulators) {
                    if (classesLoaded.contains(manipulator.getClass())) continue;
                    classesLoaded.add(manipulator.getClass());
                    if (((CustomDataHolderBridge)((Object)dataHolder)).bridge$getCustom(manipulator.getClass()).isPresent()) continue;
                    dataHolder.offer(manipulator);
                }
                if (!transaction.failedData.isEmpty()) {
                    ((CustomDataHolderBridge)((Object)dataHolder)).bridge$addFailedData(transaction.failedData);
                }
            }
        }
    }

    private static void translateTagListToView(ImmutableList.Builder<? super DataView> builder, NBTTagList list) {
        if (!list.func_82582_d()) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound internal = list.func_150305_b(i);
                builder.add((Object)NbtTranslator.getInstance().translateFrom(internal));
            }
        }
    }

    public static void writeCustomData(NBTTagCompound compound, DataHolder dataHolder) {
        if (dataHolder instanceof CustomDataHolderBridge) {
            List<DataView> failedData;
            Collection<DataManipulator<?, ?>> manipulators = ((CustomDataHolderBridge)((Object)dataHolder)).bridge$getCustomManipulators();
            if (!manipulators.isEmpty()) {
                List<DataView> manipulatorViews = DataUtil.getSerializedManipulatorList(manipulators);
                NBTTagList manipulatorTagList = new NBTTagList();
                for (DataView dataView : manipulatorViews) {
                    manipulatorTagList.func_74742_a((NBTBase)NbtTranslator.getInstance().translateData(dataView));
                }
                compound.func_74782_a("CustomManipulators", (NBTBase)manipulatorTagList);
            }
            if (!(failedData = ((CustomDataHolderBridge)((Object)dataHolder)).bridge$getFailedData()).isEmpty()) {
                NBTTagList failedList = new NBTTagList();
                for (DataView failedDatum : failedData) {
                    failedList.func_74742_a((NBTBase)NbtTranslator.getInstance().translateData(failedDatum));
                }
                compound.func_74782_a("FailedData", (NBTBase)failedList);
            }
        }
    }

    static {
        spongeDataFixer.func_188256_a((IFixType)FixTypes.LEVEL, (IFixableData)new SpongeLevelFixer());
        spongeDataFixer.func_188256_a((IFixType)FixTypes.ENTITY, (IFixableData)new EntityTrackedUser());
        spongeDataFixer.func_188256_a((IFixType)FixTypes.PLAYER, (IFixableData)new PlayerRespawnData());
    }
}

