/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockPistonStructureHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import net.minecraft.network.play.server.SPacketOpenWindow;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.Jukebox;
import org.spongepowered.api.block.tileentity.Note;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.data.type.InstrumentType;
import org.spongepowered.api.data.type.NotePitch;
import org.spongepowered.api.effect.sound.SoundCategories;
import org.spongepowered.api.effect.sound.SoundCategory;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.effect.sound.record.RecordType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.explosive.Explosive;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.entity.living.Human;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.projectile.source.ProjectileSource;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.CollideBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.NotifyNeighborBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.ChangeEntityEquipmentEvent;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.RotateEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.entity.TargetEntityEvent;
import org.spongepowered.api.event.entity.ai.SetAITargetEvent;
import org.spongepowered.api.event.entity.explosive.DetonateExplosiveEvent;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.event.item.inventory.CraftItemEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.event.item.inventory.EnchantItemEvent;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.event.item.inventory.UpdateAnvilEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.event.sound.PlaySoundEvent;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.crafting.CraftingOutput;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.OwnershipTrackedBridge;
import org.spongepowered.common.bridge.block.BlockBridge;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.entity.player.EntityPlayerBridge;
import org.spongepowered.common.bridge.entity.player.EntityPlayerMPBridge;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.inventory.ContainerBridge;
import org.spongepowered.common.bridge.inventory.TrackedInventoryBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.inventory.UpdateAnvilEventCost;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.item.enchantment.SpongeRandomEnchantmentListBuilder;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.custom.CustomInventory;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.InventoryUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;

public class SpongeCommonEventFactory {
    public static int lastAnimationPacketTick = 0;
    public static int lastSecondaryPacketTick = 0;
    public static int lastPrimaryPacketTick = 0;
    @Nullable
    public static WeakReference<EntityPlayerMP> lastAnimationPlayer;

    public static void callDropItemDispense(List<EntityItem> items, PhaseContext<?> context) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DISPENSE);
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (EntityItem item : items) {
                entities.add((Entity)item);
            }
            DropItemEvent.Dispense dispense = SpongeEventFactory.createDropItemEventDispense(frame.getCurrentCause(), entities);
            SpongeImpl.postEvent(dispense);
            if (!dispense.isCancelled()) {
                EntityUtil.processEntitySpawnsFromEvent(context, dispense);
            }
        }
    }

    public static void callDropItemDrop(EntityPlayerMP player, List<EntityItem> items, PhaseContext<?> context) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (EntityItem item : items) {
                entities.add((Entity)item);
            }
            Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.NONE, ItemStackSnapshot.NONE);
            ClickInventoryEvent.Drop.Outside.Creative dispense = SpongeEventFactory.createClickInventoryEventDropOutsideCreative(frame.getCurrentCause(), cursorTransaction, entities, Optional.empty(), (Container)player.field_71070_bA, Collections.emptyList());
            SpongeImpl.postEvent(dispense);
            if (!dispense.isCancelled()) {
                EntityUtil.processEntitySpawnsFromEvent(context, dispense);
            }
        }
    }

    public static void callDropItemCustom(List<Entity> items, PhaseContext<?> context) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(frame.getCurrentCause(), items);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                EntityUtil.processEntitySpawnsFromEvent(context, event);
            }
        }
    }

    public static void callDropItemCustom(List<Entity> items, PhaseContext<?> context, Supplier<Optional<User>> supplier) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.getCurrentContext().require(EventContextKeys.SPAWN_TYPE);
            DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(frame.getCurrentCause(), items);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                EntityUtil.processEntitySpawnsFromEvent(event, supplier);
            }
        }
    }

    public static void callDropItemClose(List<Entity> items, PhaseContext<?> context, Supplier<Optional<User>> supplier) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.getCurrentContext().require(EventContextKeys.SPAWN_TYPE);
            DropItemEvent.Close event = SpongeEventFactory.createDropItemEventClose(frame.getCurrentCause(), items);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                EntityUtil.processEntitySpawnsFromEvent(event, supplier);
            }
        }
    }

    public static boolean callSpawnEntitySpawner(List<Entity> entities, PhaseContext<?> context) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.WORLD_SPAWNER);
            SpawnEntityEvent.Spawner event = SpongeEventFactory.createSpawnEntityEventSpawner(frame.getCurrentCause(), entities);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled() && event.getEntities().size() > 0) {
                boolean bl = EntityUtil.processEntitySpawnsFromEvent(context, event);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static void callDropItemDestruct(List<Entity> entities, PhaseContext<?> context) {
        DropItemEvent.Destruct destruct = SpongeEventFactory.createDropItemEventDestruct(Sponge.getCauseStackManager().getCurrentCause(), entities);
        SpongeImpl.postEvent(destruct);
        if (!destruct.isCancelled()) {
            EntityUtil.processEntitySpawnsFromEvent(context, destruct);
        }
    }

    public static boolean callSpawnEntity(List<Entity> entities, PhaseContext<?> context) {
        Sponge.getCauseStackManager().getCurrentContext().require(EventContextKeys.SPAWN_TYPE);
        try {
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), entities);
            SpongeImpl.postEvent(event);
            return !event.isCancelled() && EntityUtil.processEntitySpawnsFromEvent(context, event);
        }
        catch (Exception e) {
            PrettyPrinter printer = new PrettyPrinter(60).add("Exception trying to create a Spawn Event").centre().hr().addWrapped("Something did not go well trying to create an event or while trying to throw a SpawnEntityEvent. My bet is it's gremlins", new Object[0]).add().add("At the very least here's some information about what's going to be directly spawned without an event:");
            printer.add("Entities:");
            for (Entity entity : entities) {
                printer.add(" - " + entity);
            }
            printer.add("PhaseContext:");
            context.printCustom(printer, 4);
            printer.add();
            printer.add("Exception:");
            printer.add(e);
            printer.log(SpongeImpl.getLogger(), Level.ERROR);
            for (Entity entity : entities) {
                EntityUtil.processEntitySpawn(entity, EntityUtil.ENTITY_CREATOR_FUNCTION.apply(context));
            }
            return true;
        }
    }

    public static boolean callSpawnEntityCustom(List<Entity> entities, PhaseContext<?> context) {
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
        SpongeImpl.postEvent(event);
        return event.isCancelled() && EntityUtil.processEntitySpawnsFromEvent(context, event);
    }

    public static boolean callPlayerChangeInventoryPickupPreEvent(EntityPlayer player, EntityItem itemToPickup, int pickupDelay) {
        net.minecraft.item.ItemStack stack = itemToPickup.func_92059_d();
        Sponge.getCauseStackManager().pushCause(player);
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
        ChangeInventoryEvent.Pickup.Pre event = SpongeEventFactory.createChangeInventoryEventPickupPre(Sponge.getCauseStackManager().getCurrentCause(), Optional.empty(), Collections.singletonList(snapshot), snapshot, (Item)itemToPickup, (Inventory)player.field_71071_by);
        SpongeImpl.postEvent(event);
        Sponge.getCauseStackManager().popCause();
        if (event.isCancelled()) {
            return false;
        }
        if (event.getCustom().isPresent()) {
            List<ItemStackSnapshot> list = event.getCustom().get();
            if (list.isEmpty()) {
                itemToPickup.func_92059_d().func_190920_e(0);
                return false;
            }
            boolean fullTransfer = true;
            TrackedInventoryBridge capture = (TrackedInventoryBridge)player.field_71071_by;
            capture.bridge$setCaptureInventory(true);
            for (ItemStackSnapshot item : list) {
                ItemStack itemStack = item.createStack();
                player.field_71071_by.func_70441_a(ItemStackUtil.toNative(itemStack));
                if (itemStack.isEmpty()) continue;
                fullTransfer = false;
                break;
            }
            capture.bridge$setCaptureInventory(false);
            if (!fullTransfer) {
                for (SlotTransaction trans : capture.bridge$getCapturedSlotTransactions()) {
                    trans.getSlot().set(((ItemStackSnapshot)trans.getOriginal()).createStack());
                }
                return false;
            }
            if (!SpongeCommonEventFactory.callPlayerChangeInventoryPickupEvent(player, capture)) {
                return false;
            }
            itemToPickup.func_92059_d().func_190920_e(0);
        }
        return true;
    }

    public static boolean callPlayerChangeInventoryPickupEvent(EntityPlayer player, TrackedInventoryBridge inventory) {
        if (inventory.bridge$getCapturedSlotTransactions().isEmpty()) {
            return true;
        }
        Sponge.getCauseStackManager().pushCause(player);
        ChangeInventoryEvent.Pickup event = SpongeEventFactory.createChangeInventoryEventPickup(Sponge.getCauseStackManager().getCurrentCause(), (Inventory)player.field_71069_bz, inventory.bridge$getCapturedSlotTransactions());
        SpongeImpl.postEvent(event);
        Sponge.getCauseStackManager().popCause();
        SpongeCommonEventFactory.applyTransactions(event);
        inventory.bridge$getCapturedSlotTransactions().clear();
        return !event.isCancelled();
    }

    public static net.minecraft.item.ItemStack callInventoryPickupEvent(IInventory inventory, EntityItem item, net.minecraft.item.ItemStack stack) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(inventory);
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
            ChangeInventoryEvent.Pickup.Pre event = SpongeEventFactory.createChangeInventoryEventPickupPre(frame.getCurrentCause(), Optional.empty(), Collections.singletonList(snapshot), snapshot, (Item)item, (Inventory)inventory);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                net.minecraft.item.ItemStack itemStack = stack;
                return itemStack;
            }
            int size = inventory.func_70302_i_();
            net.minecraft.item.ItemStack[] prevInventory = new net.minecraft.item.ItemStack[size];
            for (int i = 0; i < size; ++i) {
                prevInventory[i] = inventory.func_70301_a(i);
            }
            if (event.getCustom().isPresent()) {
                net.minecraft.item.ItemStack itemStack;
                if (event.getCustom().get().isEmpty()) {
                    net.minecraft.item.ItemStack i = net.minecraft.item.ItemStack.field_190927_a;
                    return i;
                }
                boolean fullTransfer = true;
                for (ItemStackSnapshot snap : event.getCustom().get()) {
                    net.minecraft.item.ItemStack stackToAdd = ItemStackUtil.fromSnapshotToNative(snap);
                    net.minecraft.item.ItemStack remaining = TileEntityHopper.func_174918_a(null, (IInventory)inventory, (net.minecraft.item.ItemStack)stackToAdd, null);
                    if (remaining.func_190926_b()) continue;
                    fullTransfer = false;
                    break;
                }
                if (!fullTransfer) {
                    for (int i = 0; i < prevInventory.length; ++i) {
                        inventory.func_70299_a(i, prevInventory[i]);
                    }
                    net.minecraft.item.ItemStack itemStack2 = stack;
                    return itemStack2;
                }
                if (SpongeCommonEventFactory.callInventoryPickupEvent(inventory, prevInventory)) {
                    itemStack = net.minecraft.item.ItemStack.field_190927_a;
                    return itemStack;
                }
                itemStack = stack;
                return itemStack;
            }
            net.minecraft.item.ItemStack remainder = TileEntityHopper.func_174918_a(null, (IInventory)inventory, (net.minecraft.item.ItemStack)stack, null);
            if (SpongeCommonEventFactory.callInventoryPickupEvent(inventory, prevInventory)) {
                net.minecraft.item.ItemStack itemStack = remainder;
                return itemStack;
            }
            net.minecraft.item.ItemStack itemStack = stack;
            return itemStack;
        }
    }

    private static List<SlotTransaction> generateTransactions(@Nullable Inventory inv, IInventory inventory, net.minecraft.item.ItemStack[] previous) {
        if (inv == null) {
            return Collections.emptyList();
        }
        ArrayList<SlotTransaction> trans = new ArrayList<SlotTransaction>();
        Iterator it = inv.slots().iterator();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            net.minecraft.item.ItemStack prevStack;
            org.spongepowered.api.item.inventory.Slot slot = (org.spongepowered.api.item.inventory.Slot)it.next();
            net.minecraft.item.ItemStack newStack = inventory.func_70301_a(i);
            if (net.minecraft.item.ItemStack.func_77989_b((net.minecraft.item.ItemStack)newStack, (net.minecraft.item.ItemStack)(prevStack = previous[i]))) continue;
            trans.add(new SlotTransaction(slot, ItemStackUtil.snapshotOf(prevStack), ItemStackUtil.snapshotOf(newStack)));
        }
        return trans;
    }

    public static boolean callInventoryPickupEvent(IInventory inventory, net.minecraft.item.ItemStack[] prevInventory) {
        Inventory spongeInventory = InventoryUtil.toInventory(inventory, null);
        List<SlotTransaction> trans = SpongeCommonEventFactory.generateTransactions(spongeInventory, inventory, prevInventory);
        if (trans.isEmpty()) {
            return true;
        }
        ChangeInventoryEvent.Pickup event = SpongeEventFactory.createChangeInventoryEventPickup(Sponge.getCauseStackManager().getCurrentCause(), spongeInventory, trans);
        SpongeImpl.postEvent(event);
        SpongeCommonEventFactory.applyTransactions(event);
        return !event.isCancelled();
    }

    private static void applyTransactions(ChangeInventoryEvent.Pickup event) {
        if (event.isCancelled()) {
            for (SlotTransaction trans : event.getTransactions()) {
                trans.getSlot().set(((ItemStackSnapshot)trans.getOriginal()).createStack());
            }
            return;
        }
        for (SlotTransaction trans : event.getTransactions()) {
            if (!trans.isValid()) {
                trans.getSlot().set(((ItemStackSnapshot)trans.getOriginal()).createStack());
                continue;
            }
            if (!trans.getCustom().isPresent()) continue;
            trans.getSlot().set(((ItemStackSnapshot)trans.getFinal()).createStack());
        }
    }

    @Nullable
    public static CollideEntityEvent callCollideEntityEvent(net.minecraft.world.World world, @Nullable net.minecraft.entity.Entity sourceEntity, List<net.minecraft.entity.Entity> entities) {
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        PhaseContext<?> currentContext = phaseTracker.getCurrentContext();
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            if (sourceEntity != null) {
                if (currentContext.getSource() != sourceEntity) {
                    frame.pushCause(sourceEntity);
                }
            } else {
                Object source = currentContext.getSource();
                if (source instanceof LocatableBlock) {
                    frame.pushCause(source);
                } else if (source instanceof TileEntity) {
                    frame.pushCause(source);
                } else if (source instanceof Entity) {
                    frame.pushCause(source);
                }
            }
            currentContext.addNotifierAndOwnerToCauseStack(frame);
            List<net.minecraft.entity.Entity> spEntities = entities;
            CollideEntityEvent event = SpongeEventFactory.createCollideEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), spEntities);
            SpongeImpl.postEvent(event);
            CollideEntityEvent collideEntityEvent = event;
            return collideEntityEvent;
        }
    }

    public static ChangeBlockEvent.Pre callChangeBlockEventPre(WorldServerBridge worldIn, BlockPos pos) {
        return SpongeCommonEventFactory.callChangeBlockEventPre(worldIn, (ImmutableList<Location<World>>)ImmutableList.of(new Location<World>((World)((Object)worldIn), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())), null);
    }

    public static ChangeBlockEvent.Pre callChangeBlockEventPre(WorldServerBridge worldIn, BlockPos pos, Object source) {
        return SpongeCommonEventFactory.callChangeBlockEventPre(worldIn, (ImmutableList<Location<World>>)ImmutableList.of(new Location<World>((World)((Object)worldIn), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())), source);
    }

    private static ChangeBlockEvent.Pre callChangeBlockEventPre(WorldServerBridge worldIn, ImmutableList<Location<World>> locations, @Nullable Object source) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            User owner;
            PhaseContext<?> phaseContext = PhaseTracker.getInstance().getCurrentContext();
            if (source == null) {
                source = phaseContext.getSource() == null ? worldIn : phaseContext.getSource();
            }
            EntityPlayer player = null;
            frame.pushCause(source);
            if (source instanceof Player && SpongeImplHooks.isFakePlayer((net.minecraft.entity.Entity)(player = (EntityPlayer)source))) {
                frame.addContext(EventContextKeys.FAKE_PLAYER, (Player)player);
            }
            if ((owner = phaseContext.getOwner().orElse((User)player)) != null) {
                frame.addContext(EventContextKeys.OWNER, owner);
            }
            if (!phaseContext.state.shouldProvideModifiers(phaseContext)) {
                phaseContext.getSource(BlockBridge.class).ifPresent(bridge -> bridge.bridge$getTickFrameModifier().accept(frame, worldIn));
            }
            phaseContext.applyNotifierIfAvailable(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            ChangeBlockEvent.Pre event = SpongeEventFactory.createChangeBlockEventPre(frame.getCurrentCause(), locations);
            SpongeImpl.postEvent(event);
            ChangeBlockEvent.Pre pre = event;
            return pre;
        }
    }

    public static ChangeBlockEvent.Modify callChangeBlockEventModifyLiquidMix(net.minecraft.world.World worldIn, BlockPos pos, IBlockState state, @Nullable Object source) {
        BlockState fromState = (BlockState)worldIn.func_180495_p(pos);
        BlockState toState = (BlockState)state;
        boolean pushSource = false;
        if (source == null) {
            pushSource = true;
            source = new SpongeLocatableBlockBuilder().state(fromState).world((World)worldIn).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).build();
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            if (!pushSource) {
                frame.pushCause(source);
            }
            frame.addContext(EventContextKeys.LIQUID_MIX, (World)worldIn);
            WorldProperties world = ((World)worldIn).getProperties();
            Vector3i position = new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            Transaction transaction = new Transaction(BlockSnapshot.builder().blockState(fromState).world(world).position(position).build(), BlockSnapshot.builder().blockState(toState).world(world).position(position).build());
            ChangeBlockEvent.Modify event = SpongeEventFactory.createChangeBlockEventModify(frame.getCurrentCause(), Collections.singletonList(transaction));
            SpongeImpl.postEvent(event);
            ChangeBlockEvent.Modify modify = event;
            return modify;
        }
    }

    public static ChangeBlockEvent.Break callChangeBlockEventModifyLiquidBreak(net.minecraft.world.World worldIn, BlockPos pos, IBlockState targetState) {
        return SpongeCommonEventFactory.callChangeBlockEventModifyLiquidBreak(worldIn, pos, worldIn.func_180495_p(pos), targetState);
    }

    public static ChangeBlockEvent.Break callChangeBlockEventModifyLiquidBreak(net.minecraft.world.World worldIn, BlockPos pos, IBlockState fromState, IBlockState toState) {
        PhaseContext<?> context = PhaseTracker.getInstance().getCurrentContext();
        net.minecraft.world.World source = context.getSource(LocatableBlock.class).orElse(null);
        if (source == null) {
            source = worldIn;
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(source);
            frame.addContext(EventContextKeys.LIQUID_BREAK, (World)worldIn);
            WorldProperties world = ((World)worldIn).getProperties();
            Vector3i position = new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            SpongeBlockSnapshot from = SpongeBlockSnapshotBuilder.pooled().blockState(fromState).world(world).position(position).build();
            SpongeBlockSnapshot to = SpongeBlockSnapshotBuilder.pooled().blockState(toState).world(world).position(position).build();
            Transaction<SpongeBlockSnapshot> transaction = new Transaction<SpongeBlockSnapshot>(from, to);
            ChangeBlockEvent.Break event = SpongeEventFactory.createChangeBlockEventBreak(frame.getCurrentCause(), Collections.singletonList(transaction));
            SpongeImpl.postEvent(event);
            ChangeBlockEvent.Break break_ = event;
            return break_;
        }
    }

    public static boolean handlePistonEvent(WorldServerBridge world, WorldServer.ServerBlockEventList list, Object obj, BlockPos pos, Block blockIn, int eventId, int eventParam) {
        boolean extending = eventId == 0;
        IBlockState blockstate = ((net.minecraft.world.World)world).func_180495_p(pos);
        EnumFacing direction = (EnumFacing)blockstate.func_177229_b((IProperty)BlockDirectional.field_176387_N);
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((World)((Object)world)).state((BlockState)blockstate).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).build();
        HashSet<Location<World>> locations = new HashSet<Location<World>>();
        locations.add(new Location<World>((World)((Object)world), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        BlockPistonStructureHelper movedBlocks = new BlockPistonStructureHelper((net.minecraft.world.World)((WorldServer)world), pos, direction, extending);
        movedBlocks.func_177253_a();
        Stream.concat(movedBlocks.func_177254_c().stream(), movedBlocks.func_177252_d().stream()).map(block -> new Location<World>((World)((Object)world), block.func_177958_n(), block.func_177956_o(), block.func_177952_p())).collect(Collectors.toCollection(() -> locations));
        if (extending && movedBlocks.func_177252_d().isEmpty()) {
            List movedPositions = movedBlocks.func_177254_c();
            BlockPos offsetPos = movedPositions.isEmpty() ? pos.func_177972_a(direction) : ((BlockPos)movedPositions.get(movedPositions.size() - 1)).func_177972_a(direction);
            locations.add(new Location<World>((World)((Object)world), offsetPos.func_177958_n(), offsetPos.func_177956_o(), offsetPos.func_177952_p()));
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            if (extending) {
                frame.addContext(EventContextKeys.PISTON_EXTEND, (World)((Object)world));
            } else {
                frame.addContext(EventContextKeys.PISTON_RETRACT, (World)((Object)world));
            }
            boolean bl = SpongeCommonEventFactory.callChangeBlockEventPre(world, (ImmutableList<Location<World>>)ImmutableList.copyOf(locations), (Object)locatable).isCancelled();
            return bl;
        }
    }

    @Nullable
    public static NotifyNeighborBlockEvent callNotifyNeighborEvent(World world, BlockPos sourcePos, EnumSet<EnumFacing> notifiedSides) {
        PhaseContext<?> context = PhaseTracker.getInstance().getCurrentContext();
        if (context.state.isWorldGeneration() || context.state.isRestoring()) {
            return null;
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            BlockState blockstate = (BlockState)((net.minecraft.world.World)world).func_180495_p(sourcePos);
            LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(world).position(sourcePos.func_177958_n(), sourcePos.func_177956_o(), sourcePos.func_177952_p()).state(blockstate).build();
            if (context.getNotifier().isPresent()) {
                context.addNotifierAndOwnerToCauseStack(frame);
            } else {
                ChunkBridge mixinChunk = (ChunkBridge)((WorldServer)world).func_175726_f(sourcePos);
                mixinChunk.bridge$getBlockNotifier(sourcePos).ifPresent(user -> frame.addContext(EventContextKeys.NOTIFIER, user));
                mixinChunk.bridge$getBlockOwner(sourcePos).ifPresent(owner -> frame.addContext(EventContextKeys.OWNER, owner));
            }
            Sponge.getCauseStackManager().pushCause(locatable);
            HashMap<Direction, BlockState> neighbors = new HashMap<Direction, BlockState>();
            for (EnumFacing notificationSide : notifiedSides) {
                BlockPos offset = sourcePos.func_177972_a(notificationSide);
                Direction direction = DirectionFacingProvider.getInstance().getKey(notificationSide).get();
                IBlockState notificationState = ((WorldServer)world).func_180495_p(offset);
                neighbors.put(direction, (BlockState)notificationState);
            }
            NotifyNeighborBlockEvent event = SpongeEventFactory.createNotifyNeighborBlockEvent(Sponge.getCauseStackManager().getCurrentCause(), neighbors, neighbors);
            SpongeImpl.postEvent(event);
            NotifyNeighborBlockEvent notifyNeighborBlockEvent = event;
            return notifyNeighborBlockEvent;
        }
    }

    public static InteractEntityEvent.Primary callInteractEntityEventPrimary(EntityPlayerMP player, net.minecraft.item.ItemStack stack, net.minecraft.entity.Entity entity, EnumHand hand, @Nullable Vector3d hitVec) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            frame.addContext(EventContextKeys.OWNER, (User)player);
            frame.addContext(EventContextKeys.NOTIFIER, (User)player);
            frame.addContext(EventContextKeys.ENTITY_HIT, (Entity)entity);
            if (!stack.func_190926_b()) {
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(stack));
            }
            InteractEntityEvent.Primary event = hand == EnumHand.MAIN_HAND ? SpongeEventFactory.createInteractEntityEventPrimaryMainHand(frame.getCurrentCause(), HandTypes.MAIN_HAND, Optional.ofNullable(hitVec), (Entity)entity) : SpongeEventFactory.createInteractEntityEventPrimaryOffHand(frame.getCurrentCause(), HandTypes.OFF_HAND, Optional.ofNullable(hitVec), (Entity)entity);
            if (entity instanceof Player && !((World)player.field_70170_p).getProperties().isPVPEnabled()) {
                event.setCancelled(true);
            }
            SpongeImpl.postEvent(event);
            InteractEntityEvent.Primary primary = event;
            return primary;
        }
    }

    public static InteractEntityEvent.Secondary callInteractEntityEventSecondary(EntityPlayerMP player, net.minecraft.item.ItemStack stack, net.minecraft.entity.Entity entity, EnumHand hand, @Nullable Vector3d hitVec) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            frame.addContext(EventContextKeys.OWNER, (User)player);
            frame.addContext(EventContextKeys.NOTIFIER, (User)player);
            frame.addContext(EventContextKeys.ENTITY_HIT, (Entity)entity);
            if (!stack.func_190926_b()) {
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(stack));
            }
            InteractEntityEvent.Secondary event = hand == EnumHand.MAIN_HAND ? SpongeEventFactory.createInteractEntityEventSecondaryMainHand(frame.getCurrentCause(), HandTypes.MAIN_HAND, Optional.ofNullable(hitVec), (Entity)entity) : SpongeEventFactory.createInteractEntityEventSecondaryOffHand(frame.getCurrentCause(), HandTypes.OFF_HAND, Optional.ofNullable(hitVec), (Entity)entity);
            SpongeImpl.postEvent(event);
            InteractEntityEvent.Secondary secondary = event;
            return secondary;
        }
    }

    public static InteractItemEvent.Primary callInteractItemEventPrimary(EntityPlayer player, net.minecraft.item.ItemStack stack, EnumHand hand, @Nullable Vector3d hitVec, Object hitTarget) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            if (SpongeImplHooks.isFakePlayer((net.minecraft.entity.Entity)player)) {
                frame.addContext(EventContextKeys.FAKE_PLAYER, (Player)player);
            } else {
                frame.pushCause(player);
                frame.addContext(EventContextKeys.OWNER, (User)player);
                frame.addContext(EventContextKeys.NOTIFIER, (User)player);
            }
            if (hitTarget instanceof Entity) {
                frame.addContext(EventContextKeys.ENTITY_HIT, (Entity)hitTarget);
            } else if (hitTarget instanceof BlockSnapshot) {
                frame.addContext(EventContextKeys.BLOCK_HIT, (BlockSnapshot)hitTarget);
            }
            if (!stack.func_190926_b()) {
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(stack));
            }
            HandType handType = (HandType)hand;
            frame.addContext(EventContextKeys.USED_HAND, handType);
            InteractItemEvent.Primary event = hand == EnumHand.MAIN_HAND ? SpongeEventFactory.createInteractItemEventPrimaryMainHand(frame.getCurrentCause(), HandTypes.MAIN_HAND, Optional.ofNullable(hitVec), ItemStackUtil.snapshotOf(stack)) : SpongeEventFactory.createInteractItemEventPrimaryOffHand(frame.getCurrentCause(), HandTypes.OFF_HAND, Optional.ofNullable(hitVec), ItemStackUtil.snapshotOf(stack));
            SpongeImpl.postEvent(event);
            InteractItemEvent.Primary primary = event;
            return primary;
        }
    }

    public static InteractItemEvent.Secondary callInteractItemEventSecondary(CauseStackManager.StackFrame frame, EntityPlayer player, net.minecraft.item.ItemStack stack, EnumHand hand, @Nullable Vector3d hitVec, Object hitTarget) {
        if (SpongeImplHooks.isFakePlayer((net.minecraft.entity.Entity)player)) {
            frame.addContext(EventContextKeys.FAKE_PLAYER, (Player)player);
        } else {
            frame.pushCause(player);
            frame.addContext(EventContextKeys.OWNER, (User)player);
            frame.addContext(EventContextKeys.NOTIFIER, (User)player);
        }
        if (hitTarget instanceof Entity) {
            frame.addContext(EventContextKeys.ENTITY_HIT, (Entity)hitTarget);
        } else if (hitTarget instanceof BlockSnapshot) {
            frame.addContext(EventContextKeys.BLOCK_HIT, (BlockSnapshot)hitTarget);
        }
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(stack);
        if (!stack.func_190926_b()) {
            frame.addContext(EventContextKeys.USED_ITEM, snapshot);
        }
        HandType handType = (HandType)hand;
        frame.addContext(EventContextKeys.USED_HAND, handType);
        InteractItemEvent.Secondary event = hand == EnumHand.MAIN_HAND ? SpongeEventFactory.createInteractItemEventSecondaryMainHand(frame.getCurrentCause(), HandTypes.MAIN_HAND, Optional.ofNullable(hitVec), snapshot) : SpongeEventFactory.createInteractItemEventSecondaryOffHand(frame.getCurrentCause(), HandTypes.OFF_HAND, Optional.ofNullable(hitVec), snapshot);
        SpongeImpl.postEvent(event);
        return event;
    }

    public static InteractBlockEvent.Primary callInteractBlockEventPrimary(EntityPlayer player, net.minecraft.item.ItemStack heldItem, EnumHand hand, @Nullable Vector3d hitVec) {
        return SpongeCommonEventFactory.callInteractBlockEventPrimary(player, heldItem, BlockSnapshot.NONE, hand, null, hitVec);
    }

    public static InteractBlockEvent.Primary callInteractBlockEventPrimary(EntityPlayer player, net.minecraft.item.ItemStack heldItem, BlockSnapshot blockSnapshot, EnumHand hand, @Nullable EnumFacing side, @Nullable Vector3d hitVec) {
        HandType handType = (HandType)hand;
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            if (SpongeImplHooks.isFakePlayer((net.minecraft.entity.Entity)player)) {
                frame.addContext(EventContextKeys.FAKE_PLAYER, (Player)player);
            } else {
                frame.pushCause(player);
                frame.addContext(EventContextKeys.OWNER, (User)player);
                frame.addContext(EventContextKeys.NOTIFIER, (User)player);
            }
            frame.addContext(EventContextKeys.BLOCK_HIT, blockSnapshot);
            frame.addContext(EventContextKeys.USED_HAND, handType);
            Direction direction = side != null ? DirectionFacingProvider.getInstance().getKey(side).get() : Direction.NONE;
            if (!heldItem.func_190926_b()) {
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(heldItem));
            }
            InteractBlockEvent.Primary event = hand == EnumHand.MAIN_HAND ? SpongeEventFactory.createInteractBlockEventPrimaryMainHand(frame.getCurrentCause(), handType, Optional.ofNullable(hitVec), blockSnapshot, direction) : SpongeEventFactory.createInteractBlockEventPrimaryOffHand(frame.getCurrentCause(), handType, Optional.ofNullable(hitVec), blockSnapshot, direction);
            SpongeImpl.postEvent(event);
            InteractBlockEvent.Primary primary = event;
            return primary;
        }
    }

    public static InteractBlockEvent.Secondary createInteractBlockEventSecondary(EntityPlayer player, net.minecraft.item.ItemStack heldItem, @Nullable Vector3d hitVec, BlockSnapshot targetBlock, Direction targetSide, EnumHand hand) {
        return SpongeCommonEventFactory.createInteractBlockEventSecondary(player, heldItem, Tristate.UNDEFINED, Tristate.UNDEFINED, Tristate.UNDEFINED, Tristate.UNDEFINED, hitVec, targetBlock, targetSide, hand);
    }

    public static InteractBlockEvent.Secondary createInteractBlockEventSecondary(EntityPlayer player, net.minecraft.item.ItemStack heldItem, Tristate originalUseBlockResult, Tristate useBlockResult, Tristate originalUseItemResult, Tristate useItemResult, @Nullable Vector3d hitVec, BlockSnapshot targetBlock, Direction targetSide, EnumHand hand) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            if (SpongeImplHooks.isFakePlayer((net.minecraft.entity.Entity)player)) {
                frame.addContext(EventContextKeys.FAKE_PLAYER, (Player)player);
            } else {
                frame.pushCause(player);
                frame.addContext(EventContextKeys.OWNER, (User)player);
                frame.addContext(EventContextKeys.NOTIFIER, (User)player);
            }
            frame.addContext(EventContextKeys.BLOCK_HIT, targetBlock);
            if (!heldItem.func_190926_b()) {
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(heldItem));
            }
            HandType handType = (HandType)hand;
            frame.addContext(EventContextKeys.USED_HAND, handType);
            InteractBlockEvent.Secondary event = hand == EnumHand.MAIN_HAND ? SpongeEventFactory.createInteractBlockEventSecondaryMainHand(frame.getCurrentCause(), originalUseBlockResult, useBlockResult, originalUseItemResult, useItemResult, HandTypes.MAIN_HAND, Optional.ofNullable(hitVec), targetBlock, targetSide) : SpongeEventFactory.createInteractBlockEventSecondaryOffHand(frame.getCurrentCause(), originalUseBlockResult, useBlockResult, originalUseItemResult, useItemResult, HandTypes.OFF_HAND, Optional.ofNullable(hitVec), targetBlock, targetSide);
            InteractBlockEvent.Secondary secondary = event;
            return secondary;
        }
    }

    @Nullable
    public static Event callMoveEntityEvent(net.minecraft.entity.Entity entity, EntityTickContext context) {
        if (entity.field_70128_L || entity instanceof IProjectile || entity instanceof EntityItem) {
            return null;
        }
        Entity spongeEntity = (Entity)entity;
        double deltaX = context.prevX - entity.field_70165_t;
        double deltaY = context.prevY - entity.field_70163_u;
        double deltaZ = context.prevZ - entity.field_70161_v;
        double deltaChange = Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0) + Math.pow(deltaZ, 2.0);
        if (deltaChange > 0.00390625 || entity.field_70125_A != entity.field_70127_C || entity.field_70177_z != entity.field_70126_B) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(entity);
                double currentPosX = entity.field_70165_t;
                double currentPosY = entity.field_70163_u;
                double currentPosZ = entity.field_70161_v;
                Vector3d oldPositionVector = new Vector3d(context.prevX, context.prevY, context.prevZ);
                Vector3d currentPositionVector = new Vector3d(currentPosX, currentPosY, currentPosZ);
                Vector3d oldRotationVector = new Vector3d(entity.field_70127_C, entity.field_70126_B, 0.0f);
                Vector3d currentRotationVector = new Vector3d(entity.field_70125_A, entity.field_70177_z, 0.0f);
                World world = spongeEntity.getWorld();
                Transform<World> oldTransform = new Transform<World>(world, oldPositionVector, oldRotationVector, spongeEntity.getScale());
                Transform<World> newTransform = new Transform<World>(world, currentPositionVector, currentRotationVector, spongeEntity.getScale());
                TargetEntityEvent event = null;
                Transform<World> eventToTransform = null;
                if (!oldPositionVector.equals(currentPositionVector)) {
                    event = SpongeEventFactory.createMoveEntityEventPosition(frame.getCurrentCause(), oldTransform, newTransform, spongeEntity);
                    eventToTransform = ((MoveEntityEvent)event).getToTransform();
                } else {
                    event = SpongeEventFactory.createRotateEntityEvent(frame.getCurrentCause(), oldTransform, newTransform, spongeEntity);
                    eventToTransform = ((RotateEntityEvent)event).getToTransform();
                }
                if (SpongeImpl.postEvent(event)) {
                    entity.field_70165_t = context.prevX;
                    entity.field_70163_u = context.prevY;
                    entity.field_70161_v = context.prevZ;
                    entity.field_70125_A = entity.field_70127_C;
                    entity.field_70177_z = entity.field_70126_B;
                } else {
                    Vector3d newPosition = eventToTransform.getPosition();
                    if (!newPosition.equals(currentPositionVector)) {
                        entity.field_70165_t = newPosition.getX();
                        entity.field_70163_u = newPosition.getY();
                        entity.field_70161_v = newPosition.getZ();
                    }
                    if (!eventToTransform.getRotation().equals(currentRotationVector)) {
                        entity.field_70125_A = (float)currentRotationVector.getX();
                        entity.field_70177_z = (float)currentRotationVector.getY();
                    }
                }
                TargetEntityEvent targetEntityEvent = event;
                return targetEntityEvent;
            }
        }
        return null;
    }

    public static Optional<DestructEntityEvent.Death> callDestructEntityEventDeath(EntityLivingBase entity, @Nullable DamageSource source, boolean isMainThread) {
        OwnershipTrackedBridge ownerBridge;
        EntityDamageSource damageSource;
        MessageChannel originalChannel;
        MessageChannel channel;
        MessageEvent.MessageFormatter formatter = new MessageEvent.MessageFormatter();
        Optional<Object> sourceCreator = Optional.empty();
        boolean messageCancelled = false;
        if (entity instanceof EntityPlayerMP) {
            originalChannel = channel = ((EntityPlayerMPBridge)entity).bridge$getDeathMessageChannel();
        } else {
            originalChannel = MessageChannel.TO_NONE;
            channel = MessageChannel.TO_NONE;
        }
        if (source instanceof EntityDamageSource && (damageSource = (EntityDamageSource)source).func_76364_f() instanceof OwnershipTrackedBridge && (ownerBridge = (OwnershipTrackedBridge)damageSource.func_76364_f()) != null) {
            sourceCreator = ownerBridge.tracked$getOwnerReference();
        }
        Text originalMessage = SpongeTexts.toText(entity.func_110142_aN().func_151521_b());
        formatter.getBody().add(new MessageEvent.DefaultBodyApplier(originalMessage));
        try (CauseStackManager.StackFrame frame = isMainThread ? Sponge.getCauseStackManager().pushCauseFrame() : null;){
            if (isMainThread) {
                if (source != null) {
                    frame.pushCause(source);
                }
                if (sourceCreator.isPresent()) {
                    frame.addContext(EventContextKeys.OWNER, sourceCreator.get());
                }
            }
            Cause cause = isMainThread ? Sponge.getCauseStackManager().getCurrentCause() : Cause.of(EventContext.empty(), source == null ? entity : source);
            DestructEntityEvent.Death event = SpongeEventFactory.createDestructEntityEventDeath(cause, originalChannel, Optional.of(channel), formatter, (Living)entity, entity.field_70170_p.func_82736_K().func_82766_b("keepInventory"), false);
            SpongeImpl.postEvent(event, true);
            Text message = event.getMessage();
            if (!(event.isCancelled() || event.isMessageCancelled() || message.isEmpty())) {
                event.getChannel().ifPresent(eventChannel -> eventChannel.send(entity, event.getMessage()));
            }
            Optional<DestructEntityEvent.Death> optional = Optional.of(event);
            return optional;
        }
    }

    public static boolean handleCollideBlockEvent(Block block, net.minecraft.world.World world, BlockPos pos, IBlockState state, net.minecraft.entity.Entity entity, Direction direction) {
        if (pos.func_177956_o() <= 0) {
            return false;
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            EntityBridge spongeEntity;
            CollideBlockEvent event;
            boolean cancelled;
            frame.pushCause(entity);
            if (entity instanceof OwnershipTrackedBridge) {
                OwnershipTrackedBridge spongeEntity2 = (OwnershipTrackedBridge)entity;
                spongeEntity2.tracked$getOwnerReference().ifPresent(user -> frame.addContext(EventContextKeys.OWNER, user));
            }
            if (!(cancelled = SpongeImpl.postEvent(event = SpongeEventFactory.createCollideBlockEvent(frame.getCurrentCause(), (BlockState)state, new Location<World>((World)world, VecHelper.toVector3d(pos)), direction))) && !pos.equals((Object)(spongeEntity = (EntityBridge)entity).bridge$getLastCollidedBlockPos())) {
                PhaseContext<?> context = PhaseTracker.getInstance().getCurrentContext();
                context.applyNotifierIfAvailable(notifier -> {
                    ChunkBridge spongeChunk = ((ActiveChunkReferantBridge)entity).bridge$getActiveChunk();
                    if (spongeChunk == null) {
                        spongeChunk = (ChunkBridge)world.func_175726_f(pos);
                    }
                    spongeChunk.bridge$addTrackedBlockPosition(block, pos, (User)notifier, PlayerTracker.Type.NOTIFIER);
                });
            }
            boolean bl = cancelled;
            return bl;
        }
    }

    public static boolean handleCollideImpactEvent(net.minecraft.entity.Entity projectile, @Nullable ProjectileSource projectileSource, RayTraceResult movingObjectPosition) {
        RayTraceResult.Type movingObjectType = movingObjectPosition.field_72313_a;
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(projectile);
            frame.addContext(EventContextKeys.PROJECTILE_SOURCE, projectileSource == null ? ProjectileSource.UNKNOWN : projectileSource);
            Optional<User> owner = PhaseTracker.getInstance().getCurrentContext().getOwner();
            owner.ifPresent(user -> frame.addContext(EventContextKeys.OWNER, user));
            Location<World> impactPoint = new Location<World>((World)projectile.field_70170_p, VecHelper.toVector3d(movingObjectPosition.field_72307_f));
            boolean cancelled = false;
            if (movingObjectType == RayTraceResult.Type.BLOCK) {
                CollideBlockEvent.Impact event;
                BlockPos blockPos = movingObjectPosition.func_178782_a();
                if (blockPos.func_177956_o() <= 0) {
                    boolean bl = false;
                    return bl;
                }
                BlockSnapshot targetBlock = ((World)projectile.field_70170_p).createSnapshot(VecHelper.toVector3i(movingObjectPosition.func_178782_a()));
                Direction side = Direction.NONE;
                if (movingObjectPosition.field_178784_b != null) {
                    side = DirectionFacingProvider.getInstance().getKey(movingObjectPosition.field_178784_b).get();
                }
                if (!(cancelled = SpongeImpl.postEvent(event = SpongeEventFactory.createCollideBlockEventImpact(frame.getCurrentCause(), impactPoint, targetBlock.getState(), targetBlock.getLocation().get(), side))) && owner.isPresent()) {
                    BlockPos targetPos = VecHelper.toBlockPos(impactPoint.getBlockPosition());
                    ChunkBridge spongeChunk = (ChunkBridge)projectile.field_70170_p.func_175726_f(targetPos);
                    spongeChunk.bridge$addTrackedBlockPosition((Block)targetBlock.getState().getType(), targetPos, owner.get(), PlayerTracker.Type.NOTIFIER);
                }
            } else if (movingObjectPosition.field_72308_g != null) {
                ArrayList<Entity> entityList = new ArrayList<Entity>();
                entityList.add((Entity)movingObjectPosition.field_72308_g);
                CollideEntityEvent.Impact event = SpongeEventFactory.createCollideEntityEventImpact(frame.getCurrentCause(), entityList, impactPoint);
                cancelled = SpongeImpl.postEvent(event);
            }
            if (cancelled) {
                projectile.func_70106_y();
            }
            boolean bl = cancelled;
            return bl;
        }
    }

    public static ClickInventoryEvent.Creative callCreativeClickInventoryEvent(EntityPlayerMP player, CPacketCreativeInventoryAction packetIn) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.NONE, ItemStackSnapshot.NONE);
            org.spongepowered.api.item.inventory.Slot slot = null;
            if (((TrackedInventoryBridge)player.field_71070_bA).bridge$getCapturedSlotTransactions().isEmpty() && packetIn.func_149627_c() >= 0 && packetIn.func_149627_c() < player.field_71070_bA.field_75151_b.size() && (slot = ((ContainerBridge)player.field_71070_bA).bridge$getContainerSlot(packetIn.func_149627_c())) != null) {
                ItemStackSnapshot clickedItem = ItemStackUtil.snapshotOf(slot.peek().orElse(ItemStack.empty()));
                ItemStackSnapshot replacement = ItemStackUtil.snapshotOf(packetIn.func_149625_d());
                SlotTransaction slotTransaction = new SlotTransaction(slot, clickedItem, replacement);
                ((TrackedInventoryBridge)player.field_71070_bA).bridge$getCapturedSlotTransactions().add(slotTransaction);
            }
            ClickInventoryEvent.Creative event = SpongeEventFactory.createClickInventoryEventCreative(frame.getCurrentCause(), cursorTransaction, Optional.ofNullable(slot), (Container)player.field_71070_bA, new ArrayList<SlotTransaction>(((TrackedInventoryBridge)player.field_71070_bA).bridge$getCapturedSlotTransactions()));
            ((TrackedInventoryBridge)player.field_71070_bA).bridge$getCapturedSlotTransactions().clear();
            ((TrackedInventoryBridge)player.field_71070_bA).bridge$setCaptureInventory(false);
            SpongeImpl.postEvent(event);
            frame.popCause();
            ClickInventoryEvent.Creative creative = event;
            return creative;
        }
    }

    public static boolean callInteractInventoryOpenEvent(EntityPlayerMP player) {
        ItemStackSnapshot newCursor = player.field_71071_by.func_70445_o().func_190926_b() ? ItemStackSnapshot.NONE : ((ItemStack)player.field_71071_by.func_70445_o()).createSnapshot();
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.NONE, newCursor);
        InteractInventoryEvent.Open event = SpongeEventFactory.createInteractInventoryEventOpen(Sponge.getCauseStackManager().getCurrentCause(), cursorTransaction, (Container)player.field_71070_bA);
        SpongeImpl.postEvent(event);
        if (event.isCancelled()) {
            player.func_71053_j();
            return false;
        }
        if (event.getCursorTransaction().getCustom().isPresent()) {
            PacketPhaseUtil.handleCustomCursor((EntityPlayer)player, event.getCursorTransaction().getFinal());
        }
        return true;
    }

    public static InteractInventoryEvent.Close callInteractInventoryCloseEvent(net.minecraft.inventory.Container container, EntityPlayerMP player, ItemStackSnapshot lastCursor, ItemStackSnapshot newCursor, boolean clientSource) {
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(lastCursor, newCursor);
        InteractInventoryEvent.Close event = SpongeEventFactory.createInteractInventoryEventClose(Sponge.getCauseStackManager().getCurrentCause(), cursorTransaction, ContainerUtil.fromNative(container));
        SpongeImpl.postEvent(event);
        if (event.isCancelled()) {
            if (clientSource && container.func_75139_a(0) != null && !(container instanceof ContainerPlayer)) {
                player.field_71070_bA = container;
                Slot slot = container.func_75139_a(0);
                IInventory slotInventory = slot.field_75224_c;
                String guiId = slotInventory instanceof IInteractionObject ? ((IInteractionObject)slotInventory).func_174875_k() : "minecraft:container";
                slotInventory.func_174889_b((EntityPlayer)player);
                player.field_71135_a.func_147359_a((Packet)new SPacketOpenWindow(container.field_75152_c, guiId, slotInventory.func_145748_c_(), slotInventory.func_70302_i_()));
                player.func_71120_a(container);
            }
            if (!event.getCursorTransaction().isValid()) {
                PacketPhaseUtil.handleCustomCursor((EntityPlayer)player, event.getCursorTransaction().getOriginal());
            }
        } else {
            TrackedInventoryBridge mixinContainer = (TrackedInventoryBridge)player.field_71070_bA;
            mixinContainer.bridge$getCapturedSlotTransactions().clear();
            mixinContainer.bridge$setCaptureInventory(false);
            if (!event.getCursorTransaction().isValid()) {
                PacketPhaseUtil.handleCustomCursor((EntityPlayer)player, event.getCursorTransaction().getOriginal());
            } else if (event.getCursorTransaction().getCustom().isPresent()) {
                PacketPhaseUtil.handleCustomCursor((EntityPlayer)player, event.getCursorTransaction().getFinal());
            }
            if (!clientSource && player.field_71070_bA != null && player.field_71135_a != null) {
                player.func_71053_j();
            }
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static net.minecraft.inventory.Container displayContainer(EntityPlayerMP player, Inventory inventory, Text displayName) {
        net.minecraft.inventory.Container previousContainer;
        block26: {
            previousContainer = player.field_71070_bA;
            if (inventory instanceof CustomInventory && !SpongeCommonEventFactory.checkValidVanillaCustomInventory((CustomInventory)((Object)inventory))) {
                return null;
            }
            try {
                if (displayName != null) {
                    ((EntityPlayerMPBridge)player).bridge$setContainerDisplay(displayName);
                }
                if (inventory instanceof IInteractionObject) {
                    String guiId;
                    switch (guiId = ((IInteractionObject)inventory).func_174875_k()) {
                        case "EntityHorse": {
                            CarriedInventory cinventory;
                            if (inventory instanceof CarriedInventory && (cinventory = (CarriedInventory)inventory).getCarrier().isPresent() && cinventory.getCarrier().get() instanceof AbstractHorse) {
                                player.func_184826_a((AbstractHorse)cinventory.getCarrier().get(), (IInventory)inventory);
                                break;
                            }
                            break block26;
                        }
                        case "minecraft:chest": {
                            player.func_71007_a((IInventory)inventory);
                            break;
                        }
                        case "minecraft:crafting_table": 
                        case "minecraft:anvil": 
                        case "minecraft:enchanting_table": {
                            player.func_180468_a((IInteractionObject)inventory);
                            break;
                        }
                        default: {
                            player.func_71007_a((IInventory)inventory);
                        }
                    }
                    break block26;
                }
                if (inventory instanceof IInventory) {
                    player.func_71007_a((IInventory)inventory);
                    break block26;
                }
                net.minecraft.inventory.Container container = null;
                return container;
            }
            finally {
                if (displayName != null) {
                    ((EntityPlayerMPBridge)player).bridge$setContainerDisplay(null);
                }
            }
        }
        net.minecraft.inventory.Container container = player.field_71070_bA;
        if (previousContainer == container) {
            return null;
        }
        if (inventory instanceof CustomInventory) {
            ((CustomInventory)((Object)inventory)).ensureListenersRegistered();
        }
        if (!SpongeCommonEventFactory.callInteractInventoryOpenEvent(player)) {
            return null;
        }
        if (container instanceof ContainerBridge) {
            ((ContainerBridge)container).bridge$setCanInteractWith(p -> !p.field_70128_L);
        }
        if (inventory instanceof CustomInventory) {
            ((CustomInventory)((Object)inventory)).ensureListenersRegistered();
        }
        return container;
    }

    private static boolean checkValidVanillaCustomInventory(CustomInventory inventory) {
        InventoryArchetype archetype = inventory.getArchetype();
        if (InventoryArchetypes.CHEST.equals(archetype) || InventoryArchetypes.DOUBLE_CHEST.equals(archetype)) {
            int size = inventory.func_70302_i_();
            return size % 9 == 0 && size / 9 <= 6 && size != 0;
        }
        if (InventoryArchetypes.HOPPER.equals(archetype)) {
            return inventory.func_70302_i_() == 5;
        }
        if (InventoryArchetypes.DISPENSER.equals(archetype)) {
            return inventory.func_70302_i_() == 9;
        }
        if (InventoryArchetypes.WORKBENCH.equals(archetype)) {
            return inventory.func_70302_i_() == 10;
        }
        if (InventoryArchetypes.FURNACE.equals(archetype)) {
            return inventory.func_70302_i_() == 3;
        }
        if (InventoryArchetypes.ENCHANTING_TABLE.equals(archetype)) {
            return inventory.func_70302_i_() == 2;
        }
        if (InventoryArchetypes.ANVIL.equals(archetype)) {
            return inventory.func_70302_i_() == 3;
        }
        if (InventoryArchetypes.BREWING_STAND.equals(archetype)) {
            return inventory.func_70302_i_() == 5;
        }
        if (InventoryArchetypes.BEACON.equals(archetype)) {
            return inventory.func_70302_i_() == 1;
        }
        if (InventoryArchetypes.HORSE.equals(archetype)) {
            return inventory.func_70302_i_() == 2;
        }
        if (InventoryArchetypes.HORSE_WITH_CHEST.equals(archetype)) {
            return inventory.func_70302_i_() == 17;
        }
        if (InventoryArchetypes.VILLAGER.equals(archetype)) {
            return inventory.func_70302_i_() == 3;
        }
        return true;
    }

    public static ChangeInventoryEvent.Transfer.Pre callTransferPre(Inventory source, Inventory destination) {
        Sponge.getCauseStackManager().pushCause(source);
        ChangeInventoryEvent.Transfer.Pre event = SpongeEventFactory.createChangeInventoryEventTransferPre(Sponge.getCauseStackManager().getCurrentCause(), source, destination);
        SpongeImpl.postEvent(event);
        Sponge.getCauseStackManager().popCause();
        return event;
    }

    public static boolean callTransferPost(@Nullable TrackedInventoryBridge captureSource, @Nullable Inventory source, @Nullable Inventory destination) {
        if (captureSource == null || source == null || destination == null) {
            return true;
        }
        Sponge.getCauseStackManager().pushCause(source);
        ChangeInventoryEvent.Transfer.Post event = SpongeEventFactory.createChangeInventoryEventTransferPost(Sponge.getCauseStackManager().getCurrentCause(), source, destination, captureSource.bridge$getCapturedSlotTransactions());
        SpongeImpl.postEvent(event);
        if (event.isCancelled()) {
            SpongeCommonEventFactory.setSlots(event.getTransactions(), Transaction::getOriginal);
        } else {
            event.getTransactions().stream().filter(t -> !t.isValid() || t.getCustom().isPresent()).forEach(t -> t.getSlot().set(((ItemStackSnapshot)t.getFinal()).createStack()));
        }
        captureSource.bridge$getCapturedSlotTransactions().clear();
        Sponge.getCauseStackManager().popCause();
        return event.isCancelled();
    }

    public static void setSlots(List<SlotTransaction> transactions, Function<SlotTransaction, ItemStackSnapshot> func) {
        transactions.forEach(t -> t.getSlot().set(((ItemStackSnapshot)func.apply((SlotTransaction)t)).createStack()));
    }

    public static void captureTransaction(@Nullable TrackedInventoryBridge captureIn, @Nullable Inventory inv, int index, net.minecraft.item.ItemStack originalStack) {
        if (captureIn == null || inv == null) {
            return;
        }
        Optional<org.spongepowered.api.item.inventory.Slot> slot = ((InventoryAdapter)((Object)inv)).bridge$getSlot(index);
        if (slot.isPresent()) {
            SlotTransaction trans = new SlotTransaction(slot.get(), ItemStackUtil.snapshotOf(originalStack), ItemStackUtil.snapshotOf(slot.get().peek().orElse(ItemStack.empty())));
            captureIn.bridge$getCapturedSlotTransactions().add(trans);
        } else {
            SpongeImpl.getLogger().warn("Unable to capture transaction from " + inv.getClass() + " at index " + index);
        }
    }

    public static net.minecraft.item.ItemStack captureTransaction(@Nullable TrackedInventoryBridge captureIn, @Nullable Inventory inv, int index, Supplier<net.minecraft.item.ItemStack> transaction) {
        if (captureIn == null || inv == null) {
            return transaction.get();
        }
        Optional<org.spongepowered.api.item.inventory.Slot> slot = ((InventoryAdapter)((Object)inv)).bridge$getSlot(index);
        if (!slot.isPresent()) {
            SpongeImpl.getLogger().warn("Unable to capture transaction from " + inv.getClass() + " at index " + index);
            return transaction.get();
        }
        ItemStackSnapshot original = slot.get().peek().map(ItemStackUtil::snapshotOf).orElse(ItemStackSnapshot.NONE);
        net.minecraft.item.ItemStack remaining = transaction.get();
        if (remaining.func_190926_b()) {
            ItemStackSnapshot replacement = slot.get().peek().map(ItemStackUtil::snapshotOf).orElse(ItemStackSnapshot.NONE);
            captureIn.bridge$getCapturedSlotTransactions().add(new SlotTransaction(slot.get(), original, replacement));
        }
        return remaining;
    }

    public static SetAITargetEvent callSetAttackTargetEvent(@Nullable Entity target, Agent agent) {
        SetAITargetEvent event = SpongeEventFactory.createSetAITargetEvent(Sponge.getCauseStackManager().getCurrentCause(), Optional.ofNullable(target), agent);
        SpongeImpl.postEvent(event);
        return event;
    }

    public static CraftItemEvent.Preview callCraftEventPre(EntityPlayer player, CraftingInventory inventory, SlotTransaction previewTransaction, @Nullable CraftingRecipe recipe, net.minecraft.inventory.Container container, List<SlotTransaction> transactions) {
        CraftItemEvent.Preview event = SpongeEventFactory.createCraftItemEventPreview(Sponge.getCauseStackManager().getCurrentCause(), inventory, previewTransaction, Optional.ofNullable(recipe), (Inventory)container, transactions);
        SpongeImpl.postEvent(event);
        ((ContainerBridge)container).bridge$detectAndSendChanges(true);
        PacketPhaseUtil.handleSlotRestore(player, container, new ArrayList<SlotTransaction>(transactions), event.isCancelled());
        if (player instanceof EntityPlayerMP && (event.getPreview().getCustom().isPresent() || event.isCancelled() || !event.getPreview().isValid())) {
            ItemStackSnapshot stack = (ItemStackSnapshot)event.getPreview().getFinal();
            if (event.isCancelled() || !event.getPreview().isValid()) {
                stack = (ItemStackSnapshot)event.getPreview().getOriginal();
            }
            net.minecraft.item.ItemStack mcStack = ItemStackUtil.fromSnapshotToNative(stack);
            if (container instanceof ContainerWorkbench) {
                ((ContainerWorkbench)container).field_75160_f.func_70299_a(0, mcStack);
            } else if (container instanceof ContainerPlayer) {
                ((ContainerPlayer)container).field_75179_f.func_70299_a(0, mcStack);
            }
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(0, 0, mcStack));
        }
        return event;
    }

    public static CraftItemEvent.Craft callCraftEventPost(EntityPlayer player, CraftingInventory inventory, ItemStackSnapshot result, @Nullable CraftingRecipe recipe, net.minecraft.inventory.Container container, List<SlotTransaction> transactions) {
        net.minecraft.item.ItemStack previousCursor = ((ContainerBridge)container).bridge$getPreviousCursor();
        if (previousCursor == null) {
            previousCursor = player.field_71071_by.func_70445_o();
        }
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(ItemStackUtil.snapshotOf(previousCursor), ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o()));
        CraftingOutput slot = inventory.getResult();
        CraftItemEvent.Craft event = SpongeEventFactory.createCraftItemEventCraft(Sponge.getCauseStackManager().getCurrentCause(), result, inventory, cursorTransaction, Optional.ofNullable(recipe), Optional.of(slot), (Container)container, transactions);
        SpongeImpl.postEvent(event);
        boolean capture = ((TrackedInventoryBridge)container).bridge$capturingInventory();
        ((TrackedInventoryBridge)container).bridge$setCaptureInventory(false);
        PacketPhaseUtil.handleSlotRestore(player, container, new ArrayList<SlotTransaction>(transactions), event.isCancelled());
        if (event.isCancelled() || !event.getCursorTransaction().isValid() || event.getCursorTransaction().getCustom().isPresent()) {
            ItemStackSnapshot newCursor = event.isCancelled() || !event.getCursorTransaction().isValid() ? event.getCursorTransaction().getOriginal() : event.getCursorTransaction().getFinal();
            player.field_71071_by.func_70437_b(ItemStackUtil.fromSnapshotToNative(newCursor));
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(-1, -1, player.field_71071_by.func_70445_o()));
            }
        }
        transactions.clear();
        ((TrackedInventoryBridge)container).bridge$setCaptureInventory(capture);
        return event;
    }

    public static void callPostPlayerRespawnEvent(EntityPlayerMP playerMP, boolean conqueredEnd) {
    }

    public static UpdateAnvilEvent callUpdateAnvilEvent(ContainerRepair anvil, net.minecraft.item.ItemStack slot1, net.minecraft.item.ItemStack slot2, net.minecraft.item.ItemStack result, String name, int levelCost, int materialCost) {
        Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.NONE, ItemStackUtil.snapshotOf(result));
        UpdateAnvilEventCost costs = new UpdateAnvilEventCost(levelCost, materialCost);
        UpdateAnvilEvent event = SpongeEventFactory.createUpdateAnvilEvent(Sponge.getCauseStackManager().getCurrentCause(), new Transaction<UpdateAnvilEventCost>(costs, costs), name, ItemStackUtil.snapshotOf(slot1), transaction, ItemStackUtil.snapshotOf(slot2), (Inventory)anvil);
        SpongeImpl.postEvent(event);
        return event;
    }

    public static ChangeEntityEquipmentEvent callChangeEntityEquipmentEvent(EntityLivingBase entity, ItemStackSnapshot before, ItemStackSnapshot after, SlotAdapter slot) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            ChangeEntityEquipmentEvent.TargetLiving event;
            frame.pushCause(entity);
            Cause cause = frame.getCurrentCause();
            Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(before, after);
            if (entity instanceof EntityPlayerMP) {
                Player player = (Player)((EntityPlayerMP)entity);
                event = after.isEmpty() ? SpongeEventFactory.createChangeEntityEquipmentEventBreak(cause, player, slot, transaction) : SpongeEventFactory.createChangeEntityEquipmentEventTargetPlayer(cause, player, slot, transaction);
            } else if (entity instanceof Human) {
                Human humanoid = (Human)entity;
                event = SpongeEventFactory.createChangeEntityEquipmentEventTargetHumanoid(cause, humanoid, slot, transaction);
            } else {
                Living living = (Living)entity;
                event = SpongeEventFactory.createChangeEntityEquipmentEventTargetLiving(cause, living, slot, transaction);
            }
            SpongeImpl.postEvent(event);
            ChangeEntityEquipmentEvent.TargetLiving targetLiving = event;
            return targetLiving;
        }
    }

    public static int callEnchantEventLevelRequirement(ContainerEnchantment container, int seed, int option, int power, net.minecraft.item.ItemStack itemStack, int levelRequirement) {
        Container enchantContainer = ContainerUtil.fromNative((net.minecraft.inventory.Container)container);
        EnchantItemEvent.CalculateLevelRequirement event = SpongeEventFactory.createEnchantItemEventCalculateLevelRequirement(Sponge.getCauseStackManager().getCurrentCause(), levelRequirement, levelRequirement, ItemStackUtil.snapshotOf(itemStack), enchantContainer, option, power, seed);
        SpongeImpl.postEvent(event);
        return event.getLevelRequirement();
    }

    public static List<EnchantmentData> callEnchantEventEnchantmentList(ContainerEnchantment container, int seed, net.minecraft.item.ItemStack itemStack, int option, int level, List<EnchantmentData> list) {
        List<Enchantment> enchList = Collections.unmodifiableList(SpongeRandomEnchantmentListBuilder.fromNative(list));
        Container enchantContainer = ContainerUtil.fromNative((net.minecraft.inventory.Container)container);
        EnchantItemEvent.CalculateEnchantment event = SpongeEventFactory.createEnchantItemEventCalculateEnchantment(Sponge.getCauseStackManager().getCurrentCause(), enchList, enchList, ItemStackUtil.snapshotOf(itemStack), enchantContainer, level, option, seed);
        SpongeImpl.postEvent(event);
        if (event.getEnchantments() != event.getOriginalEnchantments()) {
            return SpongeRandomEnchantmentListBuilder.toNative(event.getEnchantments());
        }
        return list;
    }

    public static EnchantItemEvent.Post callEnchantEventEnchantPost(EntityPlayer playerIn, ContainerEnchantment container, SlotTransaction enchantedItem, SlotTransaction lapisItem, int option, int seed) {
        Container enchantContainer = ContainerUtil.fromNative((net.minecraft.inventory.Container)container);
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(playerIn.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> cursorTrans = new Transaction<ItemStackSnapshot>(cursor, cursor);
        ArrayList<SlotTransaction> slotTrans = new ArrayList<SlotTransaction>();
        slotTrans.add(lapisItem);
        slotTrans.add(enchantedItem);
        EnchantItemEvent.Post event = SpongeEventFactory.createEnchantItemEventPost(Sponge.getCauseStackManager().getCurrentCause(), cursorTrans, enchantedItem.getSlot(), Optional.empty(), enchantContainer, slotTrans, option, seed);
        SpongeImpl.postEvent(event);
        PacketPhaseUtil.handleSlotRestore(playerIn, (net.minecraft.inventory.Container)container, event.getTransactions(), event.isCancelled());
        if (event.isCancelled() || !event.getCursorTransaction().isValid()) {
            PacketPhaseUtil.handleCustomCursor(playerIn, event.getCursorTransaction().getOriginal());
        } else if (event.getCursorTransaction().getCustom().isPresent()) {
            PacketPhaseUtil.handleCustomCursor(playerIn, event.getCursorTransaction().getFinal());
        }
        return event;
    }

    public static Optional<Explosion> detonateExplosive(ExplosiveBridge explosiveBridge, Explosion.Builder builder) {
        DetonateExplosiveEvent event = SpongeEventFactory.createDetonateExplosiveEvent(Sponge.getCauseStackManager().getCurrentCause(), builder, builder.build(), (Explosive)((Object)explosiveBridge));
        if (!Sponge.getEventManager().post(event)) {
            org.spongepowered.api.world.explosion.Explosion explosion = event.getExplosionBuilder().build();
            if (explosion.getRadius() > 0.0f) {
                ((WorldServerBridge)((Object)((Explosive)((Object)explosiveBridge)).getWorld())).bridge$triggerInternalExplosion(explosion, e -> GeneralPhase.State.EXPLOSION.createPhaseContext().explosion((Explosion)e));
            }
            return Optional.of((Explosion)explosion);
        }
        return Optional.empty();
    }

    @Nullable
    public static net.minecraft.item.ItemStack throwDropItemAndConstructEvent(net.minecraft.entity.Entity entity, double posX, double posY, double posZ, ItemStackSnapshot snapshot, List<ItemStackSnapshot> original, CauseStackManager.StackFrame frame) {
        net.minecraft.item.ItemStack item;
        EntityPlayerBridge mixinPlayer = entity instanceof EntityPlayerBridge ? (EntityPlayerBridge)entity : null;
        frame.pushCause(entity);
        DropItemEvent.Pre dropEvent = SpongeEventFactory.createDropItemEventPre(frame.getCurrentCause(), (List)ImmutableList.of((Object)snapshot), original);
        SpongeImpl.postEvent(dropEvent);
        if (dropEvent.isCancelled()) {
            if (mixinPlayer != null) {
                mixinPlayer.bridge$shouldRestoreInventory(true);
            }
            return null;
        }
        if (dropEvent.getDroppedItems().isEmpty()) {
            return null;
        }
        Transform<World> suggested = new Transform<World>((World)entity.field_70170_p, new Vector3d(posX, posY, posZ));
        frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
        ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(frame.getCurrentCause(), EntityTypes.ITEM, suggested);
        frame.removeContext(EventContextKeys.SPAWN_TYPE);
        SpongeImpl.postEvent(event);
        if (event.isCancelled()) {
            if (mixinPlayer != null) {
                mixinPlayer.bridge$shouldRestoreInventory(true);
            }
            return null;
        }
        net.minecraft.item.ItemStack itemStack = item = event.isCancelled() ? null : ItemStackUtil.fromSnapshotToNative(dropEvent.getDroppedItems().get(0));
        if (item == null) {
            if (mixinPlayer != null) {
                mixinPlayer.bridge$shouldRestoreInventory(true);
            }
            return null;
        }
        return item;
    }

    @Nullable
    public static PlaySoundEvent.Broadcast callPlaySoundBroadcastEvent(CauseStackManager.StackFrame frame, WorldBridge bridge, BlockPos pos, int effectID) {
        float volume;
        SoundType soundType;
        if (effectID == 1023) {
            soundType = SoundTypes.ENTITY_WITHER_SPAWN;
            volume = 1.0f;
        } else if (effectID == 1028) {
            soundType = SoundTypes.ENTITY_ENDERDRAGON_DEATH;
            volume = 5.0f;
        } else if (effectID == 1038) {
            soundType = SoundTypes.BLOCK_END_PORTAL_SPAWN;
            volume = 1.0f;
        } else {
            return null;
        }
        Location<World> location = new Location<World>((World)((Object)bridge), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        PlaySoundEvent.Broadcast event = SpongeEventFactory.createPlaySoundEventBroadcast(frame.getCurrentCause(), location, SoundCategories.HOSTILE, soundType, 1.0f, volume);
        SpongeImpl.postEvent(event);
        return event;
    }

    public static PlaySoundEvent.Record callPlaySoundRecordEvent(Cause cause, BlockJukebox.TileEntityJukebox jukebox, RecordType recordType, int data) {
        Jukebox apiJuke = (Jukebox)jukebox;
        Location<World> location = apiJuke.getLocation();
        PlaySoundEvent.Record event = data == 0 ? SpongeEventFactory.createPlaySoundEventRecordStart(cause, apiJuke, location, recordType, SoundCategories.RECORD, recordType.getSound(), 1.0f, 4.0f) : SpongeEventFactory.createPlaySoundEventRecordStop(cause, apiJuke, location, recordType, SoundCategories.RECORD, recordType.getSound(), 1.0f, 4.0f);
        SpongeImpl.postEvent(event);
        return event;
    }

    public static PlaySoundEvent.AtEntity callPlaySoundAtEntityEvent(Cause cause, @Nullable EntityPlayer entity, WorldBridge worldMixin, double x, double y, double z, net.minecraft.util.SoundCategory category, SoundEvent name, float pitch, float volume) {
        Location<World> location = new Location<World>((World)((Object)worldMixin), x, y, z);
        PlaySoundEvent.AtEntity event = SpongeEventFactory.createPlaySoundEventAtEntity(cause, location, Optional.ofNullable(entity), (SoundCategory)category, (SoundType)name, pitch, volume);
        SpongeImpl.postEvent(event);
        return event;
    }

    public static PlaySoundEvent.NoteBlock callPlaySoundNoteBLockEvent(Cause cause, World world, Note note, BlockPos pos, SoundEvent soundEvent, InstrumentType instrument, NotePitch notePitch, Float pitch) {
        Location<World> location = new Location<World>(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        PlaySoundEvent.NoteBlock event = SpongeEventFactory.createPlaySoundEventNoteBlock(cause, instrument, location, note, notePitch, SoundCategories.RECORD, (SoundType)soundEvent, pitch.floatValue(), 3.0f);
        SpongeImpl.postEvent(event);
        return event;
    }
}

