/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.world.Explosion;
import net.minecraft.world.WorldServer;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhaseContext;
import org.spongepowered.common.mixin.core.world.ExplosionAccessor;

public final class ExplosionContext
extends GeneralPhaseContext<ExplosionContext> {
    private Explosion explosion;

    public ExplosionContext() {
        super(GeneralPhase.State.EXPLOSION);
    }

    ExplosionContext populateFromCurrentState() {
        PhaseContext<?> context = PhaseTracker.getInstance().getCurrentContext();
        context.state.appendContextPreExplosion(this, context);
        return this;
    }

    public ExplosionContext potentialExplosionSource(WorldServer worldServer, @Nullable Entity entityIn) {
        if (entityIn != null) {
            this.source(entityIn);
        } else {
            this.source(worldServer);
        }
        return this;
    }

    public ExplosionContext explosion(Explosion explosion) {
        this.explosion = explosion;
        return this;
    }

    public Explosion getExplosion() {
        return this.explosion;
    }

    public org.spongepowered.api.world.explosion.Explosion getSpongeExplosion() {
        return (org.spongepowered.api.world.explosion.Explosion)this.explosion;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        return super.printCustom(printer, indent).add(s + "- %s: %s", "Explosion", this.explosion);
    }

    @Override
    protected void reset() {
        super.reset();
        this.explosion = null;
    }

    @Override
    protected boolean isRunaway(PhaseContext<?> phaseContext) {
        if (phaseContext.getClass() != ExplosionContext.class) {
            return false;
        }
        ExplosionAccessor otherExplosion = (ExplosionAccessor)((ExplosionContext)phaseContext).explosion;
        ExplosionAccessor thisExplosion = (ExplosionAccessor)this.explosion;
        return otherExplosion.accessor$getWorld() == thisExplosion.accessor$getWorld() && otherExplosion.accessor$getX() == thisExplosion.accessor$getX() && otherExplosion.accessor$getY() == thisExplosion.accessor$getY() && otherExplosion.accessor$getZ() == thisExplosion.accessor$getZ();
    }
}

