/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.bridge.inventory.ContainerBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.phase.packet.drag.DragInventoryStopState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.util.Constants;

public final class DoubleClickInventoryState
extends BasicInventoryPacketState {
    public DoubleClickInventoryState() {
        super(Constants.Networking.MODE_DOUBLE_CLICK | 1 | 2, 65031);
    }

    @Override
    protected boolean shouldFire() {
        return ShouldFire.CLICK_INVENTORY_EVENT_DOUBLE;
    }

    @Override
    public ClickInventoryEvent createInventoryEvent(EntityPlayerMP playerMP, Container openContainer, Transaction<ItemStackSnapshot> transaction, List<SlotTransaction> slotTransactions, List<Entity> capturedEntities, int usedButton, @Nullable Slot slot) {
        return SpongeEventFactory.createClickInventoryEventDouble(Sponge.getCauseStackManager().getCurrentCause(), transaction, Optional.ofNullable(slot), openContainer, slotTransactions);
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, InventoryPacketContext context) {
        super.populateContext(playerMP, packet, context);
        ((ContainerBridge)playerMP.field_71070_bA).bridge$setFirePreview(false);
    }

    @Override
    public void unwind(InventoryPacketContext context) {
        DragInventoryStopState.unwindCraftPreview(context);
        super.unwind(context);
    }
}

