/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.entity;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.entity.DamageableData;
import org.spongepowered.api.data.manipulator.mutable.entity.HealthData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.data.value.mutable.OptionalValue;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeDamageableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeHealthData;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.mutable.SpongeOptionalValue;
import org.spongepowered.common.entity.projectile.ProjectileLauncher;
import org.spongepowered.common.mixin.api.mcp.entity.EntityMixin_API;

@NonnullByDefault
@Mixin(value={EntityLivingBase.class}, priority=999)
public abstract class EntityLivingBaseMixin_API
extends EntityMixin_API
implements Living {
    @Shadow
    @Nullable
    private EntityLivingBase field_70755_b;
    @Shadow
    protected float field_110153_bc;

    @Shadow
    public abstract void func_70606_j(float var1);

    @Shadow
    public abstract void func_70034_d(float var1);

    @Shadow
    public abstract void func_181013_g(float var1);

    @Shadow
    public abstract void func_184611_a(EnumHand var1, @Nullable ItemStack var2);

    @Shadow
    public abstract float func_110143_aJ();

    @Shadow
    public abstract float func_110138_aP();

    @Shadow
    public abstract float func_70079_am();

    @Shadow
    public abstract ItemStack func_184582_a(EntityEquipmentSlot var1);

    @Shadow
    public abstract ItemStack func_184586_b(EnumHand var1);

    @Shadow
    public abstract ItemStack func_184614_ca();

    @Override
    public Vector3d getHeadRotation() {
        return new Vector3d(this.getRotation().getX(), (double)this.func_70079_am(), 0.0);
    }

    @Override
    public void setHeadRotation(Vector3d rotation) {
        this.setRotation(this.getRotation().mul(0.0f, 1.0f, 1.0f).add(rotation.getX(), 0.0, 0.0));
        this.func_70034_d((float)rotation.getY());
        this.func_181013_g((float)rotation.getY());
    }

    @Override
    public Text getTeamRepresentation() {
        return Text.of(this.func_110124_au().toString());
    }

    @Override
    public HealthData getHealthData() {
        return new SpongeHealthData(this.func_110143_aJ(), this.func_110138_aP());
    }

    @Override
    public MutableBoundedValue<Double> health() {
        return SpongeValueFactory.boundedBuilder(Keys.HEALTH).minimum(0.0).maximum(Double.valueOf(this.func_110138_aP())).defaultValue(Double.valueOf(this.func_110138_aP())).actualValue(Double.valueOf(this.func_110143_aJ())).build();
    }

    @Override
    public MutableBoundedValue<Double> maxHealth() {
        return SpongeValueFactory.boundedBuilder(Keys.MAX_HEALTH).minimum(1.0).maximum(3.4028234663852886E38).defaultValue(20.0).actualValue(Double.valueOf(this.func_110138_aP())).build();
    }

    @Override
    public DamageableData getDamageableData() {
        return new SpongeDamageableData((Living)this.field_70755_b, Double.valueOf(this.field_110153_bc));
    }

    @Override
    public OptionalValue<EntitySnapshot> lastAttacker() {
        return new SpongeOptionalValue<Object>(Keys.LAST_ATTACKER, Optional.empty(), Optional.ofNullable(this.field_70755_b == null ? null : ((Living)this.field_70755_b).createSnapshot()));
    }

    @Override
    public OptionalValue<Double> lastDamage() {
        return new SpongeOptionalValue<Object>(Keys.LAST_DAMAGE, Optional.empty(), Optional.ofNullable(this.field_70755_b == null ? null : Double.valueOf(this.field_110153_bc)));
    }

    @Override
    public <T extends Projectile> Optional<T> launchProjectile(Class<T> projectileClass) {
        return ProjectileLauncher.launch((Class)Preconditions.checkNotNull(projectileClass, (Object)"projectile class"), this, null);
    }

    @Override
    public <T extends Projectile> Optional<T> launchProjectile(Class<T> projectileClass, Vector3d velocity) {
        return ProjectileLauncher.launch((Class)Preconditions.checkNotNull(projectileClass, (Object)"projectile class"), this, (Vector3d)Preconditions.checkNotNull((Object)velocity, (Object)"velocity"));
    }
}

