/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world.storage;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.PortalAgentType;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.SerializationBehaviors;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.DimensionTypeBridge;
import org.spongepowered.common.bridge.world.GameRulesBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.registry.type.world.WorldGeneratorModifierRegistryModule;
import org.spongepowered.common.util.Constants;

@Mixin(value={WorldInfo.class})
@Implements(value={@Interface(iface=WorldProperties.class, prefix="worldproperties$")})
public abstract class WorldInfoMixin_API
implements WorldProperties {
    @Shadow
    private long field_76100_a;
    @Shadow
    private WorldType field_76098_b;
    @Shadow
    private String field_82576_c;
    @Shadow
    private int field_76099_c;
    @Shadow
    private int field_76096_d;
    @Shadow
    private int field_76097_e;
    @Shadow
    private long field_82575_g;
    @Shadow
    private long field_76094_f;
    @Shadow
    private long field_76095_g;
    @Shadow
    private long field_76107_h;
    @Shadow
    private NBTTagCompound field_76108_i;
    @Shadow
    private String field_76106_k;
    @Shadow
    private int field_76103_l;
    @Shadow
    private int field_176157_p;
    @Shadow
    private boolean field_76104_m;
    @Shadow
    private int field_76101_n;
    @Shadow
    private boolean field_76102_o;
    @Shadow
    private int field_76114_p;
    @Shadow
    private GameType field_76113_q;
    @Shadow
    private boolean field_76112_r;
    @Shadow
    private boolean field_76111_s;
    @Shadow
    private boolean field_76110_t;
    @Shadow
    private boolean field_76109_u;
    @Shadow
    private EnumDifficulty field_176158_z;
    @Shadow
    private boolean field_176150_A;
    @Shadow
    private double field_176151_B;
    @Shadow
    private double field_176152_C;
    @Shadow
    private double field_176146_D;
    @Shadow
    private long field_176147_E;
    @Shadow
    private double field_176148_F;
    @Shadow
    private double field_176149_G;
    @Shadow
    private double field_176153_H;
    @Shadow
    private int field_176154_I;
    @Shadow
    private int field_176155_J;
    @Shadow
    private GameRules field_82577_x;
    private SerializationBehavior api$serializationBehavior = SerializationBehaviors.AUTOMATIC;

    @Shadow
    public abstract void func_176144_a(EnumDifficulty var1);

    @Shadow
    public abstract NBTTagCompound func_76082_a(@Nullable NBTTagCompound var1);

    @Shadow
    public abstract String shadow$func_76065_j();

    @Override
    public Vector3i getSpawnPosition() {
        return new Vector3i(this.field_76099_c, this.field_76096_d, this.field_76097_e);
    }

    @Override
    public void setSpawnPosition(Vector3i position) {
        Preconditions.checkNotNull((Object)position);
        this.field_76099_c = position.getX();
        this.field_76096_d = position.getY();
        this.field_76097_e = position.getZ();
    }

    @Override
    public GeneratorType getGeneratorType() {
        return (GeneratorType)this.field_76098_b;
    }

    @Override
    public void setGeneratorType(GeneratorType type) {
        this.field_76098_b = (WorldType)type;
    }

    @Intrinsic
    public long worldproperties$getSeed() {
        return this.field_76100_a;
    }

    @Override
    public void setSeed(long seed) {
        this.field_76100_a = seed;
    }

    @Override
    public long getTotalTime() {
        return this.field_82575_g;
    }

    @Intrinsic
    public long worldproperties$getWorldTime() {
        return this.field_76094_f;
    }

    @Override
    public void setWorldTime(long time) {
        this.field_76094_f = time;
    }

    @Override
    public DimensionType getDimensionType() {
        return ((WorldInfoBridge)((Object)this)).bridge$getDimensionType();
    }

    @Override
    public PortalAgentType getPortalAgentType() {
        return ((WorldInfoBridge)((Object)this)).bridge$getPortalAgent();
    }

    @Intrinsic
    public boolean worldproperties$isRaining() {
        return this.field_76104_m;
    }

    @Override
    public void setRaining(boolean state) {
        this.field_76104_m = state;
    }

    @Intrinsic
    public int worldproperties$getRainTime() {
        return this.field_76101_n;
    }

    @Intrinsic
    public void worldproperties$setRainTime(int time) {
        this.field_76101_n = time;
    }

    @Intrinsic
    public boolean worldproperties$isThundering() {
        return this.field_76102_o;
    }

    @Intrinsic
    public void worldproperties$setThundering(boolean state) {
        this.field_76102_o = state;
    }

    @Override
    public int getThunderTime() {
        return this.field_76114_p;
    }

    @Override
    public void setThunderTime(int time) {
        this.field_76114_p = time;
    }

    @Override
    public GameMode getGameMode() {
        return (GameMode)this.field_76113_q;
    }

    @Override
    public void setGameMode(GameMode gamemode) {
        this.field_76113_q = (GameType)gamemode;
    }

    @Override
    public boolean usesMapFeatures() {
        return this.field_76112_r;
    }

    @Override
    public void setMapFeaturesEnabled(boolean state) {
        this.field_76112_r = state;
    }

    @Override
    public boolean isHardcore() {
        return this.field_76111_s;
    }

    @Override
    public void setHardcore(boolean state) {
        this.field_76111_s = state;
    }

    @Override
    public boolean areCommandsAllowed() {
        return this.field_76110_t;
    }

    @Override
    public void setCommandsAllowed(boolean state) {
        this.field_76110_t = state;
    }

    @Override
    public boolean isInitialized() {
        return this.field_76109_u;
    }

    @Override
    public Difficulty getDifficulty() {
        return (Difficulty)this.field_176158_z;
    }

    @Override
    public void setDifficulty(Difficulty difficulty) {
        this.func_176144_a((EnumDifficulty)difficulty);
    }

    @Override
    public boolean isPVPEnabled() {
        return ((WorldInfoBridge)((Object)this)).bridge$getConfigAdapter().getConfig().getWorld().getPVPEnabled();
    }

    @Override
    public void setPVPEnabled(boolean enabled) {
        ((WorldInfoBridge)((Object)this)).bridge$getConfigAdapter().getConfig().getWorld().setPVPEnabled(enabled);
    }

    @Override
    public boolean doesGenerateBonusChest() {
        return ((WorldInfoBridge)((Object)this)).bridge$getSpawnsBonusChest();
    }

    @Override
    public Vector3d getWorldBorderCenter() {
        return new Vector3d(this.field_176151_B, 0.0, this.field_176152_C);
    }

    @Override
    public void setWorldBorderCenter(double x, double z) {
        this.field_176151_B = x;
        this.field_176152_C = z;
    }

    @Override
    public double getWorldBorderDiameter() {
        return this.field_176146_D;
    }

    @Override
    public void setWorldBorderDiameter(double diameter) {
        this.field_176146_D = diameter;
    }

    @Override
    public double getWorldBorderTargetDiameter() {
        return this.field_176148_F;
    }

    @Override
    public void setWorldBorderTargetDiameter(double diameter) {
        this.field_176148_F = diameter;
    }

    @Override
    public double getWorldBorderDamageThreshold() {
        return this.field_176149_G;
    }

    @Override
    public void setWorldBorderDamageThreshold(double distance) {
        this.field_176149_G = distance;
    }

    @Override
    public double getWorldBorderDamageAmount() {
        return this.field_176153_H;
    }

    @Override
    public void setWorldBorderDamageAmount(double damage) {
        this.field_176153_H = damage;
    }

    @Override
    public int getWorldBorderWarningTime() {
        return this.field_176155_J;
    }

    @Override
    public void setWorldBorderWarningTime(int time) {
        this.field_176155_J = time;
    }

    @Override
    public int getWorldBorderWarningDistance() {
        return this.field_176154_I;
    }

    @Override
    public void setWorldBorderWarningDistance(int distance) {
        this.field_176154_I = distance;
    }

    @Override
    public long getWorldBorderTimeRemaining() {
        return this.field_176147_E;
    }

    @Override
    public void setWorldBorderTimeRemaining(long time) {
        this.field_176147_E = time;
    }

    @Override
    public Optional<String> getGameRule(String gameRule) {
        Preconditions.checkNotNull((Object)gameRule, (Object)"The gamerule cannot be null!");
        if (this.field_82577_x.func_82765_e(gameRule)) {
            return Optional.of(this.field_82577_x.func_82767_a(gameRule));
        }
        return Optional.empty();
    }

    @Override
    public Map<String, String> getGameRules() {
        ImmutableMap.Builder ruleMap = ImmutableMap.builder();
        for (String rule : this.field_82577_x.func_82763_b()) {
            ruleMap.put((Object)rule, (Object)this.field_82577_x.func_82767_a(rule));
        }
        return ruleMap.build();
    }

    @Override
    public void setGameRule(String gameRule, String value) {
        Preconditions.checkNotNull((Object)gameRule, (Object)"The gamerule cannot be null!");
        Preconditions.checkNotNull((Object)value, (Object)"The gamerule value cannot be null!");
        ((GameRulesBridge)this.field_82577_x).bridge$setOrCreateGameRule(gameRule, value);
    }

    @Override
    public boolean removeGameRule(String gameRule) {
        Preconditions.checkNotNull((Object)gameRule, (Object)"The gamerule cannot be null!");
        return ((GameRulesBridge)this.field_82577_x).bridge$removeGameRule(gameRule);
    }

    @Override
    public UUID getUniqueId() {
        return ((WorldInfoBridge)((Object)this)).bridge$getAssignedId();
    }

    @Override
    public int getContentVersion() {
        return 0;
    }

    @Override
    public DataContainer toContainer() {
        return NbtTranslator.getInstance().translateFrom(this.func_76082_a(null));
    }

    @Override
    public boolean isEnabled() {
        return ((WorldInfoBridge)((Object)this)).bridge$getConfigAdapter().getConfig().getWorld().isWorldEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        ((WorldInfoBridge)((Object)this)).bridge$getConfigAdapter().getConfig().getWorld().setWorldEnabled(enabled);
    }

    @Override
    public boolean loadOnStartup() {
        Boolean loadOnStartup = ((WorldInfoBridge)((Object)this)).bridge$getConfigAdapter().getConfig().getWorld().loadOnStartup();
        if (loadOnStartup == null) {
            loadOnStartup = ((DimensionTypeBridge)((Object)((WorldInfoBridge)((Object)this)).bridge$getDimensionType())).bridge$shouldGenerateSpawnOnLoad();
            this.setLoadOnStartup(loadOnStartup);
        }
        return loadOnStartup;
    }

    @Override
    public void setLoadOnStartup(boolean state) {
        ((WorldInfoBridge)((Object)this)).bridge$getConfigAdapter().getConfig().getWorld().setLoadOnStartup(state);
        ((WorldInfoBridge)((Object)this)).bridge$saveConfig();
    }

    @Override
    public boolean doesKeepSpawnLoaded() {
        Integer dimensionId;
        Boolean keepSpawnLoaded = ((WorldInfoBridge)((Object)this)).bridge$getConfigAdapter().getConfig().getWorld().getKeepSpawnLoaded();
        if (keepSpawnLoaded == null) {
            keepSpawnLoaded = ((DimensionTypeBridge)((Object)((WorldInfoBridge)((Object)this)).bridge$getDimensionType())).bridge$shouldLoadSpawn();
        } else if (((WorldInfoBridge)((Object)this)).bridge$getIsMod() && !keepSpawnLoaded.booleanValue() && (dimensionId = ((WorldInfoBridge)((Object)this)).bridge$getDimensionId()) != null && dimensionId.intValue() == ((net.minecraft.world.DimensionType)((WorldInfoBridge)((Object)this)).bridge$getDimensionType()).func_186068_a() && ((DimensionTypeBridge)((Object)((WorldInfoBridge)((Object)this)).bridge$getDimensionType())).bridge$shouldKeepSpawnLoaded()) {
            this.setKeepSpawnLoaded(true);
            keepSpawnLoaded = true;
        }
        return keepSpawnLoaded;
    }

    @Override
    public void setKeepSpawnLoaded(boolean loaded) {
        ((WorldInfoBridge)((Object)this)).bridge$getConfigAdapter().getConfig().getWorld().setKeepSpawnLoaded(loaded);
        ((WorldInfoBridge)((Object)this)).bridge$saveConfig();
    }

    @Override
    public boolean doesGenerateSpawnOnLoad() {
        Boolean shouldGenerateSpawn = ((WorldInfoBridge)((Object)this)).bridge$getConfigAdapter().getConfig().getWorld().getGenerateSpawnOnLoad();
        if (shouldGenerateSpawn == null) {
            shouldGenerateSpawn = ((DimensionTypeBridge)((Object)((WorldInfoBridge)((Object)this)).bridge$getDimensionType())).bridge$shouldGenerateSpawnOnLoad();
            this.setGenerateSpawnOnLoad(shouldGenerateSpawn);
        }
        return shouldGenerateSpawn;
    }

    @Override
    public void setGenerateSpawnOnLoad(boolean state) {
        ((WorldInfoBridge)((Object)this)).bridge$getConfigAdapter().getConfig().getWorld().setGenerateSpawnOnLoad(state);
    }

    @Override
    public Collection<WorldGeneratorModifier> getGeneratorModifiers() {
        return WorldGeneratorModifierRegistryModule.getInstance().toModifiers(((WorldInfoBridge)((Object)this)).bridge$getConfigAdapter().getConfig().getWorldGenModifiers());
    }

    @Override
    public void setGeneratorModifiers(Collection<WorldGeneratorModifier> modifiers) {
        Preconditions.checkNotNull(modifiers, (Object)"modifiers");
        ((WorldInfoBridge)((Object)this)).bridge$getConfigAdapter().getConfig().getWorldGenModifiers().clear();
        ((WorldInfoBridge)((Object)this)).bridge$getConfigAdapter().getConfig().getWorldGenModifiers().addAll((Collection<String>)WorldGeneratorModifierRegistryModule.getInstance().toIds(modifiers));
    }

    @Override
    public DataContainer getGeneratorSettings() {
        try {
            return DataFormats.JSON.read(this.field_82576_c);
        }
        catch (JsonParseException | IOException throwable) {
            return DataContainer.createNew().set(Constants.Sponge.World.WORLD_CUSTOM_SETTINGS, (Object)this.field_82576_c);
        }
    }

    @Override
    public SerializationBehavior getSerializationBehavior() {
        return this.api$serializationBehavior;
    }

    @Override
    public void setSerializationBehavior(SerializationBehavior behavior) {
        this.api$serializationBehavior = behavior;
    }

    @Override
    public Optional<DataView> getPropertySection(DataQuery path) {
        if (((WorldInfoBridge)((Object)this)).bridge$getSpongeRootLevelNbt().func_74764_b(path.toString())) {
            try {
                NBTTagCompound property = ((WorldInfoBridge)((Object)this)).bridge$getSpongeRootLevelNbt().func_74775_l(path.toString());
                return Optional.of(NbtTranslator.getInstance().translateFrom(property));
            }
            catch (Exception e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public void setPropertySection(DataQuery path, DataView data) {
        NBTTagCompound nbt = NbtTranslator.getInstance().translateData(data);
        ((WorldInfoBridge)((Object)this)).bridge$getSpongeRootLevelNbt().func_74782_a(path.toString(), (NBTBase)nbt);
    }

    @Intrinsic
    public String worldproperties$getWorldName() {
        return this.shadow$func_76065_j();
    }

    @Override
    public DataContainer getAdditionalProperties() {
        NBTTagCompound additionalProperties = ((WorldInfoBridge)((Object)this)).bridge$getSpongeRootLevelNbt().func_74737_b();
        additionalProperties.func_82580_o("Sponge");
        return NbtTranslator.getInstance().translateFrom(additionalProperties);
    }
}

