/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.vehicle.minecart.TNTMinecart;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.entity.item.EntityMinecartMixin;

@Mixin(value={EntityMinecartTNT.class})
public abstract class EntityMinecartTNTMixin
extends EntityMinecartMixin
implements FusedExplosiveBridge,
ExplosiveBridge {
    @Shadow
    private int field_94106_a;
    @Nullable
    private Integer impl$explosionRadius = null;
    private int impl$fuseDuration = 80;
    private boolean impl$detonationCancelled;
    @Nullable
    private Object impl$primeCause;

    @Shadow
    public abstract void func_94105_c();

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.ofNullable(this.impl$explosionRadius);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.impl$explosionRadius = radius;
    }

    @Override
    public int bridge$getFuseDuration() {
        return this.impl$fuseDuration;
    }

    @Override
    public void bridge$setFuseDuration(int fuseTicks) {
        this.impl$fuseDuration = fuseTicks;
    }

    @Override
    public int bridge$getFuseTicksRemaining() {
        return this.field_94106_a;
    }

    @Override
    public void bridge$setFuseTicksRemaining(int fuseTicks) {
        this.field_94106_a = fuseTicks;
    }

    @Inject(method={"attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"}, at={@At(value="INVOKE")})
    private void onAttack(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> ci) {
        this.impl$primeCause = damageSource;
    }

    @Inject(method={"onActivatorRailPass(IIIZ)V"}, at={@At(value="INVOKE")})
    private void onActivate(int x, int y, int z, boolean receivingPower, CallbackInfo ci) {
        if (((WorldBridge)this.field_70170_p).bridge$isFake()) {
            return;
        }
        if (receivingPower) {
            ((org.spongepowered.api.world.World)this.field_70170_p).getNotifier(x, y, z).ifPresent(notifier -> {
                this.impl$primeCause = notifier;
            });
        }
    }

    @Inject(method={"ignite"}, at={@At(value="INVOKE")}, cancellable=true)
    private void preIgnite(CallbackInfo ci) {
        if (!this.bridge$shouldPrime()) {
            this.bridge$setFuseTicksRemaining(-1);
            ci.cancel();
        }
    }

    @Inject(method={"ignite"}, at={@At(value="RETURN")})
    private void postSpongeIgnite(CallbackInfo ci) {
        this.bridge$setFuseTicksRemaining(this.impl$fuseDuration);
        if (this.impl$primeCause != null) {
            Sponge.getCauseStackManager().pushCause(this.impl$primeCause);
        }
        this.bridge$postPrime();
        if (this.impl$primeCause != null) {
            Sponge.getCauseStackManager().popCause();
        }
    }

    @Redirect(method={"explodeCart"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFZ)Lnet/minecraft/world/Explosion;"))
    @Nullable
    private net.minecraft.world.Explosion onSpongeExplode(World worldObj, Entity self, double x, double y, double z, float strength, boolean smoking) {
        return SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().location(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)worldObj, new Vector3d(x, y, z))).sourceExplosive((TNTMinecart)((Object)this)).radius(this.impl$explosionRadius != null ? (float)this.impl$explosionRadius.intValue() : strength).shouldPlaySmoke(smoking).shouldBreakBlocks(smoking)).orElseGet(() -> {
            this.impl$detonationCancelled = true;
            return null;
        });
    }

    @Inject(method={"explodeCart"}, at={@At(value="RETURN")})
    private void postExplode(CallbackInfo ci) {
        if (this.impl$detonationCancelled) {
            this.field_70128_L = false;
            this.impl$detonationCancelled = false;
        }
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityMinecartTNT;explodeCart(D)V")})
    private void onAttackEntityFrom(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(source);
            AttackEntityEvent event = SpongeEventFactory.createAttackEntityEvent(frame.getCurrentCause(), new ArrayList(), (TNTMinecart)((Object)this), 0, amount);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                cir.setReturnValue(true);
            }
        }
    }
}

