/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.server.management.PlayerProfileCacheBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.server.MinecraftServerMixin;

@Mixin(value={DedicatedServer.class})
public abstract class DedicatedServerMixin
extends MinecraftServerMixin {
    @Shadow
    private boolean field_71335_s;

    @Shadow
    public abstract int func_82357_ak();

    @Overwrite
    public void func_120011_ar() {
        this.field_71335_s = false;
    }

    @Inject(method={"systemExitNow"}, at={@At(value="HEAD")})
    private void postGameStoppingEvent(CallbackInfo ci) {
        SpongeImpl.postShutdownEvents();
    }

    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/dedicated/PropertyManager;getIntProperty(Ljava/lang/String;I)I"))
    private int fixWrongDefaultDifficulty(PropertyManager propertyManager, String key, int defaultValue) {
        if ("difficulty".equalsIgnoreCase(key)) {
            return propertyManager.func_73669_a(key, WorldInfo.field_176156_a.func_151525_a());
        }
        return propertyManager.func_73669_a(key, defaultValue);
    }

    @Overwrite
    public boolean func_175579_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        IPhaseState<?> phaseState = PhaseTracker.getInstance().getCurrentState();
        if (!phaseState.isInteraction() && SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)worldIn, pos, (Object)playerIn).isCancelled()) {
            return true;
        }
        BlockPos spawnPoint = worldIn.func_175694_M();
        int protectionRadius = this.func_82357_ak();
        return protectionRadius > 0 && Math.max(Math.abs(pos.func_177958_n() - spawnPoint.func_177958_n()), Math.abs(pos.func_177952_p() - spawnPoint.func_177952_p())) <= protectionRadius && !((Player)playerIn).hasPermission("minecraft.spawn-protection.override");
    }

    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerProfileCache;save()V"))
    private void onSave(PlayerProfileCache cache) {
        ((PlayerProfileCacheBridge)this.func_152358_ax()).bridge$setCanSave(true);
        this.func_152358_ax().func_152658_c();
        ((PlayerProfileCacheBridge)this.func_152358_ax()).bridge$setCanSave(false);
    }
}

