/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import java.nio.file.Path;
import net.minecraft.world.WorldProvider;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.world.DimensionTypeBridge;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.DimensionConfig;
import org.spongepowered.common.registry.type.world.DimensionTypeRegistryModule;
import org.spongepowered.common.world.WorldManager;

@Mixin(value={net.minecraft.world.DimensionType.class})
public abstract class DimensionTypeMixin
implements DimensionTypeBridge {
    private String impl$sanitizedId;
    private Path impl$configPath;
    private SpongeConfig<DimensionConfig> impl$config;
    private volatile Context impl$context;
    private boolean impl$generateSpawnOnLoad;
    private boolean impl$loadSpawn;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$setUpBridgeFields(String enumName, int ordinal, int idIn, String nameIn, String suffixIn, Class<? extends WorldProvider> clazzIn, CallbackInfo ci) {
        String dimName = enumName.toLowerCase().replace(" ", "_").replaceAll("[^A-Za-z0-9_]", "");
        String modId = SpongeImplHooks.getModIdFromClass(clazzIn);
        this.impl$configPath = SpongeImpl.getSpongeConfigDir().resolve("worlds").resolve(modId).resolve(dimName);
        this.impl$config = new SpongeConfig(SpongeConfig.Type.DIMENSION, this.impl$configPath.resolve("dimension.conf"), "sponge", SpongeImpl.getGlobalConfigAdapter(), false);
        this.impl$loadSpawn = this.impl$generateSpawnOnLoad = idIn == 0;
        this.impl$config.getConfig().getWorld().setGenerateSpawnOnLoad(this.impl$generateSpawnOnLoad);
        this.impl$sanitizedId = modId + ":" + dimName;
        String contextId = this.impl$sanitizedId.replace(":", ".");
        this.impl$context = new Context("dimension", contextId);
        if (!WorldManager.isDimensionRegistered(idIn)) {
            DimensionTypeRegistryModule.getInstance().registerAdditionalCatalog((DimensionType)((Object)this));
        }
    }

    @Override
    public boolean bridge$shouldGenerateSpawnOnLoad() {
        return this.impl$generateSpawnOnLoad;
    }

    @Override
    public boolean bridge$shouldLoadSpawn() {
        return this.impl$loadSpawn;
    }

    @Override
    public void setShouldLoadSpawn(boolean keepSpawnLoaded) {
        this.impl$loadSpawn = keepSpawnLoaded;
    }

    @Override
    public String bridge$getSanitizedId() {
        return this.impl$sanitizedId;
    }

    @Override
    public Path bridge$getConfigPath() {
        return this.impl$configPath;
    }

    @Override
    public SpongeConfig<DimensionConfig> bridge$getDimensionConfig() {
        return this.impl$config;
    }

    @Override
    public Context bridge$getContext() {
        return this.impl$context;
    }

    @Overwrite
    public static net.minecraft.world.DimensionType func_186069_a(int dimensionTypeId) {
        return WorldManager.getDimensionTypeByTypeId(dimensionTypeId).orElseThrow(() -> new IllegalArgumentException("Invalid dimension id " + dimensionTypeId));
    }
}

