/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen;

import com.flowpowered.math.vector.Vector3i;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import org.spongepowered.api.world.SerializationBehaviors;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderServerBridge;
import org.spongepowered.common.config.category.WorldCategory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.generation.GenericGenerationContext;
import org.spongepowered.common.util.CachedLong2ObjectMap;
import org.spongepowered.common.world.SpongeEmptyChunk;
import org.spongepowered.common.world.storage.WorldStorageUtil;

@Mixin(value={ChunkProviderServer.class})
public abstract class ChunkProviderServerMixin
implements ChunkProviderServerBridge,
ChunkProviderBridge {
    @Nullable
    private SpongeEmptyChunk impl$EMPTY_CHUNK;
    private boolean impl$denyChunkRequests = true;
    private boolean impl$forceChunkRequests = false;
    private long impl$chunkUnloadDelay = 15000L;
    private int impl$maxChunkUnloads = 100;
    @Shadow
    @Final
    private WorldServer field_73251_h;
    @Shadow
    @Final
    private IChunkLoader field_73247_e;
    @Shadow
    @Final
    @Mutable
    private Long2ObjectMap<Chunk> field_73244_f = new CachedLong2ObjectMap();

    @Shadow
    @Nullable
    public abstract Chunk func_186026_b(int var1, int var2);

    @Shadow
    @Nullable
    public abstract Chunk func_186028_c(int var1, int var2);

    @Shadow
    protected abstract void func_73243_a(Chunk var1);

    @Shadow
    protected abstract void func_73242_b(Chunk var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$setUpCommonFields(WorldServer worldObjIn, IChunkLoader chunkLoaderIn, IChunkGenerator chunkGeneratorIn, CallbackInfo ci) {
        if (((WorldBridge)worldObjIn).bridge$isFake()) {
            return;
        }
        this.impl$EMPTY_CHUNK = new SpongeEmptyChunk((World)worldObjIn, 0, 0);
        WorldCategory worldCategory = ((WorldInfoBridge)this.field_73251_h.func_72912_H()).bridge$getConfigAdapter().getConfig().getWorld();
        ((WorldServerBridge)worldObjIn).bridge$updateConfigCache();
        this.impl$denyChunkRequests = worldCategory.getDenyChunkRequests();
        this.impl$chunkUnloadDelay = worldCategory.getChunkUnloadDelay() * 1000L;
        this.impl$maxChunkUnloads = worldCategory.getMaxChunkUnloads();
    }

    @Override
    public CompletableFuture<Boolean> bridge$doesChunkExistSync(Vector3i chunkCoords) {
        return WorldStorageUtil.doesChunkExistSync(this.field_73251_h, this.field_73247_e, chunkCoords);
    }

    @Overwrite
    public void func_189549_a(Chunk chunkIn) {
        if (!((ChunkBridge)chunkIn).bridge$isPersistedChunk() && this.field_73251_h.field_73011_w.func_186056_c(chunkIn.field_76635_g, chunkIn.field_76647_h)) {
            chunkIn.field_189550_d = true;
        }
    }

    @Redirect(method={"provideChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/gen/ChunkProviderServer;loadChunk(II)Lnet/minecraft/world/chunk/Chunk;"))
    @Nullable
    private Chunk impl$ProvideChunkForced(ChunkProviderServer chunkProviderServer, int x, int z) {
        if (!this.impl$denyChunkRequests) {
            return this.func_186028_c(x, z);
        }
        Chunk chunk = this.func_186026_b(x, z);
        if (chunk == null && this.impl$canDenyChunkRequest()) {
            return this.impl$EMPTY_CHUNK;
        }
        if (chunk == null) {
            chunk = this.bridge$loadChunkForce(x, z);
        }
        return chunk;
    }

    @Inject(method={"provideChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/ChunkPos;asLong(II)J")})
    private void impl$StartTerrainGenerationPhase(int x, int z, CallbackInfoReturnable<Chunk> cir) {
        ((GenericGenerationContext)GenerationPhase.State.TERRAIN_GENERATION.createPhaseContext().world((World)this.field_73251_h)).buildAndSwitch();
    }

    @Inject(method={"provideChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;populate(Lnet/minecraft/world/chunk/IChunkProvider;Lnet/minecraft/world/gen/IChunkGenerator;)V", shift=At.Shift.AFTER)})
    private void impl$EndTerrainGenerationPhase(int x, int z, CallbackInfoReturnable<Chunk> ci) {
        PhaseTracker.getInstance().getCurrentContext().close();
    }

    @Inject(method={"provideChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/crash/CrashReportCategory;addCrashSection(Ljava/lang/String;Ljava/lang/Object;)V", ordinal=2, shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void impl$StopGenerationPhaseFromError(int x, int z, CallbackInfoReturnable<Chunk> cir, Chunk ungenerated, long chunkIndex, Throwable error, CrashReport report, CrashReportCategory chunkGenerationCategory) {
        PhaseContext<?> currentContext = PhaseTracker.getInstance().getCurrentContext();
        report.func_85057_a("Current PhaseState", 1).func_189529_a(currentContext.state.toString(), () -> {
            PrettyPrinter printer = new PrettyPrinter(50);
            PhaseTracker.CONTEXT_PRINTER.accept(printer, currentContext);
            try (PrintStream stream = new PrintStream(new ByteArrayOutputStream());){
                printer.print(stream);
                String string = stream.toString();
                return string;
            }
        });
        currentContext.close();
    }

    private boolean impl$canDenyChunkRequest() {
        if (!SpongeImpl.getServer().func_152345_ab()) {
            return true;
        }
        if (this.impl$forceChunkRequests) {
            return false;
        }
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> currentState = phaseTracker.getCurrentState();
        return currentState.doesDenyChunkRequests();
    }

    @Override
    public boolean bridge$getForceChunkRequests() {
        return this.impl$forceChunkRequests;
    }

    @Override
    public void bridge$setMaxChunkUnloads(int maxUnloads) {
        this.impl$maxChunkUnloads = maxUnloads;
    }

    @Override
    public void bridge$setForceChunkRequests(boolean flag) {
        this.impl$forceChunkRequests = flag;
    }

    @Override
    public void bridge$setDenyChunkRequests(boolean flag) {
        this.impl$denyChunkRequests = flag;
    }

    @Override
    public long bridge$getChunkUnloadDelay() {
        return this.impl$chunkUnloadDelay;
    }

    @Overwrite
    public boolean func_73156_b() {
        if (!this.field_73251_h.field_73058_d && !((WorldBridge)this.field_73251_h).bridge$isFake()) {
            ((WorldServerBridge)this.field_73251_h).bridge$getTimingsHandler().doChunkUnload.startTiming();
            ObjectIterator iterator = this.field_73244_f.values().iterator();
            int chunksUnloaded = 0;
            long now = System.currentTimeMillis();
            while (chunksUnloaded < this.impl$maxChunkUnloads && iterator.hasNext()) {
                Chunk chunk = (Chunk)iterator.next();
                ChunkBridge spongeChunk = (ChunkBridge)chunk;
                if (chunk == null || !chunk.field_189550_d || spongeChunk.bridge$isPersistedChunk()) continue;
                if (this.bridge$getChunkUnloadDelay() > 0L) {
                    if (now - spongeChunk.bridge$getScheduledForUnload() < this.impl$chunkUnloadDelay) continue;
                    spongeChunk.bridge$setScheduledForUnload(-1L);
                }
                chunk.func_76623_d();
                this.func_73242_b(chunk);
                this.func_73243_a(chunk);
                iterator.remove();
                ++chunksUnloaded;
            }
            ((WorldServerBridge)this.field_73251_h).bridge$getTimingsHandler().doChunkUnload.stopTiming();
        }
        this.field_73247_e.func_75817_a();
        return false;
    }

    @Override
    public Chunk bridge$getLoadedChunkWithoutMarkingActive(int x, int z) {
        long i = ChunkPos.func_77272_a((int)x, (int)z);
        return (Chunk)this.field_73244_f.get(i);
    }

    @Inject(method={"canSave"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$IgnoreIfWorldSaveDisabled(CallbackInfoReturnable<Boolean> cir) {
        if (((WorldProperties)this.field_73251_h.func_72912_H()).getSerializationBehavior() == SerializationBehaviors.NONE) {
            cir.setReturnValue(false);
        }
    }

    @Inject(method={"saveChunkData"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$IgnoreIfWorldSaveDisabled(Chunk chunkIn, CallbackInfo ci) {
        if (((WorldProperties)this.field_73251_h.func_72912_H()).getSerializationBehavior() == SerializationBehaviors.NONE) {
            ci.cancel();
        }
    }

    @Inject(method={"flushToDisk"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$IgnoreIfWorldSaveDisabled(CallbackInfo ci) {
        if (((WorldProperties)this.field_73251_h.func_72912_H()).getSerializationBehavior() == SerializationBehaviors.NONE) {
            ci.cancel();
        }
    }

    @Override
    public void bridge$unloadChunkAndSave(Chunk chunk) {
        boolean saveChunk = false;
        if (chunk.func_76601_a(true)) {
            saveChunk = true;
        }
        chunk.func_76623_d();
        if (saveChunk) {
            this.func_73242_b(chunk);
        }
        this.field_73244_f.remove(ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h));
        ((ChunkBridge)chunk).bridge$setScheduledForUnload(-1L);
    }
}

