/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollisions;

import net.minecraft.block.Block;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.CollisionModCategory;
import org.spongepowered.common.config.category.EntityCollisionCategory;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.mixin.plugin.entitycollisions.interfaces.CollisionsCapability;

@Mixin(value={Block.class})
public abstract class BlockMixin_Collisions
implements CollisionsCapability {
    private int collision$maxCollisions = 8;
    private String collision$modId;
    private String collision$modBlockName;
    private boolean collision$refreshCache = true;

    @Override
    public int collision$getMaxCollisions() {
        return this.collision$maxCollisions;
    }

    @Override
    public void collision$setMaxCollisions(int max) {
        this.collision$maxCollisions = max;
    }

    @Override
    public void collision$setModDataName(String name) {
        this.collision$modBlockName = name;
    }

    @Override
    public String collision$getModDataId() {
        return this.collision$modId;
    }

    @Override
    public void collision$setModDataId(String id) {
        this.collision$modId = id;
    }

    @Override
    public void collision$requiresCollisionsCacheRefresh(boolean flag) {
        this.collision$refreshCache = flag;
    }

    @Override
    public boolean collision$requiresCollisionsCacheRefresh() {
        return this.collision$refreshCache;
    }

    @Override
    public void collision$initializeCollisionState(World world) {
        SpongeConfig<WorldConfig> worldConfigAdapter = ((WorldInfoBridge)world.func_72912_H()).bridge$getConfigAdapter();
        SpongeConfig<GlobalConfig> globalConfigAdapter = SpongeImpl.getGlobalConfigAdapter();
        EntityCollisionCategory worldCollCat = worldConfigAdapter.getConfig().getEntityCollisionCategory();
        EntityCollisionCategory globalCollCat = globalConfigAdapter.getConfig().getEntityCollisionCategory();
        this.collision$setMaxCollisions(worldCollCat.getMaxEntitiesWithinAABB());
        boolean requiresSave = false;
        String[] ids = ((BlockType)((Object)this)).getId().split(":");
        String modId = ids[0];
        String name = ids[1];
        CollisionModCategory worldCollMod = worldCollCat.getModList().get(modId);
        CollisionModCategory globalCollMod = globalCollCat.getModList().get(modId);
        if (worldCollMod == null && worldCollCat.autoPopulateData()) {
            globalCollMod = new CollisionModCategory(modId);
            globalCollCat.getModList().put(modId, globalCollMod);
            globalCollMod.getBlockList().put(name, this.collision$getMaxCollisions());
            globalConfigAdapter.save();
            return;
        }
        if (worldCollMod != null) {
            Integer blockMaxCollision;
            if (!worldCollMod.isEnabled()) {
                this.collision$setMaxCollisions(-1);
                return;
            }
            Integer modCollisionMax = worldCollMod.getDefaultMaxCollisions().get("blocks");
            if (modCollisionMax != null) {
                this.collision$setMaxCollisions(modCollisionMax);
            }
            if ((blockMaxCollision = worldCollMod.getBlockList().get(name)) == null && worldCollCat.autoPopulateData()) {
                globalCollMod.getBlockList().put(name, this.collision$getMaxCollisions());
                requiresSave = true;
            } else if (blockMaxCollision != null) {
                this.collision$setMaxCollisions(blockMaxCollision);
            }
        }
        if (this.collision$getMaxCollisions() <= 0) {
            return;
        }
        if (requiresSave) {
            globalConfigAdapter.save();
        }
    }
}

